"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const inversify_1 = require("inversify");
const common_1 = require("@theia/core/lib/common");
const trace_server_config_1 = require("../common/trace-server-config");
const trace_server_config_2 = require("../common/trace-server-config");
const backend_file_service_1 = require("../common/backend-file-service");
const backend_file_service_impl_1 = require("./backend-file-service-impl");
exports.default = new inversify_1.ContainerModule(bind => {
    bind(backend_file_service_1.BackendFileService).to(backend_file_service_impl_1.BackendFileServiceImpl).inSingletonScope();
    bind(common_1.ConnectionHandler).toDynamicValue(ctx => new common_1.JsonRpcConnectionHandler(trace_server_config_1.traceServerPath, () => ctx.container.get(trace_server_config_2.TraceServerConfigService))).inSingletonScope();
    bind(common_1.ConnectionHandler).toDynamicValue(ctx => new common_1.JsonRpcConnectionHandler(backend_file_service_1.backendFileServicePath, () => ctx.container.get(backend_file_service_1.BackendFileService))).inSingletonScope();
});
//# sourceMappingURL=viewer-prototype-backend-module.js.map