"use strict";
// *****************************************************************************
// Copyright (C) 2018 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AboutDialog = exports.AboutDialogProps = exports.ABOUT_EXTENSIONS_CLASS = exports.ABOUT_CONTENT_CLASS = void 0;
const React = require("react");
const inversify_1 = require("inversify");
const dialogs_1 = require("./dialogs");
const react_dialog_1 = require("./dialogs/react-dialog");
const application_protocol_1 = require("../common/application-protocol");
const frontend_application_config_provider_1 = require("./frontend-application-config-provider");
const api_1 = require("@theia/application-package/lib/api");
const window_service_1 = require("./window/window-service");
const keys_1 = require("./keys");
const nls_1 = require("../common/nls");
exports.ABOUT_CONTENT_CLASS = 'theia-aboutDialog';
exports.ABOUT_EXTENSIONS_CLASS = 'theia-aboutExtensions';
let AboutDialogProps = class AboutDialogProps extends dialogs_1.DialogProps {
};
AboutDialogProps = __decorate([
    (0, inversify_1.injectable)()
], AboutDialogProps);
exports.AboutDialogProps = AboutDialogProps;
let AboutDialog = class AboutDialog extends react_dialog_1.ReactDialog {
    constructor(props) {
        super({
            title: frontend_application_config_provider_1.FrontendApplicationConfigProvider.get().applicationName,
        });
        this.props = props;
        this.extensionsInfos = [];
        /**
         * Open a link in an external window.
         * @param url the link.
         */
        this.doOpenExternalLink = (url) => this.windowService.openNewWindow(url, { external: true });
        this.doOpenExternalLinkEnter = (e, url) => {
            if (this.isEnterKey(e)) {
                this.doOpenExternalLink(url);
            }
        };
        this.appendAcceptButton(dialogs_1.Dialog.OK);
    }
    async init() {
        this.applicationInfo = await this.appServer.getApplicationInfo();
        this.extensionsInfos = await this.appServer.getExtensionsInfos();
        this.update();
    }
    renderHeader() {
        const applicationInfo = this.applicationInfo;
        const compatibilityUrl = 'https://eclipse-theia.github.io/vscode-theia-comparator/status.html';
        const detailsLabel = nls_1.nls.localizeByDefault('Details');
        const versionLabel = nls_1.nls.localizeByDefault('Version');
        const defaultApiLabel = nls_1.nls.localize('theia/core/about/defaultApi', 'Default {0} API', 'VS Code');
        const compatibilityLabel = nls_1.nls.localize('theia/core/about/compatibility', '{0} Compatibility', 'VS Code');
        return React.createElement(React.Fragment, null,
            React.createElement("h3", null, detailsLabel),
            React.createElement("div", { className: 'about-details' },
                applicationInfo && React.createElement("p", null, `${versionLabel}: ${applicationInfo.version}`),
                React.createElement("p", null, `${defaultApiLabel}: ${api_1.DEFAULT_SUPPORTED_API_VERSION}`),
                React.createElement("p", null,
                    React.createElement("a", { role: 'button', tabIndex: 0, onClick: () => this.doOpenExternalLink(compatibilityUrl), onKeyDown: (e) => this.doOpenExternalLinkEnter(e, compatibilityUrl) }, compatibilityLabel))));
    }
    renderExtensions() {
        const extensionsInfos = this.extensionsInfos;
        return React.createElement(React.Fragment, null,
            React.createElement("h3", null, "List of extensions"),
            React.createElement("ul", { className: exports.ABOUT_EXTENSIONS_CLASS }, extensionsInfos
                .sort((a, b) => a.name.toLowerCase().localeCompare(b.name.toLowerCase()))
                .map((extension) => React.createElement("li", { key: extension.name },
                extension.name,
                " ",
                extension.version))));
    }
    render() {
        return React.createElement("div", { className: exports.ABOUT_CONTENT_CLASS },
            this.renderHeader(),
            this.renderExtensions());
    }
    onAfterAttach(msg) {
        super.onAfterAttach(msg);
        this.update();
    }
    isEnterKey(e) {
        var _a;
        return keys_1.Key.ENTER.keyCode === ((_a = keys_1.KeyCode.createKeyCode(e.nativeEvent).key) === null || _a === void 0 ? void 0 : _a.keyCode);
    }
    get value() { return undefined; }
};
__decorate([
    (0, inversify_1.inject)(application_protocol_1.ApplicationServer),
    __metadata("design:type", Object)
], AboutDialog.prototype, "appServer", void 0);
__decorate([
    (0, inversify_1.inject)(window_service_1.WindowService),
    __metadata("design:type", Object)
], AboutDialog.prototype, "windowService", void 0);
__decorate([
    (0, inversify_1.postConstruct)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], AboutDialog.prototype, "init", null);
AboutDialog = __decorate([
    (0, inversify_1.injectable)(),
    __param(0, (0, inversify_1.inject)(AboutDialogProps)),
    __metadata("design:paramtypes", [AboutDialogProps])
], AboutDialog);
exports.AboutDialog = AboutDialog;
//# sourceMappingURL=about-dialog.js.map