"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setUpPluginApi = void 0;
const command_registry_main_1 = require("./command-registry-main");
const preference_registry_main_1 = require("./preference-registry-main");
const quick_open_main_1 = require("./quick-open-main");
const plugin_api_rpc_1 = require("../../common/plugin-api-rpc");
const message_registry_main_1 = require("./message-registry-main");
const window_state_main_1 = require("./window-state-main");
const workspace_main_1 = require("./workspace-main");
const status_bar_message_registry_main_1 = require("./status-bar-message-registry-main");
const env_main_1 = require("./env-main");
const editors_and_documents_main_1 = require("./editors-and-documents-main");
const terminal_main_1 = require("./terminal-main");
const dialogs_main_1 = require("./dialogs-main");
const tree_views_main_1 = require("./view/tree-views-main");
const notification_main_1 = require("./notification-main");
const connection_1 = require("../../common/connection");
const webviews_main_1 = require("./webviews-main");
const tasks_main_1 = require("./tasks-main");
const plugin_storage_1 = require("./plugin-storage");
const debug_main_1 = require("./debug/debug-main");
const file_system_main_impl_1 = require("./file-system-main-impl");
const scm_main_1 = require("./scm-main");
const decorations_main_1 = require("./decorations/decorations-main");
const clipboard_main_1 = require("./clipboard-main");
const documents_main_1 = require("./documents-main");
const text_editors_main_1 = require("./text-editors-main");
const browser_1 = require("@theia/editor/lib/browser");
const text_editor_model_service_1 = require("./text-editor-model-service");
const opener_service_1 = require("@theia/core/lib/browser/opener-service");
const application_shell_1 = require("@theia/core/lib/browser/shell/application-shell");
const monaco_bulk_edit_service_1 = require("@theia/monaco/lib/browser/monaco-bulk-edit-service");
const monaco_editor_service_1 = require("@theia/monaco/lib/browser/monaco-editor-service");
const untitled_resource_1 = require("./editor/untitled-resource");
const main_file_system_event_service_1 = require("./main-file-system-event-service");
const label_service_main_1 = require("./label-service-main");
const timeline_main_1 = require("./timeline-main");
const authentication_main_1 = require("./authentication-main");
const theming_main_1 = require("./theming-main");
const comments_main_1 = require("./comments/comments-main");
const custom_editors_main_1 = require("./custom-editors/custom-editors-main");
const secrets_main_1 = require("./secrets-main");
const webview_views_main_1 = require("./webview-views/webview-views-main");
function setUpPluginApi(rpc, container) {
    const authenticationMain = new authentication_main_1.AuthenticationMainImpl(rpc, container);
    rpc.set(plugin_api_rpc_1.PLUGIN_RPC_CONTEXT.AUTHENTICATION_MAIN, authenticationMain);
    const commandRegistryMain = new command_registry_main_1.CommandRegistryMainImpl(rpc, container);
    rpc.set(plugin_api_rpc_1.PLUGIN_RPC_CONTEXT.COMMAND_REGISTRY_MAIN, commandRegistryMain);
    const quickOpenMain = new quick_open_main_1.QuickOpenMainImpl(rpc, container);
    rpc.set(plugin_api_rpc_1.PLUGIN_RPC_CONTEXT.QUICK_OPEN_MAIN, quickOpenMain);
    const workspaceMain = new workspace_main_1.WorkspaceMainImpl(rpc, container);
    rpc.set(plugin_api_rpc_1.PLUGIN_RPC_CONTEXT.WORKSPACE_MAIN, workspaceMain);
    const dialogsMain = new dialogs_main_1.DialogsMainImpl(rpc, container);
    rpc.set(plugin_api_rpc_1.PLUGIN_RPC_CONTEXT.DIALOGS_MAIN, dialogsMain);
    const messageRegistryMain = new message_registry_main_1.MessageRegistryMainImpl(container);
    rpc.set(plugin_api_rpc_1.PLUGIN_RPC_CONTEXT.MESSAGE_REGISTRY_MAIN, messageRegistryMain);
    const preferenceRegistryMain = new preference_registry_main_1.PreferenceRegistryMainImpl(rpc, container);
    rpc.set(plugin_api_rpc_1.PLUGIN_RPC_CONTEXT.PREFERENCE_REGISTRY_MAIN, preferenceRegistryMain);
    const editorsAndDocuments = new editors_and_documents_main_1.EditorsAndDocumentsMain(rpc, container);
    const modelService = container.get(text_editor_model_service_1.EditorModelService);
    const editorManager = container.get(browser_1.EditorManager);
    const openerService = container.get(opener_service_1.OpenerService);
    const shell = container.get(application_shell_1.ApplicationShell);
    const untitledResourceResolver = container.get(untitled_resource_1.UntitledResourceResolver);
    const documentsMain = new documents_main_1.DocumentsMainImpl(editorsAndDocuments, modelService, rpc, editorManager, openerService, shell, untitledResourceResolver);
    rpc.set(plugin_api_rpc_1.PLUGIN_RPC_CONTEXT.DOCUMENTS_MAIN, documentsMain);
    const bulkEditService = container.get(monaco_bulk_edit_service_1.MonacoBulkEditService);
    const monacoEditorService = container.get(monaco_editor_service_1.MonacoEditorService);
    const editorsMain = new text_editors_main_1.TextEditorsMainImpl(editorsAndDocuments, rpc, bulkEditService, monacoEditorService);
    rpc.set(plugin_api_rpc_1.PLUGIN_RPC_CONTEXT.TEXT_EDITORS_MAIN, editorsMain);
    // start listening only after all clients are subscribed to events
    editorsAndDocuments.listen();
    const statusBarMessageRegistryMain = new status_bar_message_registry_main_1.StatusBarMessageRegistryMainImpl(container);
    rpc.set(plugin_api_rpc_1.PLUGIN_RPC_CONTEXT.STATUS_BAR_MESSAGE_REGISTRY_MAIN, statusBarMessageRegistryMain);
    const envMain = new env_main_1.EnvMainImpl(rpc, container);
    rpc.set(plugin_api_rpc_1.PLUGIN_RPC_CONTEXT.ENV_MAIN, envMain);
    const notificationMain = new notification_main_1.NotificationMainImpl(rpc, container);
    rpc.set(plugin_api_rpc_1.PLUGIN_RPC_CONTEXT.NOTIFICATION_MAIN, notificationMain);
    const terminalMain = new terminal_main_1.TerminalServiceMainImpl(rpc, container);
    rpc.set(plugin_api_rpc_1.PLUGIN_RPC_CONTEXT.TERMINAL_MAIN, terminalMain);
    const treeViewsMain = new tree_views_main_1.TreeViewsMainImpl(rpc, container);
    rpc.set(plugin_api_rpc_1.PLUGIN_RPC_CONTEXT.TREE_VIEWS_MAIN, treeViewsMain);
    const outputChannelRegistryFactory = container.get(plugin_api_rpc_1.OutputChannelRegistryFactory);
    const outputChannelRegistryMain = outputChannelRegistryFactory();
    rpc.set(plugin_api_rpc_1.PLUGIN_RPC_CONTEXT.OUTPUT_CHANNEL_REGISTRY_MAIN, outputChannelRegistryMain);
    const languagesMainFactory = container.get(plugin_api_rpc_1.LanguagesMainFactory);
    const languagesMain = languagesMainFactory(rpc);
    rpc.set(plugin_api_rpc_1.PLUGIN_RPC_CONTEXT.LANGUAGES_MAIN, languagesMain);
    const webviewsMain = new webviews_main_1.WebviewsMainImpl(rpc, container);
    rpc.set(plugin_api_rpc_1.PLUGIN_RPC_CONTEXT.WEBVIEWS_MAIN, webviewsMain);
    const customEditorsMain = new custom_editors_main_1.CustomEditorsMainImpl(rpc, container, webviewsMain);
    rpc.set(plugin_api_rpc_1.PLUGIN_RPC_CONTEXT.CUSTOM_EDITORS_MAIN, customEditorsMain);
    const webviewViewsMain = new webview_views_main_1.WebviewViewsMainImpl(rpc, container, webviewsMain);
    rpc.set(plugin_api_rpc_1.PLUGIN_RPC_CONTEXT.WEBVIEW_VIEWS_MAIN, webviewViewsMain);
    const storageMain = new plugin_storage_1.StorageMainImpl(container);
    rpc.set(plugin_api_rpc_1.PLUGIN_RPC_CONTEXT.STORAGE_MAIN, storageMain);
    const connectionMain = new connection_1.ConnectionImpl(rpc.getProxy(plugin_api_rpc_1.MAIN_RPC_CONTEXT.CONNECTION_EXT));
    rpc.set(plugin_api_rpc_1.PLUGIN_RPC_CONTEXT.CONNECTION_MAIN, connectionMain);
    const tasksMain = new tasks_main_1.TasksMainImpl(rpc, container);
    rpc.set(plugin_api_rpc_1.PLUGIN_RPC_CONTEXT.TASKS_MAIN, tasksMain);
    const debugMain = new debug_main_1.DebugMainImpl(rpc, connectionMain, container);
    rpc.set(plugin_api_rpc_1.PLUGIN_RPC_CONTEXT.DEBUG_MAIN, debugMain);
    const fs = new file_system_main_impl_1.FileSystemMainImpl(rpc, container);
    const fsEventService = new main_file_system_event_service_1.MainFileSystemEventService(rpc, container);
    const disposeFS = fs.dispose.bind(fs);
    fs.dispose = () => {
        fsEventService.dispose();
        disposeFS();
    };
    rpc.set(plugin_api_rpc_1.PLUGIN_RPC_CONTEXT.FILE_SYSTEM_MAIN, fs);
    const scmMain = new scm_main_1.ScmMainImpl(rpc, container);
    rpc.set(plugin_api_rpc_1.PLUGIN_RPC_CONTEXT.SCM_MAIN, scmMain);
    const secretsMain = new secrets_main_1.SecretsMainImpl(rpc, container);
    rpc.set(plugin_api_rpc_1.PLUGIN_RPC_CONTEXT.SECRETS_MAIN, secretsMain);
    const decorationsMain = new decorations_main_1.DecorationsMainImpl(rpc, container);
    rpc.set(plugin_api_rpc_1.PLUGIN_RPC_CONTEXT.DECORATIONS_MAIN, decorationsMain);
    const windowMain = new window_state_main_1.WindowStateMain(rpc, container);
    rpc.set(plugin_api_rpc_1.PLUGIN_RPC_CONTEXT.WINDOW_MAIN, windowMain);
    const clipboardMain = new clipboard_main_1.ClipboardMainImpl(container);
    rpc.set(plugin_api_rpc_1.PLUGIN_RPC_CONTEXT.CLIPBOARD_MAIN, clipboardMain);
    const labelServiceMain = new label_service_main_1.LabelServiceMainImpl(container);
    rpc.set(plugin_api_rpc_1.PLUGIN_RPC_CONTEXT.LABEL_SERVICE_MAIN, labelServiceMain);
    const timelineMain = new timeline_main_1.TimelineMainImpl(rpc, container);
    rpc.set(plugin_api_rpc_1.PLUGIN_RPC_CONTEXT.TIMELINE_MAIN, timelineMain);
    const themingMain = new theming_main_1.ThemingMainImpl(rpc);
    rpc.set(plugin_api_rpc_1.PLUGIN_RPC_CONTEXT.THEMING_MAIN, themingMain);
    const commentsMain = new comments_main_1.CommentsMainImp(rpc, container);
    rpc.set(plugin_api_rpc_1.PLUGIN_RPC_CONTEXT.COMMENTS_MAIN, commentsMain);
}
exports.setUpPluginApi = setUpPluginApi;
//# sourceMappingURL=main-context.js.map