/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.generator.ui.launcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.pde.launching.EclipseApplicationLaunchConfiguration;
import org.eclipse.swtbot.generator.ui.GeneratorUIPlugin;
import org.eclipse.swtbot.generator.ui.Messages;
import org.osgi.framework.Bundle;

public class TestRecorderLaunchConfiguration
extends EclipseApplicationLaunchConfiguration {
    public static final String RECORDER_ENABLEMENT = " -Dorg.eclipse.swtbot.generator.enable=" + Boolean.toString(true);

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        ILaunchConfigurationWorkingCopy c = configuration.getWorkingCopy();
        String currentAttributes = (String)c.getAttributes().get(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS);
        c.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, String.valueOf(currentAttributes) + RECORDER_ENABLEMENT);
        super.launch((ILaunchConfiguration)c, mode, launch, monitor);
    }

    public String[] getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        String[] res = super.getProgramArguments(configuration);
        File configFile = new File(this.getConfigDir(configuration), "config.ini");
        Properties configProperties = new Properties();
        FileInputStream configInputStream = null;
        try {
            try {
                configInputStream = new FileInputStream(configFile);
                configProperties.load(configInputStream);
            }
            catch (Exception ex) {
                throw new CoreException((IStatus)new Status(4, GeneratorUIPlugin.getDefault().getBundle().getSymbolicName(), Messages.errorWhileConfiguratingRuntime, (Throwable)ex));
            }
        }
        catch (Throwable throwable) {
            if (configInputStream != null) {
                try {
                    ((InputStream)configInputStream).close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (configInputStream != null) {
            try {
                ((InputStream)configInputStream).close();
            }
            catch (Exception exception) {}
        }
        HashSet<String> additionalBundles = new HashSet<String>();
        additionalBundles.add("org.eclipse.swtbot.generator");
        StringBuilder bundles = new StringBuilder(configProperties.getProperty("osgi.bundles", ""));
        for (String additionalBundle : additionalBundles) {
            Bundle bundle = Platform.getBundle((String)additionalBundle);
            try {
                URL rootUrl = bundle.getEntry("/");
                URL fileRootUrl = FileLocator.toFileURL((URL)rootUrl);
                bundles.append(",reference:file:");
                bundles.append(fileRootUrl.getFile());
            }
            catch (IOException ex) {
                throw new CoreException((IStatus)new Status(4, GeneratorUIPlugin.getDefault().getBundle().getSymbolicName(), ex.getMessage(), (Throwable)ex));
            }
        }
        configProperties.put("osgi.bundles", bundles.toString());
        FileOutputStream configOutputStream = null;
        try {
            try {
                configOutputStream = new FileOutputStream(configFile);
                configProperties.store(configOutputStream, "Test Recorder");
            }
            catch (Exception ex) {
                throw new CoreException((IStatus)new Status(4, GeneratorUIPlugin.getDefault().getBundle().getSymbolicName(), Messages.errorWhileConfiguratingRuntime, (Throwable)ex));
            }
        }
        catch (Throwable throwable) {
            if (configOutputStream != null) {
                try {
                    ((OutputStream)configOutputStream).close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (configOutputStream != null) {
            try {
                ((OutputStream)configOutputStream).close();
            }
            catch (Exception exception) {}
        }
        return res;
    }
}

