/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.generator.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtbot.generator.framework.GenerationRule;
import org.eclipse.swtbot.generator.framework.Generator;

public class BotGeneratorEventDispatcher
implements Listener {
    private Generator generator;
    private List<GenerationRule> generationRules;
    private List<CodeGenerationListener> listeners = new ArrayList<CodeGenerationListener>();
    private Shell ignoredShell;
    private boolean recording;
    private Event lastModifyEvent;

    public void setGenerator(Generator generator) {
        this.generator = generator;
        this.generationRules = generator.createRules();
    }

    public void handleEvent(Event event) {
        if (this.ignoredShell != null && event.widget instanceof Control && this.ignoredShell.equals(BotGeneratorEventDispatcher.getShell((Control)event.widget))) {
            return;
        }
        if (!(!(event.widget instanceof Control) || ((Control)event.widget).isFocusControl() && ((Control)event.widget).isVisible() && ((Control)event.widget).isEnabled())) {
            return;
        }
        if (this.lastModifyEvent != null && (event.type != 24 || event.widget != this.lastModifyEvent.widget)) {
            this.processRules(this.lastModifyEvent);
            this.lastModifyEvent = null;
        }
        if (event.type == 24) {
            Control control = (Control)event.widget;
            if (this.lastModifyEvent == null || this.lastModifyEvent.widget == control) {
                this.lastModifyEvent = event;
                return;
            }
        }
        this.processRules(event);
    }

    private void processRules(Event event) {
        for (GenerationRule rule : this.generationRules) {
            if (!rule.appliesTo(event)) continue;
            rule.initializeForEvent(event);
            this.dispatchCodeGenerated(rule.generateCode());
        }
    }

    private static Shell getShell(Control widget) {
        while (widget != null) {
            if (widget.getParent() == null) {
                return (Shell)widget;
            }
            widget = widget.getParent();
        }
        return null;
    }

    private void dispatchCodeGenerated(String code) {
        for (CodeGenerationListener listener : this.listeners) {
            listener.handleCodeGenerated(code);
        }
    }

    public void addListener(CodeGenerationListener listener) {
        this.listeners.add(listener);
    }

    public void ignoreShell(Shell shell) {
        this.ignoredShell = shell;
    }

    public boolean isReording() {
        return this.recording;
    }

    public void switchRecording() {
        this.recording = !this.recording;
    }

    public Generator getCurrentGenerator() {
        return this.generator;
    }

    public static interface CodeGenerationListener {
        public void handleCodeGenerated(String var1);
    }
}

