/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.dashboard.views;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.linuxtools.systemtap.ui.dashboard.actions.ActivateGraphAction;
import org.eclipse.linuxtools.systemtap.ui.dashboard.internal.DashboardPlugin;
import org.eclipse.linuxtools.systemtap.ui.dashboard.structures.ActiveModuleData;
import org.eclipse.linuxtools.systemtap.ui.dashboard.structures.ActiveModuleTreeNode;
import org.eclipse.linuxtools.systemtap.ui.dashboard.structures.DashboardGraphData;
import org.eclipse.linuxtools.systemtap.ui.dashboard.structures.GraphTreeNode;
import org.eclipse.linuxtools.systemtap.ui.dashboard.views.GraphsView;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.filters.IDataSetFilter;
import org.eclipse.linuxtools.systemtap.ui.logging.LogManager;
import org.eclipse.linuxtools.systemtap.ui.structures.TreeNode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;

public class DashboardGraphsBrowserView
extends GraphsView {
    public static final String ID = "org.eclipse.linuxtools.systemtap.ui.dashboard.views.DashboardGraphsBrowserView";

    public DashboardGraphsBrowserView() {
        LogManager.logInfo((String)"Initializing", (Object)((Object)this));
    }

    protected void generateGraphsTree() {
        this.viewer.setInput((Object)new TreeNode((Object)"root", "", false));
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
    }

    protected void makeActions() {
        MenuManager manager = new MenuManager("modulePopup");
        Control control = this.viewer.getControl();
        manager.add((IContributionItem)new Separator("file.ext"));
        manager.add((IContributionItem)new Separator("build.ext"));
        manager.add((IContributionItem)new Separator("additions"));
        Menu menu = manager.createContextMenu(control);
        control.setMenu(menu);
        this.getSite().registerContextMenu(manager, (ISelectionProvider)this.viewer);
        super.makeActions();
    }

    public void add(String display, ActiveModuleData data) {
        TreeNode root = (TreeNode)this.viewer.getInput();
        ActiveModuleTreeNode child = new ActiveModuleTreeNode(data, display, true);
        root.add((TreeNode)child);
        int i = 0;
        while (i < data.module.graphs.length) {
            DashboardGraphData graphData = new DashboardGraphData();
            graphData.data = data.data;
            graphData.filters = new IDataSetFilter[data.module.filters[i].size()];
            data.module.filters[i].toArray(graphData.filters);
            graphData.graph = data.module.graphs[i];
            graphData.moduleName = data.module.category;
            graphData.adapter = null;
            ActivateGraphAction act = new ActivateGraphAction();
            GraphTreeNode graphNode = new GraphTreeNode(graphData, data.module.graphs[i].title, true);
            act.run(graphNode);
            child.add(graphNode);
            ++i;
        }
        root.sortLevel();
        this.viewer.refresh();
    }

    public void dispose() {
        LogManager.logInfo((String)"disposing", (Object)((Object)this));
        super.dispose();
        this.viewer = null;
    }

    private class ViewLabelProvider
    extends LabelProvider {
        private ViewLabelProvider() {
        }

        public String getText(Object obj) {
            return obj.toString();
        }

        public Image getImage(Object obj) {
            TreeNode treeObj = (TreeNode)obj;
            Image img = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
            if (treeObj.getChildCount() > 0) {
                img = DashboardPlugin.getImageDescriptor("icons/misc/module_obj.gif").createImage();
            } else if (treeObj instanceof GraphTreeNode) {
                img = ((DashboardGraphData)((GraphTreeNode)treeObj).getData()).adapter == null ? DashboardPlugin.getImageDescriptor("icons/misc/graph_dis.gif").createImage() : DashboardPlugin.getImageDescriptor("icons/misc/graph_act.gif").createImage();
            }
            return img;
        }
    }
}

