/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.ui.editor.forms;

import org.eclipse.linuxtools.rpm.ui.editor.forms.Messages;
import org.eclipse.linuxtools.rpm.ui.editor.parser.Specfile;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileDefine;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfilePackage;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileTag;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class RpmTagText {
    public RpmTagText(Composite parent, String rpmTag, Specfile specfile) {
        this(parent, rpmTag, specfile, 4);
    }

    public RpmTagText(Composite parent, final String rpmTag, final Specfile specfile, int flag) {
        Label label = new Label(parent, 4);
        label.setText(rpmTag);
        final Text text = new Text(parent, 1 | flag);
        SpecfileDefine define = specfile.getDefine(rpmTag);
        if (define != null) {
            if (define.getTagType().equals((Object)SpecfileTag.TagType.INT)) {
                text.setText(String.valueOf(define.getIntValue()));
            } else {
                text.setText(define.getStringValue());
            }
        }
        text.setLayoutData((Object)new GridData(768));
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                specfile.modifyDefine(rpmTag, text.getText());
            }
        });
    }

    public RpmTagText(Composite parent, final String rpmTag, final Specfile specfile, final SpecfilePackage rpmPackage, int flag) {
        Label label = new Label(parent, 4);
        label.setText(rpmTag);
        final Text text = new Text(parent, 1 | flag);
        SpecfileDefine define = specfile.getDefine(rpmTag, rpmPackage);
        if (define != null) {
            text.setText(define.getStringValue());
        }
        text.setLayoutData((Object)new GridData(768));
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                specfile.modifyDefine(rpmTag, rpmPackage, text.getText());
            }
        });
    }

    public RpmTagText(Composite parent, final SpecfileTag require, final Specfile specfile) {
        Label label = new Label(parent, 4);
        label.setText(Messages.RpmTagText_0);
        final Text text = new Text(parent, 1);
        text.setText(require.getStringValue());
        text.setLayoutData((Object)new GridData(768));
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                specfile.modifyDefine(require, text.getText());
            }
        });
    }
}

