/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ArrangeConstraint implements Enumerator
{
    KEEP_LOCATION(0, "KEEP_LOCATION", "KEEP_LOCATION"),
    KEEP_SIZE(1, "KEEP_SIZE", "KEEP_SIZE"),
    KEEP_RATIO(2, "KEEP_RATIO", "KEEP_RATIO");

    public static final int KEEP_LOCATION_VALUE = 0;
    public static final int KEEP_SIZE_VALUE = 1;
    public static final int KEEP_RATIO_VALUE = 2;
    private static final ArrangeConstraint[] VALUES_ARRAY;
    public static final List<ArrangeConstraint> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ArrangeConstraint[]{KEEP_LOCATION, KEEP_SIZE, KEEP_RATIO};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ArrangeConstraint get(String literal) {
        ArrangeConstraint[] arrangeConstraintArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            ArrangeConstraint result = arrangeConstraintArray[n2];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static ArrangeConstraint getByName(String name) {
        ArrangeConstraint[] arrangeConstraintArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            ArrangeConstraint result = arrangeConstraintArray[n2];
            if (result.getName().equals(name)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static ArrangeConstraint get(int value) {
        switch (value) {
            case 0: {
                return KEEP_LOCATION;
            }
            case 1: {
                return KEEP_SIZE;
            }
            case 2: {
                return KEEP_RATIO;
            }
        }
        return null;
    }

    private ArrangeConstraint(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

