/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.operations;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.validation.internal.ResourceHandler;
import org.eclipse.wst.validation.internal.TaskListUtility;
import org.eclipse.wst.validation.internal.Tracing;
import org.eclipse.wst.validation.internal.ValidationRegistryReader;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.operations.MessageInfo;
import org.eclipse.wst.validation.internal.operations.ValidatorManager;
import org.eclipse.wst.validation.internal.operations.WorkbenchFileDelta;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorJob;

public class WorkbenchReporter
implements IReporter {
    public static final String DEFAULT_LOCATION = "";
    public static final int NO_MESSAGE_LIMIT = -1;
    private IProject _project;
    private IProgressMonitor _monitor;

    public static void addMessage(IResource resource, Class messageOwner, IMessage message) {
        WorkbenchReporter.addMessage(resource, messageOwner, null, message);
    }

    public static void addMessage(IResource resource, Class messageOwner, ClassLoader cl, IMessage message) {
        WorkbenchReporter.addMessage(resource, messageOwner, cl, message, null, DEFAULT_LOCATION);
    }

    public static void addMessage(IResource resource, Class clazz, IMessage message, String targetObjectName, String location) {
        WorkbenchReporter.addMessage(resource, clazz, null, message, targetObjectName, location);
    }

    public static void addMessage(IResource resource, Class clazz, IMessage message, String targetObjectName, String location, String markerId) {
        WorkbenchReporter.addMessage(resource, clazz, null, message, targetObjectName, location, markerId);
    }

    public static void addMessage(IResource resource, Class clazz, ClassLoader cl, IMessage message, String targetObjectName, String location) {
        if (clazz == null || message == null || resource == null) {
            return;
        }
        if (cl == null) {
            cl = clazz.getClassLoader();
        }
        WorkbenchReporter.addMessage(resource, WorkbenchReporter.getUniqueId(clazz), cl, message, targetObjectName, location);
    }

    public static void addMessage(IResource resource, Class clazz, ClassLoader cl, IMessage message, String targetObjectName, String location, String markerId) {
        if (clazz == null || message == null || resource == null) {
            return;
        }
        if (cl == null) {
            cl = clazz.getClassLoader();
        }
        WorkbenchReporter.addMessage(resource, WorkbenchReporter.getUniqueId(clazz), cl, message, targetObjectName, location, markerId);
    }

    public static void addMessage(IResource resource, String messageOwnerId, ClassLoader cl, IMessage message) {
        WorkbenchReporter.addMessage(resource, messageOwnerId, cl, message, null, DEFAULT_LOCATION);
    }

    public static void addMessage(IResource resource, String messageOwnerId, ClassLoader cl, IMessage message, String targetObjectName, String location) {
        int severity = message.getSeverity();
        try {
            TaskListUtility.addTask(messageOwnerId, resource, location, message.getId(), message.getText(cl), severity, targetObjectName, message.getGroupName(), message.getOffset(), message.getLength());
        }
        catch (CoreException e) {
            ValidationPlugin.getPlugin().handleException(e);
        }
    }

    public static void addMessage(IResource resource, String messageOwnerId, ClassLoader cl, IMessage message, String targetObjectName, String location, String markerId) {
        int severity = message.getSeverity();
        try {
            TaskListUtility.addTask(messageOwnerId, resource, location, message.getId(), message.getText(cl), severity, markerId, targetObjectName, message.getGroupName(), message.getOffset(), message.getLength());
        }
        catch (CoreException e) {
            ValidationPlugin.getPlugin().handleException(e);
        }
    }

    public static void removeAllMessages(IResource resource, IValidator validator) {
        if (resource == null) {
            return;
        }
        ValidatorMetaData vmd = ValidationRegistryReader.getReader().getValidatorMetaData(validator);
        if (vmd == null) {
            return;
        }
        String[] validatorNames = vmd.getValidatorNames();
        try {
            TaskListUtility.removeAllTasks(resource, validatorNames);
        }
        catch (CoreException e) {
            ValidationPlugin.getPlugin().handleException(e);
        }
    }

    public static void removeAllMessages(IResource resource, IValidator validator, Object object) {
        if (resource == null) {
            return;
        }
        ValidatorMetaData vmd = ValidationRegistryReader.getReader().getValidatorMetaData(validator);
        if (vmd == null) {
            return;
        }
        String[] validatorNames = vmd.getValidatorNames();
        try {
            String targetObjectName = WorkbenchReporter.getTargetObjectName(WorkbenchReporter.getHelper(resource.getProject(), validator), object);
            WorkbenchReporter.removeAllMessages(resource, validatorNames, targetObjectName);
        }
        catch (InstantiationException e) {
            ValidationRegistryReader.getReader().disableValidator(vmd);
            ValidationPlugin.getPlugin().handleException(e);
        }
    }

    public static void removeAllMessages(IResource resource, String[] validatorNames, String targetObjectName) {
        try {
            TaskListUtility.removeAllTasks(resource, validatorNames, targetObjectName);
        }
        catch (CoreException e) {
            ValidationPlugin.getPlugin().handleException(e);
        }
    }

    public static void removeMessageSubset(IResource resource, Class messageOwner, String groupName) {
        WorkbenchReporter.removeMessageSubset(resource, new String[]{WorkbenchReporter.getUniqueId(messageOwner)}, null, groupName);
    }

    public static void removeMessageSubset(IResource resource, String messageOwnerId, String groupName) {
        WorkbenchReporter.removeMessageSubset(resource, new String[]{messageOwnerId}, null, groupName);
    }

    public static void removeMessageSubset(IResource resource, String[] ownerId, String targetObjectName, String groupName) {
        try {
            TaskListUtility.removeTaskSubset(resource, ownerId, targetObjectName, groupName);
        }
        catch (CoreException e) {
            ValidationPlugin.getPlugin().handleException(e);
        }
    }

    public static String getUniqueId(Class clazz) {
        if (clazz == null) {
            return DEFAULT_LOCATION;
        }
        return clazz.getName().intern();
    }

    public static String getUniqueId(IValidator validator) {
        if (validator == null) {
            return DEFAULT_LOCATION;
        }
        return WorkbenchReporter.getUniqueId(validator.getClass());
    }

    public static String getLocation(IWorkbenchContext helper, IMessage message) {
        if (message == null) {
            return WorkbenchReporter.getLocationText(helper, null);
        }
        int lineNo = message.getLineNumber();
        if (lineNo == 0) {
            return WorkbenchReporter.getLocationText(helper, message.getTargetObject());
        }
        return String.valueOf(lineNo);
    }

    public static String getLocationText(IWorkbenchContext helper, Object targetObject) {
        String location = null;
        try {
            location = helper.getLocation(targetObject);
        }
        catch (Exception e) {
            ValidationPlugin.getPlugin().handleException(e);
        }
        if (location == null || location.trim().equals(DEFAULT_LOCATION)) {
            location = DEFAULT_LOCATION;
        }
        return location;
    }

    protected static String getTargetObjectName(IWorkbenchContext helper, IMessage message) {
        if (message == null) {
            return WorkbenchReporter.getTargetObjectName(helper, null);
        }
        return WorkbenchReporter.getTargetObjectName(helper, message.getTargetObject());
    }

    private static String getTargetObjectName(IWorkbenchContext helper, Object targetObject) {
        String targetObjectName = null;
        try {
            targetObjectName = helper.getTargetObjectName(targetObject);
        }
        catch (Exception e) {
            ValidationPlugin.getPlugin().handleException(e);
        }
        return targetObjectName;
    }

    protected static ValidatorMetaData getVMD(IValidator validator) throws IllegalArgumentException {
        ValidatorMetaData vmd = ValidationRegistryReader.getReader().getValidatorMetaData(validator);
        if (vmd == null) {
            throw new IllegalArgumentException();
        }
        return vmd;
    }

    public WorkbenchReporter(IWorkbenchContext helper, IProgressMonitor monitor, IProject project) {
        this(project, monitor);
    }

    public WorkbenchReporter(IProject project, IProgressMonitor monitor) {
        this._project = project;
        this._monitor = monitor;
    }

    protected IWorkbenchContext getHelper(IValidator validator) throws InstantiationException, IllegalArgumentException {
        ValidatorMetaData vmd = WorkbenchReporter.getVMD(validator);
        IWorkbenchContext helper = vmd.getHelper(this.getProject(), validator);
        return helper;
    }

    protected static IWorkbenchContext getHelper(IProject project, IValidator validator) throws InstantiationException, IllegalArgumentException {
        ValidatorMetaData vmd = WorkbenchReporter.getVMD(validator);
        IWorkbenchContext helper = vmd.getHelper(project, validator);
        return helper;
    }

    public IProject getProject() {
        return this._project;
    }

    public IProgressMonitor getProgressMonitor() {
        return this._monitor;
    }

    private IResource getDefaultResource() {
        IProject prj = this.getProject();
        if (prj != null) {
            return prj;
        }
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public IResource getMessageResource(IValidator validator, Object object) {
        if (validator == null) {
            return null;
        }
        IResource resource = null;
        if (object != null) {
            if (object instanceof IResource) {
                resource = (IResource)object;
            } else if (object instanceof WorkbenchFileDelta) {
                resource = ((WorkbenchFileDelta)object).getResource();
            }
            if (resource == null) {
                try {
                    IWorkbenchContext helper = this.getHelper(validator);
                    resource = helper.getResource(object);
                }
                catch (InstantiationException e) {
                    try {
                        ValidatorMetaData vmd = WorkbenchReporter.getVMD(validator);
                        ValidationRegistryReader.getReader().disableValidator(vmd);
                        ValidationPlugin.getPlugin().handleException(e);
                    }
                    catch (IllegalArgumentException e2) {
                        ValidationPlugin.getPlugin().handleException(e2);
                    }
                }
                catch (IllegalArgumentException e) {
                    ValidationPlugin.getPlugin().handleException(e);
                }
                catch (Exception e) {
                    ValidationPlugin.getPlugin().handleException(e);
                }
            }
        }
        if (resource == null) {
            resource = this.getDefaultResource();
        }
        if (!resource.exists()) {
            resource = this.getDefaultResource();
        }
        return resource;
    }

    public void displaySubtask(String message) {
        if (message == null || message.equals(DEFAULT_LOCATION)) {
            return;
        }
        if (this.getProgressMonitor() != null) {
            this.getProgressMonitor().subTask(message);
        } else {
            System.out.println(message);
        }
    }

    @Override
    public List getMessages() {
        return null;
    }

    @Override
    public boolean isCancelled() {
        if (this.getProgressMonitor() != null) {
            return this.getProgressMonitor().isCanceled();
        }
        return false;
    }

    @Override
    public void addMessage(IValidator validator, IMessage message) {
        IResource resource = this.getMessageResource(validator, message.getTargetObject());
        IWorkbenchContext helper = null;
        ValidatorMetaData vmd = WorkbenchReporter.getVMD(validator);
        try {
            helper = this.getHelper(validator);
        }
        catch (InstantiationException e) {
            try {
                ValidationRegistryReader.getReader().disableValidator(vmd);
                ValidationPlugin.getPlugin().handleException(e);
                return;
            }
            catch (IllegalArgumentException exc2) {
                this.logDisabledValidator(exc2);
                return;
            }
        }
        catch (IllegalArgumentException exc) {
            this.logDisabledValidator(exc);
            return;
        }
        if (resource == null) {
            if (Tracing.isLogging()) {
                String result = MessageFormat.format(ResourceHandler.getExternalizedMessage("VBF_EXC_INVALID_RESOURCE"), message.getText(), WorkbenchReporter.getTargetObjectName(helper, message));
                Tracing.log("WorkbenchReporter-01: ", result);
            }
            return;
        }
        if (validator instanceof IValidatorJob) {
            WorkbenchReporter.cacheMessage((IValidatorJob)validator, resource, validator.getClass(), message, WorkbenchReporter.getTargetObjectName(helper, message), WorkbenchReporter.getLocation(helper, message), this.getMarkerId(vmd, message));
        } else {
            WorkbenchReporter.addMessage(resource, validator.getClass(), message, WorkbenchReporter.getTargetObjectName(helper, message), WorkbenchReporter.getLocation(helper, message), this.getMarkerId(vmd, message));
        }
    }

    private String getMarkerId(ValidatorMetaData vmd, IMessage message) {
        if (vmd.getMarkerIds() != null) {
            String messageMarkerId;
            if (vmd.getMarkerIds().length == 1) {
                return vmd.getMarkerIds()[0];
            }
            if (vmd.getMarkerIds().length > 1 && (messageMarkerId = message.getMarkerId()) != null && messageMarkerId.length() > 0) {
                String firstMarkerId = vmd.getMarkerIds()[0];
                String pluginQualifier = firstMarkerId.substring(0, firstMarkerId.lastIndexOf("."));
                Object qualifiedMessageMarkerId = null;
                qualifiedMessageMarkerId = messageMarkerId.indexOf(pluginQualifier) == -1 ? pluginQualifier + "." + messageMarkerId : messageMarkerId;
                if (Arrays.asList(vmd.getMarkerIds()).contains(qualifiedMessageMarkerId)) {
                    return qualifiedMessageMarkerId;
                }
            }
        }
        return null;
    }

    private void logDisabledValidator(IllegalArgumentException e) {
        ValidationPlugin.getPlugin().handleException(e);
    }

    @Override
    public void displaySubtask(IValidator validator, IMessage message) {
        if (message == null || message.equals(DEFAULT_LOCATION)) {
            return;
        }
        this.displaySubtask(message.getText(validator.getClass().getClassLoader()));
    }

    @Override
    public void removeAllMessages(IValidator validator) {
        if (validator == null) {
            return;
        }
        this.removeAllMessages(validator, null);
    }

    @Override
    public void removeAllMessages(IValidator validator, Object object) {
        IResource resource = this.getMessageResource(validator, object);
        if (resource == null) {
            return;
        }
        ValidatorMetaData vmd = ValidationRegistryReader.getReader().getValidatorMetaData(validator);
        if (vmd == null) {
            return;
        }
        IWorkbenchContext helper = null;
        try {
            helper = this.getHelper(validator);
        }
        catch (InstantiationException e) {
            ValidationRegistryReader.getReader().disableValidator(vmd);
            ValidationPlugin.getPlugin().handleException(e);
            return;
        }
        String[] validatorNames = vmd.getValidatorNames();
        String targetObjectName = WorkbenchReporter.getTargetObjectName(helper, object);
        WorkbenchReporter.removeAllMessages(resource, validatorNames, targetObjectName);
    }

    @Override
    public void removeMessageSubset(IValidator validator, Object obj, String groupName) {
        IResource resource = this.getMessageResource(validator, obj);
        if (resource == null) {
            return;
        }
        ValidatorMetaData vmd = ValidationRegistryReader.getReader().getValidatorMetaData(validator);
        if (vmd == null) {
            return;
        }
        IWorkbenchContext helper = null;
        try {
            helper = WorkbenchReporter.getHelper(resource.getProject(), validator);
        }
        catch (InstantiationException e) {
            ValidationRegistryReader.getReader().disableValidator(vmd);
            ValidationPlugin.getPlugin().handleException(e);
            return;
        }
        String[] validatorNames = vmd.getValidatorNames();
        String targetObjectName = WorkbenchReporter.getTargetObjectName(helper, obj);
        WorkbenchReporter.removeMessageSubset(resource, validatorNames, targetObjectName, groupName);
    }

    private static void cacheMessage(IValidatorJob validator, IResource resource, Class clazz, IMessage message, String targetObjectName, String location, String markerId) {
        if (clazz == null || message == null || resource == null) {
            return;
        }
        ClassLoader cl = clazz.getClassLoader();
        String text = message.getText(cl);
        MessageInfo msgInfo = new MessageInfo(WorkbenchReporter.getUniqueId(clazz), resource, location, text, targetObjectName, markerId, message);
        ValidatorManager.getManager().cacheMessage(validator, msgInfo);
    }
}

