/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.hosts;

import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.StringUtils;

public final class GitHosts {
    private static final String GITHUB_ID = "github";
    private static final String GITLAB_ID = "gitlab";
    private static final String GITEA_ID = "gitea";
    private static final Pattern DIGITS = Pattern.compile("\\d+");
    private static final Map<String, Collection<Pattern>> DEFAULT_URIS = new ConcurrentHashMap<String, Collection<Pattern>>();
    private static volatile Map<String, Collection<Pattern>> CUSTOM_URIS = new ConcurrentHashMap<String, Collection<Pattern>>();

    static {
        GitHosts.addServerPattern(DEFAULT_URIS, GITHUB_ID, GitHosts.remote("github\\.com"));
        GitHosts.addServerPattern(DEFAULT_URIS, GITLAB_ID, GitHosts.remote("gitlab(?:\\.[^.:/]+)?\\.(?:com|org)"));
        GitHosts.addServerPattern(DEFAULT_URIS, GITEA_ID, GitHosts.remote("gitea\\.com"));
    }

    private static Pattern remote(String hosts) {
        return Pattern.compile("(?:(?:https?|ssh)://)?(?:[^@:/]+(?::[^@:/]*)?@)?(?:" + hosts + ")[:/].*");
    }

    private GitHosts() {
    }

    public static boolean isServerConfig(RemoteConfig rc, ServerType server) {
        List fetch = rc.getURIs();
        return !fetch.isEmpty() && server.uriMatches(((URIish)fetch.get(0)).toPrivateString());
    }

    public static boolean hasServerConfig(Config config, ServerType server) throws URISyntaxException {
        return RemoteConfig.getAllRemoteConfigs((Config)config).stream().anyMatch(rc -> GitHosts.isServerConfig(rc, server));
    }

    public static Collection<RemoteConfig> getServerConfigs(Config config, ServerType server) throws URISyntaxException {
        return RemoteConfig.getAllRemoteConfigs((Config)config).stream().filter(rc -> GitHosts.isServerConfig(rc, server)).collect(Collectors.toList());
    }

    public static void loadFromPreferences(IEclipsePreferences preferences) {
        String data = preferences.get("core_git_servers", null);
        if (StringUtils.isEmptyOrNull((String)data)) {
            CUSTOM_URIS.clear();
            return;
        }
        ConcurrentHashMap<String, Collection<Pattern>> newData = new ConcurrentHashMap<String, Collection<Pattern>>();
        GitHosts.loadFromPreferences(data, (s, p) -> GitHosts.addServerPattern(newData, ServerType.valueOf(s).getId(), GitHosts.remote(p)));
        CUSTOM_URIS = newData;
    }

    public static void loadFromPreferences(String preferenceData, BiConsumer<String, String> consumer) {
        String[] lines;
        if (StringUtils.isEmptyOrNull((String)preferenceData)) {
            return;
        }
        String[] stringArray = lines = preferenceData.split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String[] parts;
            String line = stringArray[n2];
            if (!StringUtils.isEmptyOrNull((String)line) && (parts = line.split("\t", 2)).length == 2) {
                try {
                    ServerType.valueOf(parts[0]);
                    String hostPattern = parts[1];
                    if (!StringUtils.isEmptyOrNull((String)hostPattern)) {
                        Pattern.compile(hostPattern);
                        consumer.accept(parts[0], hostPattern);
                    }
                }
                catch (IllegalArgumentException e) {
                    Activator.logError(MessageFormat.format(CoreText.GitHosts_invalidPreference, "core_git_servers", line), e);
                }
            }
            ++n2;
        }
    }

    private static void addServerPattern(Map<String, Collection<Pattern>> collection, String id, Pattern uriPattern) {
        if (uriPattern != null) {
            collection.computeIfAbsent(id, key -> new CopyOnWriteArrayList()).add(uriPattern);
        }
    }

    public static enum ServerType {
        GITHUB("github", "refs/pull/", "/head", "https?://.*/pull/(\\d+)(?:[/?#].*)?"),
        GITLAB("gitlab", "refs/merge-requests/", "/head", "https?://.*/merge_requests/(\\d+)(?:[/?#].*)?"),
        GITEA("gitea", "refs/pull/", "/head", "https?://.*/pulls/(\\d+)(?:[/?#].*)?");

        public static final long NO_CHANGE_ID = -1L;
        private final String id;
        private final String refPrefix;
        private final String refSuffix;
        private final Pattern urlPattern;
        private final Pattern refPattern;
        private final Pattern inputPattern;

        private ServerType(String id, String refPrefix, String refSuffix, String webUrl) {
            this.id = id;
            this.refPrefix = refPrefix;
            this.refSuffix = refSuffix;
            this.refPattern = refSuffix != null ? Pattern.compile(refPrefix + "(\\d+)" + refSuffix) : Pattern.compile(refPrefix + "(\\d+)");
            this.inputPattern = refSuffix != null ? Pattern.compile(refPrefix + "(\\d+)(?:" + refSuffix + ")?") : this.refPattern;
            this.urlPattern = Pattern.compile(webUrl);
        }

        public String getId() {
            return this.id;
        }

        public boolean uriMatches(String uri) {
            return this.matches(DEFAULT_URIS.get(this.getId()), uri) || this.matches(CUSTOM_URIS.get(this.getId()), uri);
        }

        private boolean matches(Collection<Pattern> patterns, String uri) {
            return patterns != null && patterns.stream().anyMatch(p -> p.matcher(uri).matches());
        }

        public long fromRef(String ref) {
            Matcher m;
            block5: {
                block4: {
                    if (ref != null) break block4;
                    return -1L;
                }
                m = this.refPattern.matcher(ref);
                if (m.matches() && m.group(1) != null) break block5;
                return -1L;
            }
            try {
                return Long.parseLong(m.group(1));
            }
            catch (IndexOutOfBoundsException | NumberFormatException e) {
                return -1L;
            }
        }

        public long fromString(String input) {
            if (input == null) {
                return -1L;
            }
            try {
                Matcher matcher = this.urlPattern.matcher(input);
                if (matcher.matches()) {
                    return Long.parseLong(matcher.group(1));
                }
                matcher = this.inputPattern.matcher(input);
                if (matcher.matches()) {
                    return Long.parseLong(matcher.group(1));
                }
                matcher = DIGITS.matcher(input);
                if (matcher.matches()) {
                    return Long.parseLong(input);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return -1L;
        }

        public String toFetchRef(long changeId) {
            if (changeId < 0L) {
                return null;
            }
            return this.refSuffix == null ? this.refPrefix + changeId : this.refPrefix + changeId + this.refSuffix;
        }

        public String getRefPrefix() {
            return this.refPrefix;
        }
    }
}

