/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.session.remote;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.emf.cdo.common.util.TransportException;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.session.CDOSessionRegistry;
import org.eclipse.emf.cdo.session.remote.CDORemoteSession;
import org.eclipse.emf.cdo.session.remote.CDORemoteSessionManager;
import org.eclipse.emf.cdo.session.remote.CDORemoteSessionMessage;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.container.ContainerEventAdapter;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.IDeactivateable;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.om.OMPlatform;

public final class CDORemoteSessionRequest {
    public static final long DEFAULT_TIMEOUT = OMPlatform.INSTANCE.getProperty("org.eclipse.emf.cdo.RemoteSessionRequest.DEFAULT_TIMEOUT", 5000L);
    private static final boolean DEBUG = OMPlatform.INSTANCE.isProperty("org.eclipse.emf.cdo.RemoteSessionRequest.DEBUG");
    private static final String NOTIFICATION_PREFIX = "org.eclipse.emf.cdo.NOTIFICATION/";
    private static final String REQUEST_PREFIX = "org.eclipse.emf.cdo.REQUEST/";
    private static final String RESPONSE_PREFIX = "org.eclipse.emf.cdo.RESPONSE/";
    private static final AtomicLong lastMessageID = new AtomicLong();
    private static Consumer<String> defaultTimeoutHandler = DEBUG ? type -> OM.LOG.warn("Timeout: " + type) : null;
    private static BiConsumer<String, Throwable> defaultExceptionHandler = DEBUG ? (type, ex) -> OM.LOG.error("Exception: " + type, ex) : null;
    private final String type;
    private final byte[] data;
    private long timeout = DEFAULT_TIMEOUT;
    private Consumer<String> timeoutHandler = defaultTimeoutHandler;
    private BiConsumer<String, Throwable> exceptionHandler = defaultExceptionHandler;
    private Consumer<byte[]> responseConsumer;

    public CDORemoteSessionRequest(String type, byte[] data) {
        this.type = type;
        this.data = data;
    }

    public CDORemoteSessionRequest(String type) {
        this(type, null);
    }

    public long timeout() {
        return this.timeout;
    }

    public CDORemoteSessionRequest timeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public CDORemoteSessionRequest onTimeout(Consumer<String> timeoutHandler) {
        this.timeoutHandler = timeoutHandler;
        return this;
    }

    public CDORemoteSessionRequest onException(BiConsumer<String, Throwable> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    public CDORemoteSessionRequest onResponse(Consumer<byte[]> responseConsumer) {
        this.responseConsumer = responseConsumer;
        return this;
    }

    public void send(CDORemoteSession recipient) {
        ConcurrencyUtil.execute((Object)recipient.getManager(), () -> this.sendSynchronous(recipient));
    }

    public void sendSynchronous(final CDORemoteSession recipient) {
        block10: {
            CDORemoteSessionManager manager = recipient.getManager();
            String messageDescriptor = String.valueOf(this.type) + "/" + lastMessageID.incrementAndGet();
            final String requestType = String.valueOf(this.responseConsumer != null ? REQUEST_PREFIX : NOTIFICATION_PREFIX) + messageDescriptor;
            if (DEBUG) {
                System.out.println("Sending " + requestType);
            }
            try {
                if (this.responseConsumer != null) {
                    final String responseType = RESPONSE_PREFIX + messageDescriptor;
                    final AtomicBoolean responseReceived = new AtomicBoolean();
                    final CountDownLatch finished = new CountDownLatch(1);
                    CDORemoteSessionManager.EventAdapter responseListener = new CDORemoteSessionManager.EventAdapter(){

                        @Override
                        protected void onMessageReceived(CDORemoteSession sender, CDORemoteSessionMessage message) {
                            if (sender == recipient && message.getType().equals(responseType)) {
                                if (DEBUG) {
                                    System.out.println("Received " + responseType);
                                }
                                try {
                                    try {
                                        responseReceived.set(true);
                                        CDORemoteSessionRequest.this.responseConsumer.accept(message.getData());
                                    }
                                    catch (Throwable ex) {
                                        if (CDORemoteSessionRequest.this.exceptionHandler != null) {
                                            CDORemoteSessionRequest.this.exceptionHandler.accept(requestType, ex);
                                        }
                                        finished.countDown();
                                    }
                                }
                                finally {
                                    finished.countDown();
                                }
                            }
                        }

                        @Override
                        protected void onClosed(CDORemoteSession sender) {
                            if (sender == recipient) {
                                finished.countDown();
                            }
                        }
                    };
                    try {
                        manager.addListener((IListener)responseListener);
                        long deadline = DEBUG ? Long.MAX_VALUE : System.currentTimeMillis() + this.timeout;
                        this.doSend(recipient, requestType);
                        while (System.currentTimeMillis() < deadline) {
                            if (!finished.await(100L, TimeUnit.MILLISECONDS)) continue;
                            if (!responseReceived.get()) break;
                            return;
                        }
                        if (this.timeoutHandler != null) {
                            this.timeoutHandler.accept(requestType);
                        }
                        break block10;
                    }
                    finally {
                        manager.removeListener((IListener)responseListener);
                    }
                }
                this.doSend(recipient, requestType);
            }
            catch (Throwable ex) {
                if (this.exceptionHandler == null) break block10;
                this.exceptionHandler.accept(requestType, ex);
            }
        }
    }

    private void doSend(CDORemoteSession recipient, String requestType) {
        CDORemoteSessionMessage message = new CDORemoteSessionMessage(requestType, this.data);
        if (!recipient.sendMessage(message)) {
            throw new TransportException("Message could not be delivered to the server: " + message);
        }
    }

    public static Consumer<String> getDefaultTimeoutHandler() {
        return defaultTimeoutHandler;
    }

    public static void setDefaultTimeoutHandler(Consumer<String> defaultTimeoutHandler) {
        CDORemoteSessionRequest.defaultTimeoutHandler = defaultTimeoutHandler;
    }

    public static BiConsumer<String, Throwable> getDefaultExceptionHandler() {
        return defaultExceptionHandler;
    }

    public static void setDefaultExceptionHandler(BiConsumer<String, Throwable> defaultExceptionHandler) {
        CDORemoteSessionRequest.defaultExceptionHandler = defaultExceptionHandler;
    }

    public static abstract class GlobalRequestHandler
    implements IDeactivateable {
        private final IListener sessionRegistryListener = new ContainerEventAdapter<CDOSessionRegistry.Registration>(){

            protected void onAdded(IContainer<CDOSessionRegistry.Registration> container, CDOSessionRegistry.Registration registration) {
                this.addSession(registration.getSession());
            }

            protected void onRemoved(IContainer<CDOSessionRegistry.Registration> container, CDOSessionRegistry.Registration registration) {
                this.removeSession(registration.getSession());
            }
        };
        private final Map<CDOSession, RequestHandler> requestHandlers = new HashMap<CDOSession, RequestHandler>();
        private final String type;
        private boolean deactivated;

        public GlobalRequestHandler(String type) {
            this.type = type;
            CDOSession[] cDOSessionArray = CDOSessionRegistry.INSTANCE.getSessions();
            int n = cDOSessionArray.length;
            int n2 = 0;
            while (n2 < n) {
                CDOSession session = cDOSessionArray[n2];
                this.addSession(session);
                ++n2;
            }
            CDOSessionRegistry.INSTANCE.addListener(this.sessionRegistryListener);
        }

        public Exception deactivate() {
            if (!this.deactivated) {
                CDOSessionRegistry.INSTANCE.removeListener(this.sessionRegistryListener);
                for (RequestHandler requestHandler : this.requestHandlers.values()) {
                    requestHandler.deactivate();
                }
                this.requestHandlers.clear();
                this.deactivated = true;
            }
            return null;
        }

        protected abstract byte[] createResponse(CDORemoteSession var1, byte[] var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addSession(CDOSession session) {
            CDORemoteSessionManager manager = session.getRemoteSessionManager();
            RequestHandler requestHandler = new RequestHandler(manager, this.type){

                @Override
                protected byte[] handleRequest(CDORemoteSession sender, byte[] request) {
                    return this.createResponse(sender, request);
                }
            };
            Map<CDOSession, RequestHandler> map = this.requestHandlers;
            synchronized (map) {
                this.requestHandlers.put(session, requestHandler);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeSession(CDOSession session) {
            RequestHandler requestHandler;
            Map<CDOSession, RequestHandler> map = this.requestHandlers;
            synchronized (map) {
                requestHandler = this.requestHandlers.remove(session);
            }
            if (requestHandler != null) {
                requestHandler.deactivate();
            }
        }
    }

    public static abstract class RequestHandler
    implements IDeactivateable {
        private final IListener managerListener = new CDORemoteSessionManager.EventAdapter(){

            @Override
            protected void onMessageReceived(CDORemoteSession sender, CDORemoteSessionMessage message) {
                String type = message.getType();
                if (type.startsWith(notificationType)) {
                    if (DEBUG) {
                        System.out.println("Received " + type);
                    }
                    byte[] request = message.getData();
                    this.handleRequest(sender, request);
                } else if (type.startsWith(requestType)) {
                    if (DEBUG) {
                        System.out.println("Received " + type);
                    }
                    byte[] request = message.getData();
                    byte[] response = this.handleRequest(sender, request);
                    String messageDescriptor = type.substring(CDORemoteSessionRequest.REQUEST_PREFIX.length());
                    String responseType = CDORemoteSessionRequest.RESPONSE_PREFIX + messageDescriptor;
                    sender.sendMessage(new CDORemoteSessionMessage(responseType, response));
                }
            }

            protected void onDeactivated(ILifecycle lifecycle) {
                this.deactivate();
            }
        };
        private final String notificationType;
        private final String requestType;
        private final CDORemoteSessionManager manager;
        private boolean deactivated;

        public RequestHandler(CDORemoteSessionManager manager, String type) {
            this.notificationType = CDORemoteSessionRequest.NOTIFICATION_PREFIX + type;
            this.requestType = CDORemoteSessionRequest.REQUEST_PREFIX + type;
            this.manager = manager;
            manager.addListener(this.managerListener);
        }

        public Exception deactivate() {
            if (!this.deactivated) {
                this.manager.removeListener(this.managerListener);
                this.deactivated = true;
            }
            return null;
        }

        protected abstract byte[] handleRequest(CDORemoteSession var1, byte[] var2);
    }
}

