/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.etypes.util;

import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranchPointRef;
import org.eclipse.emf.cdo.common.branch.CDOBranchRef;
import org.eclipse.emf.cdo.common.lob.CDOBlob;
import org.eclipse.emf.cdo.common.lob.CDOClob;
import org.eclipse.emf.cdo.common.lob.CDOLob;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.etypes.Annotation;
import org.eclipse.emf.cdo.etypes.AnnotationValidator;
import org.eclipse.emf.cdo.etypes.EtypesPackage;
import org.eclipse.emf.cdo.etypes.ModelElement;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.internal.cdo.bundle.Activator;

public class EtypesValidator
extends EObjectValidator {
    public static final EtypesValidator INSTANCE = new EtypesValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.emf.cdo.etypes";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;

    protected EPackage getEPackage() {
        return EtypesPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateModelElement((ModelElement)value, diagnostics, context);
            }
            case 1: {
                return this.validateAnnotation((Annotation)value, diagnostics, context);
            }
            case 10: {
                return this.validateStringToStringMapEntry((Map.Entry)value, diagnostics, context);
            }
            case 2: {
                return this.validateBlob((CDOBlob)value, diagnostics, context);
            }
            case 3: {
                return this.validateClob((CDOClob)value, diagnostics, context);
            }
            case 4: {
                return this.validateLob((CDOLob)value, diagnostics, context);
            }
            case 5: {
                return this.validateInputStream((InputStream)value, diagnostics, context);
            }
            case 6: {
                return this.validateReader((Reader)value, diagnostics, context);
            }
            case 7: {
                return this.validateClassifierRef((CDOClassifierRef)value, diagnostics, context);
            }
            case 8: {
                return this.validateBranchRef((CDOBranchRef)value, diagnostics, context);
            }
            case 9: {
                return this.validateBranchPointRef((CDOBranchPointRef)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateModelElement(ModelElement modelElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(modelElement, diagnostics, context);
    }

    public boolean validateAnnotation(Annotation annotation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(annotation, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(annotation, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(annotation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(annotation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(annotation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(annotation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(annotation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(annotation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(annotation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAnnotation_WellFormed(annotation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAnnotation_WellFormedSourceURI(annotation, diagnostics, context);
        }
        return result;
    }

    public boolean validateAnnotation_WellFormed(Annotation annotation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        AnnotationValidator annotationValidator = AnnotationValidator.Registry.INSTANCE.getAnnotationValidator(annotation.getSource());
        if (annotationValidator != null) {
            return annotationValidator.validate(annotation, diagnostics, context);
        }
        return true;
    }

    public boolean validateAnnotation_WellFormedSourceURI(Annotation annotation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        String source = annotation.getSource();
        boolean bl = result = source == null || CDOCommonUtil.isWellFormedURI((String)source);
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 47, "_UI_AnnotationSourceURINotWellFormed_diagnostic", new Object[]{source}, new Object[]{annotation, EtypesPackage.Literals.ANNOTATION__SOURCE}, context));
        }
        return result;
    }

    public boolean validateStringToStringMapEntry(Map.Entry<?, ?> stringToStringMapEntry, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)stringToStringMapEntry, diagnostics, context);
    }

    public boolean validateBlob(CDOBlob blob, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateClob(CDOClob clob, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateLob(CDOLob<?> lob, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateInputStream(InputStream inputStream, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateReader(Reader reader, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateClassifierRef(CDOClassifierRef classifierRef, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateBranchRef(CDOBranchRef branchRef, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateBranchPointRef(CDOBranchPointRef branchPointRef, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return Activator.INSTANCE;
    }
}

