/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.templates;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.wizards.templates.TemplateSelectionPage;
import org.eclipse.pde.ui.templates.AbstractNewPluginTemplateWizard;
import org.eclipse.pde.ui.templates.ITemplateSection;
import org.eclipse.swt.widgets.Composite;

public class NewPluginTemplateChoiceWizard
extends AbstractNewPluginTemplateWizard {
    private TemplateSelectionPage fSelectionPage;
    private ITemplateSection[] fCandidates;

    @Override
    public ITemplateSection[] getTemplateSections() {
        if (this.fSelectionPage != null) {
            return this.fSelectionPage.getSelectedTemplates();
        }
        return this.getCandidates();
    }

    @Override
    public void addAdditionalPages() {
        this.fSelectionPage = new TemplateSelectionPage(this.getCandidates());
        this.addPage((IWizardPage)this.fSelectionPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (this.fSelectionPage == null) {
            return null;
        }
        return this.fSelectionPage.getNextVisiblePage(page);
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        return null;
    }

    private ITemplateSection[] getCandidates() {
        if (this.fCandidates == null) {
            this.createCandidates();
        }
        return this.fCandidates;
    }

    public boolean canFinish() {
        ITemplateSection[] sections;
        ITemplateSection[] iTemplateSectionArray = sections = this.fSelectionPage.getSelectedTemplates();
        int n = sections.length;
        int n2 = 0;
        while (n2 < n) {
            ITemplateSection section = iTemplateSectionArray[n2];
            int pageCount = section.getPageCount();
            int j = 0;
            while (j < pageCount) {
                WizardPage page = section.getPage(j);
                if (page != null && !page.isPageComplete()) {
                    return false;
                }
                ++j;
            }
            ++n2;
        }
        return true;
    }

    private void createCandidates() {
        IConfigurationElement[] elements;
        ArrayList<Object> candidates = new ArrayList<Object>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(PDEPlugin.getPluginId(), "templates");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            this.addTemplate(element, candidates);
            ++n2;
        }
        this.fCandidates = candidates.toArray(new ITemplateSection[candidates.size()]);
    }

    private void addTemplate(IConfigurationElement config, ArrayList<Object> result) {
        if (!config.getName().equalsIgnoreCase("template")) {
            return;
        }
        try {
            Object template = config.createExecutableExtension("class");
            if (template instanceof ITemplateSection) {
                result.add(template);
            }
        }
        catch (CoreException e) {
            PDEPlugin.log(e);
        }
    }

    public void createPageControls(Composite pageContainer) {
        this.fSelectionPage.createControl(pageContainer);
    }
}

