/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.impl;

import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EDataTypeImpl;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.EcorePackage;
import org.eclipse.ocl.ecore.internal.OCLStandardLibraryImpl;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.types.operations.CollectionTypeOperations;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.ocl.utilities.PredefinedType;
import org.eclipse.ocl.utilities.TypedASTNode;

public class CollectionTypeImpl
extends EDataTypeImpl
implements CollectionType {
    protected static final int START_POSITION_EDEFAULT = -1;
    protected int startPosition = -1;
    protected static final int END_POSITION_EDEFAULT = -1;
    protected int endPosition = -1;
    protected static final int TYPE_START_POSITION_EDEFAULT = -1;
    protected int typeStartPosition = -1;
    protected static final int TYPE_END_POSITION_EDEFAULT = -1;
    protected int typeEndPosition = -1;
    protected EClassifier elementType;
    protected static final CollectionKind KIND_EDEFAULT = CollectionKind.SET_LITERAL;
    private EList<EOperation> operations;
    private EList<EOperation> iterators;

    protected CollectionTypeImpl() {
        this.setInstanceClass(Collection.class);
    }

    protected CollectionTypeImpl(EClassifier elementType) {
        this();
        this.elementType = elementType;
    }

    protected EClass eStaticClass() {
        return EcorePackage.Literals.COLLECTION_TYPE;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(int newStartPosition) {
        int oldStartPosition = this.startPosition;
        this.startPosition = newStartPosition;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, oldStartPosition, this.startPosition));
        }
    }

    public int getEndPosition() {
        return this.endPosition;
    }

    public void setEndPosition(int newEndPosition) {
        int oldEndPosition = this.endPosition;
        this.endPosition = newEndPosition;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, oldEndPosition, this.endPosition));
        }
    }

    public int getTypeStartPosition() {
        return this.typeStartPosition;
    }

    public void setTypeStartPosition(int newTypeStartPosition) {
        int oldTypeStartPosition = this.typeStartPosition;
        this.typeStartPosition = newTypeStartPosition;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, oldTypeStartPosition, this.typeStartPosition));
        }
    }

    public int getTypeEndPosition() {
        return this.typeEndPosition;
    }

    public void setTypeEndPosition(int newTypeEndPosition) {
        int oldTypeEndPosition = this.typeEndPosition;
        this.typeEndPosition = newTypeEndPosition;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, oldTypeEndPosition, this.typeEndPosition));
        }
    }

    public EClassifier getElementType() {
        if (this.elementType != null && this.elementType.eIsProxy()) {
            InternalEObject oldElementType = (InternalEObject)this.elementType;
            this.elementType = (EClassifier)this.eResolveProxy(oldElementType);
            if (this.elementType != oldElementType && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 13, (Object)oldElementType, (Object)this.elementType));
            }
        }
        return this.elementType;
    }

    public EClassifier basicGetElementType() {
        return this.elementType;
    }

    public void setElementType(EClassifier newElementType) {
        EClassifier oldElementType = this.elementType;
        this.elementType = newElementType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, (Object)oldElementType, (Object)this.elementType));
        }
    }

    public CollectionKind getKind() {
        return CollectionKind.COLLECTION_LITERAL;
    }

    public boolean checkCollectionTypeName(DiagnosticChain diagnostics, Map<Object, Object> context) {
        return CollectionTypeOperations.checkCollectionTypeName((org.eclipse.ocl.types.CollectionType)this, (DiagnosticChain)diagnostics, context);
    }

    public boolean checkNoInvalidValues(DiagnosticChain diagnostics, Map<Object, Object> context) {
        return CollectionTypeOperations.checkNoInvalidValues((org.eclipse.ocl.types.CollectionType)this, (DiagnosticChain)diagnostics, context);
    }

    public String getName() {
        if (this.name == null) {
            StringBuffer myName = new StringBuffer();
            switch (this.getKind()) {
                case SET_LITERAL: {
                    myName.append("Set");
                    break;
                }
                case ORDERED_SET_LITERAL: {
                    myName.append("OrderedSet");
                    break;
                }
                case BAG_LITERAL: {
                    myName.append("Bag");
                    break;
                }
                case SEQUENCE_LITERAL: {
                    myName.append("Sequence");
                    break;
                }
                default: {
                    myName.append("Collection");
                }
            }
            myName.append('(');
            EClassifier elementType = this.getElementType();
            String elementTypeName = elementType != null ? elementType.getName() : "";
            myName.append(elementTypeName);
            myName.append(')');
            this.name = myName.toString();
        }
        return this.name;
    }

    public EList<EOperation> oclOperations() {
        if (this.operations == null) {
            CollectionType prototype;
            switch (this.getKind()) {
                case SET_LITERAL: {
                    prototype = (CollectionType)OCLStandardLibraryImpl.INSTANCE.getSet();
                    break;
                }
                case ORDERED_SET_LITERAL: {
                    prototype = (CollectionType)OCLStandardLibraryImpl.INSTANCE.getOrderedSet();
                    break;
                }
                case BAG_LITERAL: {
                    prototype = (CollectionType)OCLStandardLibraryImpl.INSTANCE.getBag();
                    break;
                }
                case SEQUENCE_LITERAL: {
                    prototype = (CollectionType)OCLStandardLibraryImpl.INSTANCE.getSequence();
                    break;
                }
                default: {
                    prototype = (CollectionType)OCLStandardLibraryImpl.INSTANCE.getCollection();
                }
            }
            if (prototype == this) {
                this.operations = new BasicEList.FastCompare(OCLStandardLibraryImpl.getExistingOperations((EClassifier)this));
                this.operations.removeAll(this.oclIterators());
            } else {
                this.operations = prototype.oclOperations();
            }
        }
        return this.operations;
    }

    public EList<EOperation> oclIterators() {
        if (this.iterators == null) {
            CollectionType prototype;
            switch (this.getKind()) {
                case SET_LITERAL: {
                    prototype = (CollectionType)OCLStandardLibraryImpl.INSTANCE.getSet();
                    break;
                }
                case ORDERED_SET_LITERAL: {
                    prototype = (CollectionType)OCLStandardLibraryImpl.INSTANCE.getOrderedSet();
                    break;
                }
                case BAG_LITERAL: {
                    prototype = (CollectionType)OCLStandardLibraryImpl.INSTANCE.getBag();
                    break;
                }
                case SEQUENCE_LITERAL: {
                    prototype = (CollectionType)OCLStandardLibraryImpl.INSTANCE.getSequence();
                    break;
                }
                default: {
                    prototype = (CollectionType)OCLStandardLibraryImpl.INSTANCE.getCollection();
                }
            }
            if (prototype == this) {
                this.iterators = new BasicEList.FastCompare(OCLStandardLibraryImpl.getExistingOperations((EClassifier)this));
                this.iterators = OCLStandardLibraryImpl.selectIterators(this.iterators);
            } else {
                this.iterators = prototype.oclIterators();
            }
        }
        return this.iterators;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 9: {
                return this.getStartPosition();
            }
            case 10: {
                return this.getEndPosition();
            }
            case 11: {
                return this.getTypeStartPosition();
            }
            case 12: {
                return this.getTypeEndPosition();
            }
            case 13: {
                if (resolve) {
                    return this.getElementType();
                }
                return this.basicGetElementType();
            }
            case 14: {
                return this.getKind();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 9: {
                this.setStartPosition((Integer)newValue);
                return;
            }
            case 10: {
                this.setEndPosition((Integer)newValue);
                return;
            }
            case 11: {
                this.setTypeStartPosition((Integer)newValue);
                return;
            }
            case 12: {
                this.setTypeEndPosition((Integer)newValue);
                return;
            }
            case 13: {
                this.setElementType((EClassifier)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 9: {
                this.setStartPosition(-1);
                return;
            }
            case 10: {
                this.setEndPosition(-1);
                return;
            }
            case 11: {
                this.setTypeStartPosition(-1);
                return;
            }
            case 12: {
                this.setTypeEndPosition(-1);
                return;
            }
            case 13: {
                this.setElementType(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 9: {
                return this.startPosition != -1;
            }
            case 10: {
                return this.endPosition != -1;
            }
            case 11: {
                return this.typeStartPosition != -1;
            }
            case 12: {
                return this.typeEndPosition != -1;
            }
            case 13: {
                return this.elementType != null;
            }
            case 14: {
                return this.getKind() != KIND_EDEFAULT;
            }
        }
        return super.eIsSet(featureID);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == PredefinedType.class) {
            return -1;
        }
        if (baseClass == ASTNode.class) {
            switch (derivedFeatureID) {
                case 9: {
                    return 0;
                }
                case 10: {
                    return 1;
                }
            }
            return -1;
        }
        if (baseClass == TypedASTNode.class) {
            switch (derivedFeatureID) {
                case 11: {
                    return 2;
                }
                case 12: {
                    return 3;
                }
            }
            return -1;
        }
        if (baseClass == org.eclipse.ocl.types.CollectionType.class) {
            switch (derivedFeatureID) {
                case 13: {
                    return 4;
                }
                case 14: {
                    return 5;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == PredefinedType.class) {
            return -1;
        }
        if (baseClass == ASTNode.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 9;
                }
                case 1: {
                    return 10;
                }
            }
            return -1;
        }
        if (baseClass == TypedASTNode.class) {
            switch (baseFeatureID) {
                case 2: {
                    return 11;
                }
                case 3: {
                    return 12;
                }
            }
            return -1;
        }
        if (baseClass == org.eclipse.ocl.types.CollectionType.class) {
            switch (baseFeatureID) {
                case 4: {
                    return 13;
                }
                case 5: {
                    return 14;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (startPosition: ");
        result.append(this.startPosition);
        result.append(", endPosition: ");
        result.append(this.endPosition);
        result.append(", typeStartPosition: ");
        result.append(this.typeStartPosition);
        result.append(", typeEndPosition: ");
        result.append(this.typeEndPosition);
        result.append(')');
        return result.toString();
    }
}

