/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.revision;

import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.lob.CDOLob;
import org.eclipse.emf.cdo.common.lob.CDOLobLoader;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionData;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.spi.common.protocol.CDODataOutputImpl;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.io.IORuntimeException;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.lifecycle.Lifecycle;

public final class CDORevisionCrawler
extends Lifecycle {
    private Handler handler;
    private ContainmentProxyStrategy containmentProxyStrategy = ContainmentProxyStrategy.Physical;
    private FeatureStrategy featureStrategy = FeatureStrategy.TREE;
    private CDORevisionProvider revisionProvider;
    private long revisionCount;

    public Handler handler() {
        return this.handler;
    }

    public CDORevisionCrawler handler(Handler handler) {
        this.checkInactive();
        this.handler = handler;
        return this;
    }

    public ContainmentProxyStrategy containmentProxyStrategy() {
        return this.containmentProxyStrategy;
    }

    public CDORevisionCrawler containmentProxyStrategy(ContainmentProxyStrategy containmentProxyStrategy) {
        this.checkInactive();
        this.containmentProxyStrategy = containmentProxyStrategy;
        return this;
    }

    public FeatureStrategy featureStrategy() {
        return this.featureStrategy;
    }

    public CDORevisionCrawler featureStrategy(FeatureStrategy featureStrategy) {
        this.checkInactive();
        this.featureStrategy = featureStrategy;
        return this;
    }

    public CDORevisionProvider revisionProvider() {
        return this.revisionProvider;
    }

    public CDORevisionCrawler revisionProvider(CDORevisionProvider revisionProvider) {
        this.checkInactive();
        this.revisionProvider = revisionProvider;
        return this;
    }

    public long revisionCount() {
        return this.revisionCount;
    }

    public CDORevisionCrawler addRevision(CDORevision revision) {
        this.checkActive();
        LinkedList<InternalCDORevision> queue = new LinkedList<InternalCDORevision>();
        queue.offer((InternalCDORevision)revision);
        while (!queue.isEmpty()) {
            InternalCDORevision rev = (InternalCDORevision)queue.remove();
            ++this.revisionCount;
            if (!this.handler.beginRevision(rev)) continue;
            EStructuralFeature[] eStructuralFeatureArray = rev.getClassInfo().getAllPersistentFeatures();
            int n = eStructuralFeatureArray.length;
            int n2 = 0;
            while (n2 < n) {
                EStructuralFeature feature = eStructuralFeatureArray[n2];
                FeatureStrategy.Decision decision = this.featureStrategy.decide(rev, feature);
                if (decision.isHandle()) {
                    this.handleFeature(rev, feature);
                }
                if (decision.isFollow() && this.revisionProvider != null) {
                    this.followReference(rev, feature, queue);
                }
                ++n2;
            }
            this.handler.endRevision(rev);
        }
        return this;
    }

    public CDORevisionCrawler begin() {
        this.activate();
        return this;
    }

    public CDORevisionCrawler finish() {
        this.deactivate();
        return this;
    }

    protected void doBeforeActivate() throws Exception {
        CheckUtil.checkState((Object)this.handler, (String)"handler");
        CheckUtil.checkState((Object)((Object)this.containmentProxyStrategy), (String)"containmentProxyStrategy");
        CheckUtil.checkState((Object)this.featureStrategy, (String)"featureStrategy");
    }

    protected void doActivate() throws Exception {
        this.handler.begin(this);
    }

    protected void doDeactivate() throws Exception {
        this.handler.finish();
    }

    private void handleFeature(InternalCDORevision rev, EStructuralFeature feature) {
        this.handler.handleFeature(rev, feature);
    }

    private void followReference(InternalCDORevision revision, EStructuralFeature feature, Queue<InternalCDORevision> queue) {
        if (feature instanceof EReference) {
            EReference reference = (EReference)feature;
            boolean containment = reference.isContainment();
            boolean parentIsResource = revision.isResource();
            if (reference.isMany()) {
                CDOList list = revision.getListOrNull((EStructuralFeature)reference);
                if (list != null) {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        Object value = iterator.next();
                        this.enqueueTarget(containment, parentIsResource, (CDOID)value, queue);
                    }
                }
            } else {
                Object value = revision.getValue((EStructuralFeature)reference);
                this.enqueueTarget(containment, parentIsResource, (CDOID)value, queue);
            }
        }
    }

    private void enqueueTarget(boolean containment, boolean parentIsResource, CDOID targetID, Queue<InternalCDORevision> queue) {
        if (!CDOIDUtil.isNull(targetID)) {
            InternalCDORevision target = (InternalCDORevision)this.revisionProvider.getRevision(targetID);
            if (containment && !CDOIDUtil.isNull((CDOID)target.getContainerID()) && !CDOIDUtil.isNull(target.getResourceID()) && !this.containmentProxyStrategy.follow(parentIsResource)) {
                return;
            }
            queue.offer(target);
        }
    }

    public static enum ContainmentProxyStrategy {
        Physical{

            @Override
            protected boolean follow(boolean parentIsResource) {
                return parentIsResource;
            }
        }
        ,
        Logical{

            @Override
            protected boolean follow(boolean parentIsResource) {
                return !parentIsResource;
            }
        }
        ,
        Any{

            @Override
            protected boolean follow(boolean parentIsResource) {
                return true;
            }
        };


        protected abstract boolean follow(boolean var1);
    }

    public static interface FeatureStrategy {
        public static final FeatureStrategy SINGLE = (revision, feature) -> Decision.Handle;
        public static final FeatureStrategy TREE = (revision, feature) -> {
            EReference reference;
            if (feature instanceof EReference && (reference = (EReference)feature).isContainment()) {
                return Decision.Follow;
            }
            return Decision.Handle;
        };

        public Decision decide(CDORevision var1, EStructuralFeature var2);

        public static enum Decision {
            Skip(false, false),
            Handle(true, false),
            Follow(false, true),
            HandleAndFollow(true, true);

            private final boolean handle;
            private final boolean follow;

            private Decision(boolean handle, boolean follow) {
                this.handle = handle;
                this.follow = follow;
            }

            public boolean isHandle() {
                return this.handle;
            }

            public boolean isFollow() {
                return this.follow;
            }
        }
    }

    public static interface Handler {
        default public boolean begin(CDORevisionCrawler crawler) {
            return true;
        }

        default public boolean beginRevision(CDORevision revision) {
            return true;
        }

        default public void handleFeature(CDORevision revision, EStructuralFeature feature) {
        }

        default public void endRevision(CDORevision revision) {
        }

        default public void finish() {
        }
    }

    public static class MessageDigestHandler
    extends OutputStreamHandler {
        public MessageDigestHandler(MessageDigest digest) {
            super(MessageDigestHandler.newOutputStream(digest));
        }

        public MessageDigestHandler(MessageDigest digest, boolean localIDs, CDOLobLoader lobLoader) {
            super((OutputStream)MessageDigestHandler.newOutputStream(digest), localIDs, lobLoader);
        }

        public MessageDigestHandler(MessageDigest digest, OutputStreamHandler.IDMapper idMapper, CDOLobLoader lobLoader) {
            super((OutputStream)MessageDigestHandler.newOutputStream(digest), idMapper, lobLoader);
        }

        protected MessageDigestHandler(CDODataOutput out, OutputStreamHandler.IDMapper idMapper) {
            super(out, idMapper);
        }

        private static DigestOutputStream newOutputStream(MessageDigest digest) {
            return new DigestOutputStream(IOUtil.nullOutputStream(), digest);
        }
    }

    public static class OutputStreamHandler
    implements Handler {
        private static final byte OPCODE_UNSET = 0;
        private static final byte OPCODE_SET_NULL = 1;
        private static final byte OPCODE_SET_NOT_NULL = 2;
        private final CDODataOutput out;
        private final IDMapper idMapper;
        private CDORevisionCrawler crawler;

        public OutputStreamHandler(OutputStream stream) {
            this(stream, false, null);
        }

        public OutputStreamHandler(OutputStream stream, boolean localIDs, CDOLobLoader lobLoader) {
            this(stream, localIDs ? new IDMapper.InMemory() : null, lobLoader);
        }

        public OutputStreamHandler(OutputStream stream, final IDMapper idMapper, final CDOLobLoader lobLoader) {
            this(new CDODataOutputImpl((ExtendedDataOutput)new ExtendedDataOutputStream(stream)){
                private final CDOIDProvider idProvider;
                {
                    super($anonymous0);
                    this.idProvider = iDMapper == null ? CDOIDProvider.NOOP : realID -> iDMapper.lookup((CDOID)realID);
                }

                @Override
                public CDOIDProvider getIDProvider() {
                    return this.idProvider;
                }

                @Override
                public void writeCDOFeatureValue(EStructuralFeature feature, Object value) throws IOException {
                    if (lobLoader != null) {
                        CDOType type = CDOModelUtil.getType(feature);
                        if (type == CDOType.BLOB || type == CDOType.CLOB) {
                            CDOLob lob = (CDOLob)value;
                            lobLoader.loadLob(lob, this.getDelegate());
                            return;
                        }
                        type.writeValue(this, value);
                        return;
                    }
                    super.writeCDOFeatureValue(feature, value);
                }
            }, idMapper);
        }

        protected OutputStreamHandler(CDODataOutput out, IDMapper idMapper) {
            this.out = out;
            this.idMapper = idMapper;
        }

        public IDMapper getLocalIDMapper() {
            return this.idMapper;
        }

        @Override
        public boolean begin(CDORevisionCrawler crawler) {
            this.crawler = crawler;
            return true;
        }

        @Override
        public final boolean beginRevision(CDORevision revision) {
            if (this.idMapper != null) {
                CDOID realID = revision.getID();
                this.idMapper.map(realID);
                return true;
            }
            return this.doBeginRevision(revision);
        }

        @Override
        public final void handleFeature(CDORevision revision, EStructuralFeature feature) {
            if (this.idMapper != null) {
                return;
            }
            this.doHandleFeature(revision, feature);
        }

        @Override
        public final void endRevision(CDORevision revision) {
            if (this.idMapper != null) {
                return;
            }
            this.doEndRevision(revision);
        }

        public final void finishLocalIDs() {
            if (this.idMapper == null || this.crawler == null) {
                return;
            }
            CDORevisionProvider revisionProvider = this.crawler.revisionProvider();
            if (revisionProvider == null) {
                return;
            }
            FeatureStrategy featureStrategy = this.crawler.featureStrategy();
            this.idMapper.forEach(realID -> {
                CDORevision rev = revisionProvider.getRevision((CDOID)realID);
                EStructuralFeature[] eStructuralFeatureArray = rev.getClassInfo().getAllPersistentFeatures();
                int n = eStructuralFeatureArray.length;
                int n2 = 0;
                while (n2 < n) {
                    EStructuralFeature feature = eStructuralFeatureArray[n2];
                    FeatureStrategy.Decision decision = featureStrategy.decide(rev, feature);
                    if (decision.isHandle()) {
                        this.doHandleFeature(rev, feature);
                    }
                    ++n2;
                }
                this.doEndRevision(rev);
            });
        }

        protected boolean doBeginRevision(CDORevision revision) {
            CDOID id = revision.getID();
            if (this.idMapper != null) {
                id = this.idMapper.lookup(id);
            }
            try {
                this.out.writeCDOID(id);
            }
            catch (IOException ex) {
                throw new IORuntimeException((Throwable)ex);
            }
            return true;
        }

        protected void doHandleFeature(CDORevision revision, EStructuralFeature feature) {
            try {
                Object value = ((InternalCDORevision)revision).getValue(feature);
                if (value == null) {
                    this.out.writeByte(0);
                    return;
                }
                if (value == CDORevisionData.NIL) {
                    this.out.writeByte(1);
                    return;
                }
                this.out.writeByte(2);
                if (feature.isMany()) {
                    CDOList list = (CDOList)value;
                    EClass eClass = revision.getEClass();
                    UnaryOperator idConverter = this.idMapper == null ? null : this.idMapper::lookup;
                    CDODataOutputImpl.writeCDOList(this.out, eClass, feature, list, -1, idConverter);
                } else {
                    if (this.idMapper != null && feature instanceof EReference) {
                        value = this.idMapper.lookup((CDOID)value);
                    }
                    this.out.writeCDOFeatureValue(feature, value);
                }
            }
            catch (IOException ex) {
                throw new IORuntimeException((Throwable)ex);
            }
        }

        protected void doEndRevision(CDORevision revision) {
        }

        public static abstract class IDMapper {
            private long nextMappedID;

            public CDOID map(CDOID realID) {
                CDOID mappedID = this.getNextMappedID();
                this.register(realID, mappedID);
                return mappedID;
            }

            public abstract CDOID lookup(CDOID var1);

            public abstract void forEach(Consumer<? super CDOID> var1);

            protected abstract void register(CDOID var1, CDOID var2);

            protected CDOID getNextMappedID() {
                return CDOIDUtil.createLong(++this.nextMappedID);
            }

            public static final class InMemory
            extends IDMapper {
                private final Map<CDOID, CDOID> mappedIDs = new LinkedHashMap<CDOID, CDOID>();

                @Override
                public CDOID lookup(CDOID realID) {
                    return this.mappedIDs.get(realID);
                }

                @Override
                public void forEach(Consumer<? super CDOID> realIDConsumer) {
                    this.mappedIDs.keySet().forEach(realIDConsumer);
                }

                @Override
                protected void register(CDOID realID, CDOID mappedID) {
                    this.mappedIDs.put(realID, mappedID);
                }
            }
        }
    }
}

