/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.eclipse.core.expressions.Expression;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.mylyn.commons.workbench.editors.CommonTextSupport;
import org.eclipse.mylyn.internal.tasks.ui.editors.RichTextEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorExtensions;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorExtension;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ActiveShellExpression;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;

public abstract class CommentEditor {
    private RichTextEditor textEditor;
    private IContextService contextService;
    private IContextActivation commentContext;
    private CommonTextSupport textSupport;
    private final ITask task;
    private final TaskRepository taskRepository;

    public CommentEditor(ITask task, TaskRepository taskRepository) {
        this.task = task;
        this.taskRepository = taskRepository;
    }

    public void createControl(Composite composite) {
        String contextId;
        AbstractTaskEditorExtension extension = TaskEditorExtensions.getTaskEditorExtension(this.taskRepository);
        if (extension != null && (contextId = extension.getEditorContextId()) != null) {
            this.contextService = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
            if (this.contextService != null) {
                this.commentContext = this.contextService.activateContext(contextId, (Expression)new ActiveShellExpression(composite.getShell()));
            }
        }
        this.textEditor = new RichTextEditor(this.taskRepository, 2624, this.contextService, extension, this.task){

            @Override
            protected void valueChanged(String value) {
                CommentEditor.this.valueChanged(value);
            }
        };
        this.textEditor.createControl(composite, null);
        this.textEditor.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        if (handlerService != null) {
            this.textSupport = new CommonTextSupport(handlerService);
            this.textSupport.install((TextViewer)this.textEditor.getViewer(), true);
        }
    }

    protected abstract void valueChanged(String var1);

    public RichTextEditor getTextEditor() {
        return this.textEditor;
    }

    public String getText() {
        return this.textEditor.getText();
    }

    public void dispose() {
        if (this.contextService != null && this.commentContext != null) {
            this.contextService.deactivateContext(this.commentContext);
            this.commentContext = null;
        }
        if (this.textSupport != null) {
            this.textSupport.dispose();
        }
    }
}

