/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import java.util.ArrayList;
import org.eclipse.cdt.internal.ui.text.contentassist.CProposalContextInformation;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.custom.StyleRange;

public class CParameterListValidator
implements IContextInformationValidator,
IContextInformationPresenter {
    private int fPosition;
    private ITextViewer fViewer;
    private IContextInformation fInformation;
    private int fCurrentParameter;

    public void install(IContextInformation info, ITextViewer viewer, int documentPosition) {
        this.fPosition = documentPosition;
        this.fViewer = viewer;
        this.fInformation = info;
        this.fCurrentParameter = -1;
    }

    private int getCommentEnd(IDocument d, int pos, int end) throws BadLocationException {
        while (pos < end) {
            char curr = d.getChar(pos);
            if (curr != '*' || ++pos >= end || d.getChar(pos) != '/') continue;
            return pos + 1;
        }
        return end;
    }

    private int getStringEnd(IDocument d, int pos, int end, char ch) throws BadLocationException {
        while (pos < end) {
            char curr = d.getChar(pos);
            ++pos;
            if (curr == '\\') {
                ++pos;
                continue;
            }
            if (curr != ch) continue;
            return pos;
        }
        return end;
    }

    private int getCharCount(IDocument document, int start, int end, char increment, char decrement, boolean considerNesting) throws BadLocationException {
        Assert.isTrue(((increment != '\u0000' || decrement != '\u0000') && increment != decrement ? 1 : 0) != 0);
        int parenNestingLevel = 0;
        int braceNestingLevel = 0;
        int charCount = 0;
        block5: while (start < end) {
            char curr = document.getChar(start++);
            switch (curr) {
                case '/': {
                    if (start >= end) continue block5;
                    char next = document.getChar(start);
                    if (next == '*') {
                        start = this.getCommentEnd(document, start + 1, end);
                        break;
                    }
                    if (next != '/') continue block5;
                    start = end;
                    break;
                }
                case '*': {
                    char next;
                    if (start >= end || (next = document.getChar(start)) != '/') continue block5;
                    charCount = 0;
                    ++start;
                    break;
                }
                case '\"': 
                case '\'': {
                    start = this.getStringEnd(document, start, end, curr);
                    break;
                }
                default: {
                    if (considerNesting) {
                        if ('(' == curr) {
                            ++parenNestingLevel;
                        } else if (')' == curr) {
                            --parenNestingLevel;
                        }
                        if (parenNestingLevel != 0) continue block5;
                        if ('{' == curr) {
                            ++braceNestingLevel;
                        } else if ('}' == curr) {
                            --braceNestingLevel;
                        }
                        if (braceNestingLevel != 0) continue block5;
                    }
                    if (increment != '\u0000' && curr == increment) {
                        ++charCount;
                    }
                    if (decrement == '\u0000' || curr != decrement) continue block5;
                    --charCount;
                }
            }
        }
        return charCount;
    }

    public boolean isContextInformationValid(int position) {
        block3: {
            try {
                if (position >= this.fPosition) break block3;
                return false;
            }
            catch (BadLocationException x) {
                return false;
            }
        }
        IDocument document = this.fViewer.getDocument();
        return this.getCharCount(document, this.fPosition, position, '(', ')', false) >= 0;
    }

    public boolean updatePresentation(int position, TextPresentation presentation) {
        int[] commas;
        CProposalContextInformation info;
        String s;
        int currentParameter = -1;
        try {
            currentParameter = this.getCharCount(this.fViewer.getDocument(), this.fPosition, position, ',', '\u0000', true);
        }
        catch (BadLocationException x) {
            return false;
        }
        if (this.fCurrentParameter != -1 && currentParameter == this.fCurrentParameter) {
            return false;
        }
        presentation.clear();
        this.fCurrentParameter = currentParameter;
        String params = s = this.fInformation.getInformationDisplayString();
        int paramlistStartIndex = 0;
        int paramlistEndIndex = s.length();
        if (this.fInformation instanceof CProposalContextInformation && (info = (CProposalContextInformation)this.fInformation).hasPrefixSuffix()) {
            paramlistStartIndex = info.getArglistStartIndex();
            paramlistEndIndex = info.getArglistEndIndex();
            params = s.substring(paramlistStartIndex, paramlistEndIndex);
        }
        if ((commas = this.computeCommaPositions(params)).length - 2 < this.fCurrentParameter) {
            presentation.addStyleRange(new StyleRange(0, s.length(), null, null, 0));
            return true;
        }
        int start = commas[this.fCurrentParameter] + 1;
        int end = commas[this.fCurrentParameter + 1];
        if (start > 0) {
            presentation.addStyleRange(new StyleRange(paramlistStartIndex, start, null, null, 0));
        }
        if (end > start) {
            presentation.addStyleRange(new StyleRange(paramlistStartIndex + start, end - start, null, null, 1));
        }
        if (end < s.length()) {
            presentation.addStyleRange(new StyleRange(paramlistStartIndex + end, params.length() - end, null, null, 0));
        }
        return true;
    }

    private int[] computeCommaPositions(String code) {
        int length = code.length();
        int pos = 0;
        ArrayList<Integer> positions = new ArrayList<Integer>();
        positions.add(-1);
        while (pos < length && pos != -1) {
            char ch = code.charAt(pos);
            switch (ch) {
                case ',': {
                    positions.add(pos);
                    break;
                }
                case '(': {
                    pos = this.indexOfClosingPeer(code, '(', ')', pos);
                    break;
                }
                case '<': {
                    pos = this.indexOfClosingPeer(code, '<', '>', pos);
                    break;
                }
                case '[': {
                    pos = this.indexOfClosingPeer(code, '[', ']', pos);
                    break;
                }
                case '{': {
                    pos = this.indexOfClosingPeer(code, '{', '}', pos);
                    break;
                }
            }
            if (pos == -1) continue;
            ++pos;
        }
        positions.add(length);
        int[] fields = new int[positions.size()];
        int i = 0;
        while (i < fields.length) {
            fields[i] = (Integer)positions.get(i);
            ++i;
        }
        return fields;
    }

    private int indexOfClosingPeer(String code, char left, char right, int pos) {
        int level = 0;
        int length = code.length();
        while (pos < length) {
            char ch = code.charAt(pos);
            if (ch == left) {
                ++level;
            } else if (ch == right && --level == 0) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }
}

