/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.apt.pluggable.core.filer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.apt.core.internal.util.FileSystemUtil;
import org.eclipse.jdt.internal.apt.pluggable.core.dispatch.IdeProcessingEnvImpl;

public class IdeNonSourceOutputStream
extends ByteArrayOutputStream {
    private final IdeProcessingEnvImpl _env;
    private final IFile _file;
    private final Collection<IFile> _parentFiles;

    public IdeNonSourceOutputStream(IdeProcessingEnvImpl env, IFile file, Collection<IFile> parentFiles) {
        this._env = env;
        this._file = file;
        this._parentFiles = parentFiles;
    }

    @Override
    public void close() throws IOException {
        super.close();
        byte[] newContent = this.toByteArray();
        boolean contentsChanged = true;
        try {
            byte[] oldContent = this._file.readAllBytes();
            if (Arrays.equals(newContent, oldContent)) {
                contentsChanged = false;
            }
        }
        catch (CoreException ce) {
            contentsChanged = true;
        }
        if (contentsChanged) {
            FileSystemUtil.saveToDisk((IFile)this._file, (byte[])newContent);
        }
        if (this._parentFiles != null && !this._parentFiles.isEmpty()) {
            this._env.getAptProject().getGeneratedFileManager(this._env.isTestCode()).addGeneratedFileDependency(this._parentFiles, this._file);
            this._env.addNewResource(this._file);
        }
    }
}

