/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.util.ProductPreferences;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.osgi.service.prefs.BackingStoreException;

public class WebappPreferences {
    public String getBanner() {
        return this.getPreferenceString("banner");
    }

    public String getBannerHeight() {
        return this.getPreferenceString("banner_height");
    }

    public String getFooter() {
        return this.getPreferenceString("footer");
    }

    public String getFooterHeight() {
        return this.getPreferenceString("footer_height");
    }

    public String getHelpHome() {
        return this.getPreferenceString("help_home");
    }

    public boolean isIndexView() {
        return ProductPreferences.getBoolean((Plugin)HelpBasePlugin.getDefault(), (String)"indexView");
    }

    public boolean isBookmarksView() {
        return BaseHelpSystem.getMode() != 1 && ProductPreferences.getBoolean((Plugin)HelpBasePlugin.getDefault(), (String)"bookmarksView");
    }

    public boolean isBookmarksAction() {
        return ProductPreferences.getBoolean((Plugin)HelpBasePlugin.getDefault(), (String)"bookmarksView");
    }

    public String getImagesDirectory() {
        String imagesDirectory = this.getPreferenceString("imagesDirectory");
        if (imagesDirectory != null && imagesDirectory.startsWith("/")) {
            imagesDirectory = UrlUtil.getHelpURL(imagesDirectory);
        }
        return imagesDirectory;
    }

    public String getToolbarBackground() {
        return this.getPreferenceString("advanced.toolbarBackground");
    }

    public String getToolbarFont() {
        return this.getPreferenceString("advanced.toolbarFont");
    }

    public String getViewBackground() {
        return this.getPreferenceString("advanced.viewBackground");
    }

    public String getViewBackgroundStyle() {
        String viewBackground = this.getPreferenceString("advanced.viewBackground");
        if (viewBackground == null || viewBackground.length() == 0) {
            return "";
        }
        return "background-color: " + viewBackground + ";";
    }

    public String getViewFont() {
        return this.getPreferenceString("advanced.viewFont");
    }

    public String getTitleResource() {
        return this.getPreferenceString("titleResource");
    }

    public String getQuickPrintMaxConnections() {
        return this.getPreferenceString("maxConnections");
    }

    public String getQuickPrintMaxTopics() {
        return this.getPreferenceString("maxTopics");
    }

    public boolean isWindowTitlePrefix() {
        return ProductPreferences.getBoolean((Plugin)HelpBasePlugin.getDefault(), (String)"windowTitlePrefix");
    }

    public boolean isDontConfirmShowAll() {
        return this.getBooleanPreference("dontConfirmShowAll");
    }

    public void setDontConfirmShowAll(boolean dontconfirm) {
        this.setBooleanPreference("dontConfirmShowAll", dontconfirm);
    }

    public boolean isActiveHelp() {
        return ProductPreferences.getBoolean((Plugin)HelpBasePlugin.getDefault(), (String)"activeHelp");
    }

    public boolean isIndexInstruction() {
        return ProductPreferences.getBoolean((Plugin)HelpBasePlugin.getDefault(), (String)"indexInstruction");
    }

    public boolean isIndexButton() {
        return ProductPreferences.getBoolean((Plugin)HelpBasePlugin.getDefault(), (String)"indexButton");
    }

    public boolean isIndexPlusMinus() {
        return ProductPreferences.getBoolean((Plugin)HelpBasePlugin.getDefault(), (String)"indexPlusMinus");
    }

    public boolean isIndexExpandAll() {
        return ProductPreferences.getBoolean((Plugin)HelpBasePlugin.getDefault(), (String)"indexExpandAll");
    }

    public boolean isHighlightDefault() {
        return this.getBooleanPreference("default_highlight");
    }

    public void setHighlightDefault(boolean highlight) {
        this.setBooleanPreference("default_highlight", highlight);
    }

    public boolean isRestrictTopicParameter() {
        return this.getBooleanPreference("restrictTopicParameter");
    }

    private String getPreferenceString(String key) {
        return Platform.getPreferencesService().getString("org.eclipse.help.base", key, "", null);
    }

    private boolean getBooleanPreference(String key) {
        return Platform.getPreferencesService().getBoolean("org.eclipse.help.base", key, false, null);
    }

    private void setBooleanPreference(String key, boolean value) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.help.base");
        prefs.putBoolean(key, value);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }
}

