/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.ISourcePositionHolder;

public class IfNode
extends Node {
    static final long serialVersionUID = -163780144332979551L;
    private final Node condition;
    private final Node thenBody;
    private final Node elseBody;
    private final ISourcePositionHolder thenKeyword;
    private final ISourcePositionHolder endKeyword;

    public IfNode(ISourcePosition position, Node condition, Node thenBody, Node elseBody, ISourcePositionHolder thenKeyword, ISourcePositionHolder endKeyword) {
        super(position, 46);
        this.condition = condition;
        this.thenBody = thenBody;
        this.elseBody = elseBody;
        this.thenKeyword = thenKeyword;
        this.endKeyword = endKeyword;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitIfNode(this);
    }

    public Node getCondition() {
        return this.condition;
    }

    public Node getElseBody() {
        return this.elseBody;
    }

    public Node getThenBody() {
        return this.thenBody;
    }

    @Override
    public List childNodes() {
        return Node.createList(this.condition, this.thenBody, this.elseBody);
    }

    public ISourcePositionHolder getThenKeyword() {
        return this.thenKeyword;
    }

    public ISourcePositionHolder getEndKeyword() {
        return this.endKeyword;
    }

    public Node getFirstBody() {
        return this.getThenBody();
    }

    public Node getSecondBody() {
        return this.getElseBody();
    }

    public boolean isInline() {
        return false;
    }

    public static class ElseIf
    extends IfNode {
        public ElseIf(ISourcePosition position, Node condition, Node thenBody, Node elseBody, ISourcePositionHolder thenKeyword) {
            super(position, condition, thenBody, elseBody, thenKeyword, null);
        }
    }

    public static class Inline
    extends IfNode {
        public Inline(ISourcePosition position, Node condition, Node thenBody, Node elseBody) {
            super(position, condition, thenBody, elseBody, null, null);
        }

        @Override
        public boolean isInline() {
            return true;
        }
    }

    public static class InlineUnless
    extends Inline {
        public InlineUnless(ISourcePosition position, Node condition, Node thenBody, Node elseBody) {
            super(position, condition, thenBody, elseBody);
        }
    }

    public static class Unless
    extends IfNode {
        public Unless(ISourcePosition position, Node condition, Node thenBody, Node elseBody, ISourcePositionHolder thenKeyword, ISourcePositionHolder endKeyword) {
            super(position, condition, thenBody, elseBody, thenKeyword, endKeyword);
        }

        @Override
        public Node getFirstBody() {
            return this.getElseBody();
        }

        @Override
        public Node getSecondBody() {
            return this.getThenBody();
        }
    }
}

