/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.ISourcePositionHolder;
import org.jruby.parser.StaticScope;

public class IterNode
extends Node {
    static final long serialVersionUID = -9181965000180892184L;
    private final Node varNode;
    private final Node bodyNode;
    private final ISourcePositionHolder begin;
    private final ISourcePositionHolder end;
    private StaticScope scope;

    public IterNode(ISourcePosition position, Node varNode, StaticScope scope, Node bodyNode, ISourcePositionHolder begin, ISourcePositionHolder end) {
        this(position, varNode, scope, bodyNode, 50, begin, end);
    }

    protected IterNode(ISourcePosition position, Node varNode, StaticScope scope, Node bodyNode, int id, ISourcePositionHolder begin, ISourcePositionHolder end) {
        super(position, id);
        this.varNode = varNode;
        this.scope = scope;
        this.bodyNode = bodyNode;
        this.begin = begin;
        this.end = end;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitIterNode(this);
    }

    public StaticScope getScope() {
        return this.scope;
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public Node getVarNode() {
        return this.varNode;
    }

    @Override
    public List childNodes() {
        return Node.createList(this.varNode, this.bodyNode);
    }

    public ISourcePositionHolder getBegin() {
        return this.begin;
    }

    public ISourcePositionHolder getEnd() {
        return this.end;
    }
}

