/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.text.folding;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.ILog;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.tcl.ast.ITclStatementLookLike;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.ast.expressions.TclBlockExpression;
import org.eclipse.dltk.tcl.core.ast.IfStatement;
import org.eclipse.dltk.tcl.core.ast.TclCatchStatement;
import org.eclipse.dltk.tcl.core.ast.TclForStatement;
import org.eclipse.dltk.tcl.core.ast.TclForeachStatement;
import org.eclipse.dltk.tcl.core.ast.TclSwitchStatement;
import org.eclipse.dltk.tcl.core.ast.TclWhileStatement;
import org.eclipse.dltk.tcl.internal.ui.TclUI;
import org.eclipse.dltk.tcl.internal.ui.text.TclPartitionScanner;
import org.eclipse.dltk.tcl.internal.ui.text.folding.TclElementCommentResolver;
import org.eclipse.dltk.tcl.ui.text.TclPartitions;
import org.eclipse.dltk.ui.text.folding.AbstractASTFoldingStructureProvider;
import org.eclipse.dltk.ui.text.folding.IElementCommentResolver;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TclFoldingStructureProvider
extends AbstractASTFoldingStructureProvider {
    private int fBlockFolding = 0;
    private List fBlockIncludeList = new ArrayList();
    private List fBlockExcludeList = new ArrayList();
    private boolean fInitCollapseOtherBlocks;

    public IElementCommentResolver createElementCommentResolver(IModelElement modelElement, String contents) {
        return new TclElementCommentResolver((ISourceModule)modelElement, contents);
    }

    protected AbstractASTFoldingStructureProvider.CodeBlock[] getCodeBlocks(String code, int offset) {
        ModuleDeclaration md = this.parse(code, offset);
        List statements = md.getStatements();
        if (statements == null) {
            return new AbstractASTFoldingStructureProvider.CodeBlock[0];
        }
        ArrayList result = new ArrayList();
        this.traverse(result, statements, offset, code);
        return result.toArray(new AbstractASTFoldingStructureProvider.CodeBlock[result.size()]);
    }

    private void checkStatement(String code, int offset, List result, Statement sst) {
        if (sst instanceof TclStatement) {
            TclStatement statement = (TclStatement)sst;
            result.add(new AbstractASTFoldingStructureProvider.CodeBlock((ASTNode)statement, (IRegion)new Region(offset + statement.sourceStart(), statement.sourceEnd() - statement.sourceStart())));
            for (Expression ex : statement.getExpressions()) {
                if (!(ex instanceof TclBlockExpression)) continue;
                TclBlockExpression be = (TclBlockExpression)ex;
                try {
                    String newContents = code.substring(be.sourceStart() + 1, be.sourceEnd() - 1);
                    AbstractASTFoldingStructureProvider.CodeBlock[] cb = this.getCodeBlocks(newContents, offset + be.sourceStart() + 1);
                    int j = 0;
                    while (j < cb.length) {
                        result.add(cb[j]);
                        ++j;
                    }
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
    }

    private void traverse(List result, List statements, int offset, String code) {
        for (ASTNode node : statements) {
            Block block;
            TypeDeclaration statement;
            if (node instanceof TclStatement) {
                this.checkStatement(code, offset, result, (Statement)node);
                continue;
            }
            boolean fold = false;
            List children = null;
            if (node instanceof TypeDeclaration) {
                statement = (TypeDeclaration)node;
                children = statement.getStatements();
                fold = true;
            } else if (node instanceof MethodDeclaration) {
                statement = (MethodDeclaration)node;
                children = statement.getStatements();
                fold = true;
            } else if (node instanceof IfStatement) {
                ASTNode elseNode;
                fold = true;
                children = new ArrayList();
                statement = (IfStatement)node;
                Statement thenNode = statement.getThen();
                if (thenNode instanceof Block) {
                    children.addAll(((Block)thenNode).getStatements());
                }
                if ((elseNode = statement.getElse()) instanceof Block) {
                    children.addAll(((Block)elseNode).getStatements());
                }
            } else if (node instanceof TclCatchStatement) {
                fold = true;
                statement = (TclCatchStatement)node;
                children = statement.getStatements();
            } else if (node instanceof TclSwitchStatement) {
                fold = true;
                statement = (TclSwitchStatement)node;
                Block alts = statement.getAlternatives();
                if (alts != null) {
                    List childs = alts.getStatements();
                    children = new ArrayList();
                    int i = 0;
                    while (i < childs.size()) {
                        ASTNode child = (ASTNode)childs.get(i);
                        if (child instanceof Block) {
                            result.add(new AbstractASTFoldingStructureProvider.CodeBlock((ASTNode)new TclFoldBlock((Block)child), (IRegion)new Region(offset + child.sourceStart(), child.sourceEnd() - child.sourceStart())));
                            children.addAll(((Block)child).getStatements());
                        }
                        ++i;
                    }
                }
            } else if (node instanceof TclWhileStatement) {
                fold = true;
                statement = (TclWhileStatement)node;
                block = statement.getBlock();
                if (block != null) {
                    children = block.getStatements();
                }
            } else if (node instanceof TclForeachStatement) {
                fold = true;
                statement = (TclForeachStatement)node;
                block = statement.getBlock();
                if (block != null) {
                    children = block.getStatements();
                }
            } else if (node instanceof TclForStatement) {
                fold = true;
                statement = (TclForStatement)node;
                block = statement.getBlock();
                if (block != null) {
                    children = block.getStatements();
                }
            }
            if (fold) {
                result.add(new AbstractASTFoldingStructureProvider.CodeBlock(node, (IRegion)new Region(offset + node.sourceStart(), node.sourceEnd() - node.sourceStart())));
            }
            if (children == null || children.size() <= 0) continue;
            this.traverse(result, children, offset, code);
        }
    }

    protected String getCommentPartition() {
        return "__tcl_comment";
    }

    protected ILog getLog() {
        return TclUI.getDefault().getLog();
    }

    protected String getPartition() {
        return "__tcl_partitioning";
    }

    protected IPartitionTokenScanner getPartitionScanner() {
        return new TclPartitionScanner();
    }

    protected String[] getPartitionTypes() {
        return TclPartitions.TCL_PARTITION_TYPES;
    }

    protected String getNatureId() {
        return "org.eclipse.dltk.tcl.core.nature";
    }

    protected void initializePreferences(IPreferenceStore store) {
        super.initializePreferences(store);
        this.fInitCollapseOtherBlocks = store.getBoolean("editor_folding_init_other_blocks");
        this.fBlockFolding = store.getInt("editor_folding_blocks");
        this.fBlockExcludeList = this.initializeList(store, "editor_folding_exclude_list");
        this.fBlockIncludeList = this.initializeList(store, "editor_folding_include_list");
    }

    protected String getInitiallyFoldClassesKey() {
        return "editor_folding_init_namespaces";
    }

    protected String getInitiallyFoldMethodsKey() {
        return "editor_folding_init_blocks";
    }

    protected boolean initiallyCollapse(ASTNode s) {
        if (s instanceof TclStatement || s instanceof ITclStatementLookLike) {
            TclStatement statement = null;
            statement = s instanceof ITclStatementLookLike ? ((ITclStatementLookLike)s).getStatement() : (TclStatement)s;
            if (statement == null) {
                return false;
            }
            if (!(statement.getAt(0) instanceof SimpleReference)) {
                return false;
            }
            String name = null;
            name = ((SimpleReference)statement.getAt(0)).getName();
            if (name.equals("namespace")) {
                return this.fInitCollapseClasses;
            }
        }
        if (this.mayCollapse(s)) {
            return this.fInitCollapseOtherBlocks;
        }
        return super.initiallyCollapse(s);
    }

    protected void prepareRegions(Document d, List<IRegion> regions) {
        if (regions.isEmpty()) {
            return;
        }
        IRegion region = regions.get(0);
        if (region.getOffset() != 0) {
            return;
        }
        try {
            String content = d.get(region.getOffset(), region.getLength());
            if (!content.startsWith("#!")) {
                return;
            }
            String line0 = d.get(d.getLineOffset(0), d.getLineLength(0));
            if (Pattern.compile("/(sh|bash|dash|tcsh)").matcher(line0).find()) {
                int length;
                int offset;
                String line;
                int i = 1;
                while ((line = d.get(offset = d.getLineOffset(i), length = d.getLineLength(i)).trim()).startsWith("#") || line.endsWith("\\")) {
                    String delimiter = d.getLineDelimiter(i);
                    if (delimiter != null) {
                        offset += delimiter.length();
                    }
                    if (offset + length >= region.getLength()) break;
                    ++i;
                }
                IRegion line2 = d.getLineInformation(i);
                CommentRegion shebang = new CommentRegion(CommentType.SHEBANG, 0, line2.getOffset() + line2.getLength());
                int headerOffset = line2.getOffset() + d.getLineLength(i);
                CommentRegion header = new CommentRegion(CommentType.HEADER, headerOffset, region.getLength() - headerOffset);
                regions.set(0, (IRegion)shebang);
                if (this.isMultilineRegion((IDocument)d, (IRegion)header)) {
                    regions.add(1, (IRegion)header);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    protected IRegion alignRegion(IRegion region, AbstractASTFoldingStructureProvider.FoldingStructureComputationContext ctx) {
        IRegion result = super.alignRegion(region, ctx);
        if (result != region && region instanceof CommentRegion) {
            return new CommentRegion(((CommentRegion)region).commentType, result);
        }
        return result;
    }

    protected boolean initiallyCollapseComments(IRegion region, AbstractASTFoldingStructureProvider.FoldingStructureComputationContext ctx) {
        if (ctx.allowCollapsing()) {
            if (region instanceof CommentRegion && ((CommentRegion)region).commentType == CommentType.SHEBANG) {
                return false;
            }
            return this.isHeaderRegion(region, ctx) ? this.fInitCollapseHeaderComments : this.fInitCollapseComments;
        }
        return false;
    }

    protected boolean isHeaderRegion(IRegion region, AbstractASTFoldingStructureProvider.FoldingStructureComputationContext ctx) {
        if (region instanceof CommentRegion) {
            return ((CommentRegion)region).commentType == CommentType.HEADER;
        }
        return super.isHeaderRegion(region, ctx);
    }

    protected boolean canFold(String name) {
        switch (this.fBlockFolding) {
            case 0: {
                return name.equals("proc") || name.equals("namespace");
            }
            case 1: {
                return this.fBlockIncludeList.contains(name);
            }
            case 2: {
                return !this.fBlockExcludeList.contains(name);
            }
        }
        return false;
    }

    protected boolean mayCollapse(ASTNode s, AbstractASTFoldingStructureProvider.FoldingStructureComputationContext ctx) {
        return this.mayCollapse(s);
    }

    protected boolean mayCollapse(ASTNode s) {
        if (s instanceof TypeDeclaration) {
            return this.canFold("namespace");
        }
        if (s instanceof MethodDeclaration) {
            return this.canFold("proc");
        }
        if (s instanceof IfStatement) {
            return this.canFold("if");
        }
        if (s instanceof TclSwitchStatement) {
            return this.canFold("switch");
        }
        if (s instanceof TclFoldBlock) {
            return this.canFold("switch");
        }
        if (s instanceof TclCatchStatement) {
            return this.canFold("catch");
        }
        if (s instanceof TclWhileStatement) {
            return this.canFold("while");
        }
        if (s instanceof TclForeachStatement) {
            return this.canFold("foreach");
        }
        if (s instanceof TclForStatement) {
            return this.canFold("for");
        }
        if (s instanceof TclStatement) {
            TclStatement statement = (TclStatement)s;
            if (!(statement.getAt(0) instanceof SimpleReference)) {
                return false;
            }
            String name = null;
            name = ((SimpleReference)statement.getAt(0)).getName();
            return this.canFold(name);
        }
        return false;
    }

    private List<String> initializeList(IPreferenceStore store, String key) {
        String t = store.getString(key);
        String[] items = t.split(",");
        ArrayList<String> list = new ArrayList<String>(items.length);
        int i = 0;
        while (i < items.length) {
            if (items[i].trim().length() > 0) {
                list.add(items[i]);
            }
            ++i;
        }
        return list;
    }

    private static class CommentRegion
    extends Region {
        final CommentType commentType;

        public CommentRegion(CommentType commentType, int offset, int length) {
            super(offset, length);
            this.commentType = commentType;
        }

        public CommentRegion(CommentType commentType, IRegion region) {
            super(region.getOffset(), region.getLength());
            this.commentType = commentType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CommentType {
        SHEBANG,
        HEADER;

    }

    private class TclFoldBlock
    extends Block {
        public TclFoldBlock(Block block) {
            super(block.sourceStart(), block.sourceEnd());
            this.getStatements().addAll(block.getStatements());
        }
    }
}

