/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.templates;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.javascript.ast.PropertyInitializer;
import org.eclipse.dltk.javascript.internal.core.codeassist.JavaScriptCompletionUtil;
import org.eclipse.dltk.javascript.internal.ui.JavaScriptUI;
import org.eclipse.dltk.ui.formatter.FormatterException;
import org.eclipse.dltk.ui.formatter.FormatterSyntaxProblemException;
import org.eclipse.dltk.ui.formatter.IScriptFormatter;
import org.eclipse.dltk.ui.formatter.IScriptFormatterFactory;
import org.eclipse.dltk.ui.formatter.ScriptFormatterManager;
import org.eclipse.dltk.ui.templates.ScriptTemplateContext;
import org.eclipse.dltk.ui.text.DocumentUtils;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.text.edits.TextEdit;

public class JavaScriptTemplateContext
extends ScriptTemplateContext {
    public JavaScriptTemplateContext(TemplateContextType type, IDocument document, int completionOffset, int completionLength, ISourceModule sourceModule) {
        super(type, document, completionOffset, completionLength, sourceModule);
    }

    public JavaScriptTemplateContext(TemplateContextType type, IDocument document, Position position, ISourceModule sourceModule) {
        super(type, document, position, sourceModule);
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        String replacement;
        int docEnd;
        JavaScriptCompletionUtil.ExpressionContext expressionContext;
        TemplateBuffer templateBuffer;
        if (!this.canEvaluate(template)) {
            return null;
        }
        IScriptFormatterFactory factory = ScriptFormatterManager.getSelected((String)"org.eclipse.dltk.javascript.core.nature", (IProject)this.getSourceModule().getScriptProject().getProject());
        if (factory != null) {
            IScriptFormatter formatter = factory.createFormatter(TextUtilities.getDefaultLineDelimiter((IDocument)this.getDocument()), factory.retrievePreferences(this.getPreferences()));
            try {
                HashMap<String, String> rememberedVariables = new HashMap<String, String>();
                String encoded = JavaScriptTemplateContext.encodeVariables(template.getPattern(), rememberedVariables);
                TextEdit edit = formatter.format(encoded, 0, encoded.length(), 0);
                if (edit != null) {
                    Document document = new Document(encoded);
                    edit.apply((IDocument)document);
                    template = new Template(template.getName(), template.getDescription(), template.getContextTypeId(), JavaScriptTemplateContext.restoreVariables(document.get(), rememberedVariables), template.isAutoInsertable());
                }
            }
            catch (FormatterSyntaxProblemException rememberedVariables) {
            }
            catch (FormatterException e) {
                JavaScriptUI.log(e);
            }
        }
        if ((templateBuffer = super.evaluate(template)) != null && !this.isReadOnly() && templateBuffer.getString().startsWith("/**") && (expressionContext = JavaScriptCompletionUtil.evaluateExpressionContext((ISourceModule)this.getSourceModule(), (CharSequence)DocumentUtils.asCharSequence((IDocument)this.getDocument()), (int)this.getEnd())) != null && expressionContext.expressionType == JavaScriptCompletionUtil.ExpressionType.PROPERTY_INITIALIZER_VALUE && (docEnd = (replacement = templateBuffer.getString()).indexOf("*/")) > 0) {
            PropertyInitializer propertyInitializer = (PropertyInitializer)expressionContext.node.getParent();
            String doc = String.valueOf(replacement.substring(0, docEnd += "*/".length())) + TextUtilities.getDefaultLineDelimiter((IDocument)this.getDocument()) + JavaScriptTemplateContext.calculateIndent((IDocument)this.getDocument(), (int)propertyInitializer.start());
            while (docEnd + 1 < replacement.length() && Character.isWhitespace(replacement.charAt(docEnd))) {
                ++docEnd;
            }
            if (propertyInitializer.getName().getDocumentation() != null) {
                templateBuffer.setContent(replacement.substring(docEnd), this.filterTemplateVariables(templateBuffer.getVariables(), docEnd));
            } else {
                int docOffset = this.getStart() - propertyInitializer.start() + doc.length();
                this.getDocument().replace(propertyInitializer.start(), 0, doc);
                this.setCompletionOffset(this.getCompletionOffset() + doc.length());
                TemplateVariable[] templateVariableArray = templateBuffer.getVariables();
                int n = templateVariableArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TemplateVariable variable = templateVariableArray[n2];
                    int[] offsets = variable.getOffsets();
                    int i = 0;
                    while (i < offsets.length) {
                        if (offsets[i] < docEnd) {
                            int n3 = i;
                            offsets[n3] = offsets[n3] - docOffset;
                        } else {
                            int n4 = i;
                            offsets[n4] = offsets[n4] - docEnd;
                        }
                        ++i;
                    }
                    ++n2;
                }
                templateBuffer.setContent(replacement.substring(docEnd), templateBuffer.getVariables());
            }
        }
        return templateBuffer;
    }

    private TemplateVariable[] filterTemplateVariables(TemplateVariable[] variables, int offset) {
        ArrayList<TemplateVariable> result = new ArrayList<TemplateVariable>(variables.length);
        TemplateVariable[] templateVariableArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            TemplateVariable variable = templateVariableArray[n2];
            int[] offsets = this.filterOffsets(variable.getOffsets(), offset);
            if (offsets != null) {
                variable.setOffsets(offsets);
                result.add(variable);
            }
            ++n2;
        }
        return result.toArray(new TemplateVariable[result.size()]);
    }

    private int[] filterOffsets(int[] offsets, int offset) {
        int[] result = new int[offset];
        int count = 0;
        int i = 0;
        while (i < offsets.length) {
            if (offsets[i] >= offset) {
                int n = count++;
                result[n] = result[n] - (offsets[i] - offset);
            }
            ++i;
        }
        if (count == 0) {
            return null;
        }
        if (count == result.length) {
            return result;
        }
        int[] newResult = new int[count];
        System.arraycopy(result, 0, newResult, 0, count);
        return newResult;
    }

    private static String encodeVariables(String content, Map<String, String> variables) {
        StringBuilder bf = new StringBuilder(content.length() * 2);
        boolean in = false;
        String prefix = "specialSecret12435Id";
        int r = 0;
        int pos = -1;
        int a = 0;
        while (a < content.length()) {
            char c = content.charAt(a);
            if (c == '$') {
                if (a < content.length() - 1 && content.charAt(a + 1) == '{') {
                    in = true;
                    pos = a;
                }
            } else if (in) {
                if (c == '}') {
                    String variableValue = content.substring(pos, a + 1);
                    String variableKey = "specialSecret12435Id" + r++;
                    if (variableValue.equals("${cursor}")) {
                        variableKey = "/*" + variableKey + "*/";
                    }
                    bf.append(variableKey);
                    variables.put(variableKey, variableValue);
                    in = false;
                }
            } else if (!in) {
                bf.append(c);
            }
            ++a;
        }
        return bf.toString();
    }

    private static String restoreVariables(String value, Map<String, String> variables) {
        String formatted = value;
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            formatted = JavaScriptTemplateContext.replaceSeq(formatted, entry.getKey(), entry.getValue());
        }
        return formatted;
    }

    private static String replaceSeq(String sq, String target, String replacement) {
        int indexOf = sq.indexOf(target);
        while (indexOf != -1) {
            sq = String.valueOf(sq.substring(0, indexOf)) + replacement + sq.substring(indexOf + target.length());
            indexOf = sq.indexOf(target);
        }
        return sq;
    }
}

