/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.launching;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.javascript.launching.JavaScriptLaunchingPlugin;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class ClasspathUtils {
    private static final String PLUGIN_LOCATION_ERROR = "Error determining classpath from bundle {0}";

    public static void collectClasspath(String[] bundleIds, List entries) {
        try {
            boolean developmentMode = Platform.inDevelopmentMode();
            int i = 0;
            while (i < bundleIds.length) {
                File bin;
                String bundleId = bundleIds[i];
                File file = ClasspathUtils.getPluginLocation(bundleId);
                if (developmentMode && file.isDirectory() && (bin = new File(file, "bin")).isDirectory()) {
                    entries.add(bin.getAbsolutePath());
                } else {
                    entries.add(file.getAbsolutePath());
                }
                ++i;
            }
        }
        catch (CoreException e) {
            JavaScriptLaunchingPlugin.error(e);
        }
    }

    private static File getPluginLocation(String bundleId) throws CoreException {
        try {
            Bundle bundle = Platform.getBundle((String)bundleId);
            return ClasspathUtils.getBundleFile(bundle);
        }
        catch (IOException e) {
            String msg = NLS.bind((String)PLUGIN_LOCATION_ERROR, (Object)bundleId);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.javascript.launching", 4, msg, (Throwable)e));
        }
    }

    public static File getBundleFile(Bundle bundle) throws IOException {
        String path;
        URL rootEntry = bundle.getEntry("/");
        if ("file".equals((rootEntry = FileLocator.resolve((URL)rootEntry)).getProtocol())) {
            return new File(rootEntry.getPath());
        }
        if ("jar".equals(rootEntry.getProtocol()) && (path = rootEntry.getPath()).startsWith("file:")) {
            path = path.substring(5, path.length() - 2);
            return new File(path);
        }
        throw new IOException("Unknown protocol");
    }
}

