/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.wizards.buildpath;

import java.util.Arrays;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.internal.ui.util.SelectionUtil;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BuildpathContainerDescriptor;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class BuildpathContainerSelectionPage
extends WizardPage {
    private static final String DIALOGSTORE_SECTION = "BuildpathContainerSelectionPage";
    private static final String DIALOGSTORE_CONTAINER_IDX = "index";
    private ListViewer fListViewer;
    private BuildpathContainerDescriptor[] fContainers;
    private IDialogSettings fDialogSettings;

    protected BuildpathContainerSelectionPage(BuildpathContainerDescriptor[] containerPages) {
        super("BuildpathContainerWizardPage");
        this.setTitle(NewWizardMessages.BuildpathContainerSelectionPage_title);
        this.setDescription(NewWizardMessages.BuildpathContainerSelectionPage_description);
        this.setImageDescriptor(DLTKPluginImages.DESC_WIZBAN_ADD_LIBRARY);
        this.fContainers = containerPages;
        IDialogSettings settings = DLTKUIPlugin.getDefault().getDialogSettings();
        this.fDialogSettings = settings.getSection(DIALOGSTORE_SECTION);
        if (this.fDialogSettings == null) {
            this.fDialogSettings = settings.addNewSection(DIALOGSTORE_SECTION);
            this.fDialogSettings.put(DIALOGSTORE_CONTAINER_IDX, 0);
        }
        this.validatePage();
    }

    public void createControl(Composite parent) {
        this.fListViewer = new ListViewer(parent, 2052);
        this.fListViewer.setLabelProvider((IBaseLabelProvider)new BuildpathContainerLabelProvider());
        this.fListViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fListViewer.setSorter((ViewerSorter)new BuildpathContainerSorter());
        this.fListViewer.setInput(Arrays.asList(this.fContainers));
        this.fListViewer.addSelectionChangedListener(event -> this.validatePage());
        this.fListViewer.addDoubleClickListener(event -> this.doDoubleClick());
        int selectionIndex = this.fDialogSettings.getInt(DIALOGSTORE_CONTAINER_IDX);
        if (selectionIndex >= this.fContainers.length) {
            selectionIndex = 0;
        }
        this.fListViewer.getList().select(selectionIndex);
        this.validatePage();
        this.setControl((Control)this.fListViewer.getList());
        Dialog.applyDialogFont((Control)this.fListViewer.getList());
        if (DLTKCore.DEBUG) {
            System.err.println("BuildpathContainerSelectionPage: add help support here");
        }
    }

    private void validatePage() {
        this.setPageComplete(this.getSelected() != null);
    }

    public BuildpathContainerDescriptor getSelected() {
        if (this.fListViewer != null) {
            ISelection selection = this.fListViewer.getSelection();
            return (BuildpathContainerDescriptor)SelectionUtil.getSingleElement(selection);
        }
        return null;
    }

    public BuildpathContainerDescriptor[] getContainers() {
        return this.fContainers;
    }

    protected void doDoubleClick() {
        if (this.canFlipToNextPage()) {
            this.getContainer().showPage(this.getNextPage());
        }
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public void setVisible(boolean visible) {
        if (!visible && this.fListViewer != null) {
            this.fDialogSettings.put(DIALOGSTORE_CONTAINER_IDX, this.fListViewer.getList().getSelectionIndex());
        }
        super.setVisible(visible);
    }

    private static class BuildpathContainerLabelProvider
    extends LabelProvider {
        private BuildpathContainerLabelProvider() {
        }

        public String getText(Object element) {
            return ((BuildpathContainerDescriptor)element).getName();
        }
    }

    private static class BuildpathContainerSorter
    extends ViewerSorter {
        private BuildpathContainerSorter() {
        }
    }
}

