/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.refactoring.reorg;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.refactoring.reorg.IReorgDestinationValidator;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.ui.refactoring.reorg.DestinationContentProvider;
import org.eclipse.dltk.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.ModelElementLabelProvider;
import org.eclipse.dltk.ui.ModelElementSorter;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

abstract class ReorgUserInputPage
extends UserInputWizardPage {
    private static final long LABEL_FLAGS = ScriptElementLabels.ALL_DEFAULT | 0x20L | 2L | 0x8000L;
    private TreeViewer fViewer;

    public ReorgUserInputPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite result = new Composite(parent, 0);
        this.setControl((Control)result);
        result.setLayout((Layout)new GridLayout());
        Object initialSelection = this.getInitiallySelectedElement();
        this.verifyDestination(initialSelection, true);
        this.addLabel(result);
        this.fViewer = this.createViewer(result);
        this.fViewer.setSelection((ISelection)new StructuredSelection(initialSelection), true);
        this.fViewer.addSelectionChangedListener(event -> this.viewerSelectionChanged(event));
        Dialog.applyDialogFont((Control)result);
    }

    protected Control addLabel(Composite parent) {
        Label label = new Label(parent, 0);
        int resources = this.getResources().length;
        int modelElements = this.getScriptElements().length;
        String text = resources == 0 && modelElements == 1 ? Messages.format(ReorgMessages.ReorgUserInputPage_choose_destination_single, ScriptElementLabels.getDefault().getElementLabel(this.getScriptElements()[0], LABEL_FLAGS)) : (resources == 1 && modelElements == 0 ? Messages.format(ReorgMessages.ReorgUserInputPage_choose_destination_single, this.getResources()[0].getName()) : Messages.format(ReorgMessages.ReorgUserInputPage_choose_destination_multi, String.valueOf(resources + modelElements)));
        label.setText(text);
        label.setLayoutData((Object)new GridData(1, 0x1000008, false, false));
        return label;
    }

    private void viewerSelectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection ss = (IStructuredSelection)selection;
        this.verifyDestination(ss.getFirstElement(), false);
    }

    protected abstract Object getInitiallySelectedElement();

    protected abstract RefactoringStatus verifyDestination(Object var1) throws ModelException;

    protected abstract IResource[] getResources();

    protected abstract IModelElement[] getScriptElements();

    protected abstract IReorgDestinationValidator getDestinationValidator();

    private final void verifyDestination(Object selected, boolean initialVerification) {
        try {
            RefactoringStatus status = this.verifyDestination(selected);
            if (initialVerification) {
                this.setPageComplete(status.isOK());
            } else {
                this.setPageComplete(status);
            }
        }
        catch (ModelException e) {
            DLTKUIPlugin.log(e);
            this.setPageComplete(false);
        }
    }

    private TreeViewer createViewer(Composite parent) {
        TreeViewer treeViewer = new TreeViewer(parent, 2820);
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(40);
        gd.heightHint = this.convertHeightInCharsToPixels(15);
        treeViewer.getTree().setLayoutData((Object)gd);
        treeViewer.setLabelProvider((IBaseLabelProvider)new ModelElementLabelProvider(256));
        treeViewer.setContentProvider((IContentProvider)new DestinationContentProvider(this.getDestinationValidator()));
        treeViewer.setSorter((ViewerSorter)new ModelElementSorter());
        treeViewer.setInput((Object)DLTKCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
        return treeViewer;
    }

    protected TreeViewer getTreeViewer() {
        return this.fViewer;
    }
}

