/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.formatter;

import java.util.HashMap;
import java.util.List;
import org.eclipse.dltk.ui.dialogs.StatusInfo;
import org.eclipse.dltk.ui.formatter.FormatterMessages;
import org.eclipse.dltk.ui.formatter.IProfile;
import org.eclipse.dltk.ui.formatter.IProfileManager;
import org.eclipse.dltk.ui.formatter.IProfileVersioner;
import org.eclipse.dltk.ui.formatter.ProfileKind;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CreateProfileDialog
extends StatusDialog {
    private Text fNameText;
    private Combo fProfileCombo;
    private Button fEditCheckbox;
    private static final StatusInfo fOk = new StatusInfo();
    private static final StatusInfo fEmpty = new StatusInfo(4, FormatterMessages.CreateProfileDialog_nameEmpty);
    private static final StatusInfo fDuplicate = new StatusInfo(4, FormatterMessages.CreateProfileDialog_nameExists);
    private final IProfileManager fProfileManager;
    private final List<IProfile> fSortedProfiles;
    private final String[] fSortedNames;
    private IProfile fCreatedProfile;
    protected boolean fOpenEditDialog;
    private IProfileVersioner versioner;

    public CreateProfileDialog(Shell parentShell, IProfileManager profileManager, IProfileVersioner versioner) {
        super(parentShell);
        this.fProfileManager = profileManager;
        this.fSortedProfiles = this.fProfileManager.getSortedProfiles();
        this.fSortedNames = this.fProfileManager.getSortedDisplayNames();
        this.versioner = versioner;
    }

    public void create() {
        super.create();
        this.setTitle(FormatterMessages.CreateProfileDialog_newProfile);
    }

    public Control createDialogArea(Composite parent) {
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = this.convertWidthInCharsToPixels(60);
        Label nameLabel = new Label(composite, 64);
        nameLabel.setText(FormatterMessages.CreateProfileDialog_profileName);
        nameLabel.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fNameText = new Text(composite, 2052);
        this.fNameText.setLayoutData((Object)gd);
        this.fNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateProfileDialog.this.doValidation();
            }
        });
        gd = new GridData();
        gd.horizontalSpan = 2;
        Label profileLabel = new Label(composite, 64);
        profileLabel.setText(FormatterMessages.CreateProfileDialog_initSettings);
        profileLabel.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fProfileCombo = new Combo(composite, 12);
        this.fProfileCombo.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fEditCheckbox = new Button(composite, 32);
        this.fEditCheckbox.setText(FormatterMessages.CreateProfileDialog_openEditDialog);
        this.fEditCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CreateProfileDialog.this.fOpenEditDialog = ((Button)e.widget).getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fOpenEditDialog = true;
        this.fEditCheckbox.setSelection(this.fOpenEditDialog);
        this.fProfileCombo.setItems(this.fSortedNames);
        this.fProfileCombo.setText(this.fProfileManager.getSelected().getName());
        this.updateStatus(fEmpty);
        CreateProfileDialog.applyDialogFont((Control)composite);
        this.fNameText.setFocus();
        return composite;
    }

    protected void doValidation() {
        String name = this.fNameText.getText().trim();
        if (this.fProfileManager.containsName(name)) {
            this.updateStatus(fDuplicate);
            return;
        }
        if (name.length() == 0) {
            this.updateStatus(fEmpty);
            return;
        }
        this.updateStatus(fOk);
    }

    protected void okPressed() {
        if (!this.getStatus().isOK()) {
            return;
        }
        HashMap<String, String> baseSettings = new HashMap<String, String>(this.fSortedProfiles.get(this.fProfileCombo.getSelectionIndex()).getSettings());
        String profileName = this.fNameText.getText();
        this.fCreatedProfile = this.fProfileManager.create(ProfileKind.CUSTOM, profileName, baseSettings, this.versioner.getFormatterId(), this.versioner.getCurrentVersion());
        super.okPressed();
    }

    public final IProfile getCreatedProfile() {
        return this.fCreatedProfile;
    }

    public final boolean openEditDialog() {
        return this.fOpenEditDialog;
    }
}

