/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.definitions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ArgumentType implements Enumerator
{
    ANY(0, "Any", "Any"),
    INTEGER(1, "Integer", "Integer"),
    INDEX(2, "Index", "Index"),
    NOT_NEGATIVE(3, "NotNegative", "NotNegative"),
    EXPRESSION(4, "Expression", "Expression"),
    SCRIPT(5, "Script", "Script"),
    VAR_NAME(6, "VarName", "VarName"),
    CMD_NAME(7, "CmdName", "CmdName"),
    LEVEL(8, "Level", "Level"),
    PACKAGE(9, "Package", "Package"),
    NAMESPACE(10, "Namespace", "Namespace"),
    BOOLEAN(11, "Boolean", "Boolean");

    public static final int ANY_VALUE = 0;
    public static final int INTEGER_VALUE = 1;
    public static final int INDEX_VALUE = 2;
    public static final int NOT_NEGATIVE_VALUE = 3;
    public static final int EXPRESSION_VALUE = 4;
    public static final int SCRIPT_VALUE = 5;
    public static final int VAR_NAME_VALUE = 6;
    public static final int CMD_NAME_VALUE = 7;
    public static final int LEVEL_VALUE = 8;
    public static final int PACKAGE_VALUE = 9;
    public static final int NAMESPACE_VALUE = 10;
    public static final int BOOLEAN_VALUE = 11;
    private static final ArgumentType[] VALUES_ARRAY;
    public static final List<ArgumentType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ArgumentType[]{ANY, INTEGER, INDEX, NOT_NEGATIVE, EXPRESSION, SCRIPT, VAR_NAME, CMD_NAME, LEVEL, PACKAGE, NAMESPACE, BOOLEAN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ArgumentType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ArgumentType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ArgumentType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ArgumentType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ArgumentType get(int value) {
        switch (value) {
            case 0: {
                return ANY;
            }
            case 1: {
                return INTEGER;
            }
            case 2: {
                return INDEX;
            }
            case 3: {
                return NOT_NEGATIVE;
            }
            case 4: {
                return EXPRESSION;
            }
            case 5: {
                return SCRIPT;
            }
            case 6: {
                return VAR_NAME;
            }
            case 7: {
                return CMD_NAME;
            }
            case 8: {
                return LEVEL;
            }
            case 9: {
                return PACKAGE;
            }
            case 10: {
                return NAMESPACE;
            }
            case 11: {
                return BOOLEAN;
            }
        }
        return null;
    }

    private ArgumentType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

