/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.parser.raw;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.tcl.internal.parser.raw.ISubstitution;
import org.eclipse.dltk.tcl.internal.parser.raw.TclElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TclWord
extends TclElement {
    private final List<Object> contents;
    private int len = -1;

    TclWord() {
        this.contents = new ArrayList<Object>();
    }

    TclWord(List<Object> contents) {
        this.contents = new ArrayList<Object>(contents);
    }

    public void add(String text) {
        Object o = null;
        if (this.contents.size() > 0) {
            o = this.contents.get(this.contents.size() - 1);
        }
        if (o != null && o instanceof String) {
            this.contents.set(this.contents.size() - 1, ((String)o).concat(text));
        } else {
            this.contents.add(text);
        }
        if (this.len != -1) {
            this.len += text.length();
        }
    }

    public void add(char c) {
        if (this.len != -1) {
            ++this.len;
        }
        this.add(String.valueOf(c));
    }

    public void add(ISubstitution s) {
        this.contents.add(s);
        this.len = -1;
    }

    public List<Object> getContents() {
        return this.contents;
    }

    public int length() {
        if (this.len == -1) {
            int result = 0;
            for (Object o : this.contents) {
                if (o instanceof TclElement) {
                    TclElement el = (TclElement)o;
                    result += el.getEnd() - el.getStart() + 1;
                    continue;
                }
                if (!(o instanceof String)) continue;
                result += ((String)o).length();
            }
            this.len = result;
        }
        return this.len;
    }

    public String toString() {
        return "TclWord" + this.contents;
    }
}

