/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.activestatedebugger;

import org.eclipse.dltk.dbgp.DbgpBaseCommands;
import org.eclipse.dltk.dbgp.DbgpRequest;
import org.eclipse.dltk.dbgp.IDbgpCommunicator;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.tcl.activestatedebugger.ErrorAction;
import org.eclipse.dltk.tcl.activestatedebugger.InstrumentationFeature;

public class ActiveStateInstrumentCommands
extends DbgpBaseCommands {
    private static final String INSTRUMENT_SET = "tcl_instrument_set";
    private static final String INSTRUMENT_INCLUDE = "tcl_instrument_include";
    private static final String INSTRUMENT_EXCLUDE = "tcl_instrument_exclude";
    private static final String FILE_OPTION = "-file";
    private static final String D_OPTION = "-d";

    public ActiveStateInstrumentCommands(IDbgpCommunicator communicator) {
        super(communicator);
    }

    public void instrumentSet(InstrumentationFeature feature, boolean value) throws DbgpException {
        DbgpRequest request = ActiveStateInstrumentCommands.createRequest((String)INSTRUMENT_SET);
        request.addOption(D_OPTION, (Object)feature.getValue());
        request.addOption("-e", (Object)(value ? "yes" : "no"));
        this.communicate(request);
    }

    public void setErrorAction(ErrorAction errorAction) throws DbgpException {
        DbgpRequest request = ActiveStateInstrumentCommands.createRequest((String)INSTRUMENT_SET);
        request.addOption(D_OPTION, (Object)"erroraction");
        request.addOption("-value", (Object)errorAction.getValue());
        this.communicate(request);
    }

    public void instrumentInclude(String pattern) throws DbgpException {
        DbgpRequest request = ActiveStateInstrumentCommands.createRequest((String)INSTRUMENT_INCLUDE);
        request.addOption(FILE_OPTION, (Object)pattern);
        this.communicate(request);
    }

    public void instrumentExclude(String pattern) throws DbgpException {
        DbgpRequest request = ActiveStateInstrumentCommands.createRequest((String)INSTRUMENT_EXCLUDE);
        request.addOption(FILE_OPTION, (Object)pattern);
        this.communicate(request);
    }

    public void instrumentInclude(String[] patterns) throws DbgpException {
        String[] stringArray = patterns;
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            this.instrumentInclude(pattern);
            ++n2;
        }
    }

    public void instrumentExclude(String[] patterns) throws DbgpException {
        String[] stringArray = patterns;
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            this.instrumentExclude(pattern);
            ++n2;
        }
    }
}

