/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.lexer.yacc;

import java.io.IOException;
import org.eclipse.dltk.ruby.formatter.lexer.CharHistory;
import org.eclipse.dltk.ruby.formatter.lexer.CharPositionPool;
import org.eclipse.dltk.ruby.formatter.lexer.CharRecord;
import org.eclipse.dltk.ruby.formatter.lexer.ILexerReader;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.ISourcePositionFactory;
import org.jruby.lexer.yacc.RubyYaccLexer;
import org.jruby.lexer.yacc.SourcePositionFactory;
import org.jruby.lexer.yacc.SyntaxException;
import org.jruby.util.ByteList;

public class LexerSource {
    private ISourcePositionFactory positionFactory;
    private final ILexerReader reader;
    private final String sourceName;
    private int column = 0;
    private int offset = 0;
    private final CharPositionPool positionPool = new CharPositionPool();
    private final CharHistory readHistory = new CharHistory(this.positionPool);
    private final CharHistory unreadBuffer = new CharHistory(this.positionPool);

    public LexerSource(String sourceName, ILexerReader reader) {
        this.sourceName = sourceName;
        this.reader = reader;
        this.positionFactory = new SourcePositionFactory(this);
    }

    public LexerSource(String sourceName, ILexerReader reader, ISourcePositionFactory factory) {
        this.sourceName = sourceName;
        this.reader = reader;
        this.positionFactory = factory;
    }

    public char read() throws IOException {
        char c;
        if (!this.unreadBuffer.isEmpty()) {
            CharRecord rec = this.unreadBuffer.getTail();
            c = (char)rec.getCh();
            this.column = rec.getColumn();
            this.offset = rec.getOffset();
            this.unreadBuffer.removeTail();
        } else {
            c = this.wrappedRead();
            if (c == '\u0000') {
                return c;
            }
            this.column = this.reader.getColumn();
            this.offset = this.reader.getOffset();
        }
        this.readHistory.addTail(c, this.column, this.offset);
        return c;
    }

    public void unread(char c) {
        if (c != '\u0000') {
            this.unreadBuffer.addTail(c, this.column, this.offset);
            this.readHistory.removeTail();
            if (this.readHistory.isEmpty()) {
                this.column = 0;
                this.offset = 0;
            } else {
                CharRecord prev = this.readHistory.getTail();
                this.column = prev.getColumn();
                this.offset = prev.getOffset();
            }
        }
    }

    public boolean peek(char to) throws IOException {
        char c = this.read();
        this.unread(c);
        return c == to;
    }

    public String getFilename() {
        return this.sourceName;
    }

    public int getColumn() {
        return this.column;
    }

    public int getOffset() {
        return this.offset <= 0 ? 0 : this.offset;
    }

    public ISourcePosition getPosition(ISourcePosition startPosition, boolean inclusive) {
        return this.positionFactory.getPosition(startPosition, inclusive);
    }

    public ISourcePosition getPosition() {
        return this.positionFactory.getPosition(null, false);
    }

    public ISourcePositionFactory getPositionFactory() {
        return this.positionFactory;
    }

    private char wrappedRead() throws IOException {
        int c = this.reader.read();
        if (c == 13) {
            if (this.reader.peek() == 10) {
                this.reader.read();
            }
            c = 10;
            this.reader.newLine();
        } else if (c == 10) {
            this.reader.newLine();
        }
        return c != -1 ? (char)c : (char)'\u0000';
    }

    public static LexerSource getSource(String name, ILexerReader content) {
        return new LexerSource(name, content);
    }

    public String readLine() throws IOException {
        StringBuffer sb = new StringBuffer(80);
        char c = this.read();
        while (c != '\n' && c != '\u0000') {
            sb.append(c);
            c = this.read();
        }
        return sb.toString();
    }

    public ByteList readLineBytes() throws IOException {
        ByteList bytelist = new ByteList(80);
        char c = this.read();
        while (c != '\n' && c != '\u0000') {
            bytelist.append(c);
            c = this.read();
        }
        return bytelist;
    }

    public void unreadMany(CharSequence buffer) {
        int length = buffer.length();
        int i = length - 1;
        while (i >= 0) {
            this.unread(buffer.charAt(i));
            --i;
        }
    }

    public void unreadMany(CharSequence buffer, int savedColumn, int savedOffset) {
        int length = buffer.length();
        int i = length - 1;
        while (i >= 0) {
            if (i == length - 1) {
                this.unreadBuffer.addTail(buffer.charAt(i), this.column, this.offset);
            } else {
                this.unreadBuffer.addTail(buffer.charAt(i), savedColumn + i + 1, savedOffset + i + 1);
            }
            --i;
        }
        this.column = savedColumn;
        this.offset = savedOffset;
    }

    public boolean matchString(String match, boolean indent) throws IOException {
        int length = match.length();
        StringBuffer buffer = new StringBuffer(length + 20);
        if (indent) {
            char c;
            while ((c = this.read()) != '\u0000') {
                if (!Character.isWhitespace(c)) {
                    this.unread(c);
                    break;
                }
                buffer.append(c);
            }
        }
        int i = 0;
        while (i < length) {
            char c = this.read();
            buffer.append(c);
            if (match.charAt(i) != c) {
                this.unreadMany(buffer);
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean wasBeginOfLine() {
        return this.getColumn() == 1;
    }

    public char readEscape() throws IOException {
        char c = this.read();
        switch (c) {
            case '\\': {
                return c;
            }
            case 'n': {
                return '\n';
            }
            case 't': {
                return '\t';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
            case 'v': {
                return '\u000b';
            }
            case 'a': {
                return '\u0007';
            }
            case 'e': {
                return '\u001b';
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                this.unread(c);
                return this.scanOct(3);
            }
            case 'x': {
                int hexOffset = this.getColumn();
                char hexValue = this.scanHex(2);
                if (hexOffset == this.getColumn()) {
                    throw new SyntaxException(this.getPosition(), "Invalid escape character syntax");
                }
                return hexValue;
            }
            case 'b': {
                return '\b';
            }
            case 's': {
                return ' ';
            }
            case 'M': {
                c = this.read();
                if (c != '-') {
                    throw new SyntaxException(this.getPosition(), "Invalid escape character syntax");
                }
                c = this.read();
                if (c == '\\') {
                    return (char)(this.readEscape() | 0x80);
                }
                if (c == '\u0000') {
                    throw new SyntaxException(this.getPosition(), "Invalid escape character syntax");
                }
                return (char)(c & 0xFF | 0x80);
            }
            case 'C': {
                c = this.read();
                if (c != '-') {
                    throw new SyntaxException(this.getPosition(), "Invalid escape character syntax");
                }
            }
            case 'c': {
                c = this.read();
                if (c == '\\') {
                    c = this.readEscape();
                } else {
                    if (c == '?') {
                        return '\u0177';
                    }
                    if (c == '\u0000') {
                        throw new SyntaxException(this.getPosition(), "Invalid escape character syntax");
                    }
                }
                return (char)(c & 0x9F);
            }
            case '\u0000': {
                throw new SyntaxException(this.getPosition(), "Invalid escape character syntax");
            }
        }
        return c;
    }

    private char scanHex(int count) throws IOException {
        char value = '\u0000';
        int i = 0;
        while (i < count) {
            char c = this.read();
            if (!RubyYaccLexer.isHexChar(c)) {
                this.unread(c);
                break;
            }
            value = (char)(value << 4);
            value = (char)(value | Integer.parseInt("" + c, 16) & 0xF);
            ++i;
        }
        return value;
    }

    private char scanOct(int count) throws IOException {
        char value = '\u0000';
        int i = 0;
        while (i < count) {
            char c = this.read();
            if (!RubyYaccLexer.isOctChar(c)) {
                this.unread(c);
                break;
            }
            value = (char)(value << 3);
            value = (char)(value | Integer.parseInt("" + c, 8));
            ++i;
        }
        return value;
    }

    public char getCharAt(int anOffset) throws IOException {
        StringBuffer buffer = new StringBuffer(anOffset);
        int i = 0;
        while (i < anOffset) {
            buffer.append(this.read());
            ++i;
        }
        int length = buffer.length();
        if (length == 0) {
            return '\u0000';
        }
        int i2 = 0;
        while (i2 < length) {
            this.unread(buffer.charAt(i2));
            ++i2;
        }
        return buffer.charAt(length - 1);
    }

    public String toString() {
        try {
            StringBuffer buffer = new StringBuffer(20);
            int i = 0;
            while (i < 20) {
                buffer.append(this.read());
                ++i;
            }
            i = 0;
            while (i < 20) {
                this.unread(buffer.charAt(buffer.length() - i - 1));
                ++i;
            }
            buffer.append(" ...");
            return buffer.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

