/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.core;

import java.util.Collections;
import java.util.Set;
import org.eclipse.dltk.compiler.problem.IProblemCategory;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.javascript.internal.core.RTypeDeclaration;
import org.eclipse.dltk.javascript.typeinfo.IRMember;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.IRTypeDeclaration;
import org.eclipse.dltk.javascript.typeinfo.ITypeSystem;
import org.eclipse.dltk.javascript.typeinfo.RTypes;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.dltk.javascript.typeinfo.model.Visibility;

public class RMember<E extends Member>
implements IRMember {
    protected final E member;
    private final RTypeDeclaration typeDeclaration;
    private IRType type;
    private boolean initialized;

    public RMember(E member, IRTypeDeclaration typeDeclaration) {
        assert (typeDeclaration != null);
        this.member = member;
        this.typeDeclaration = (RTypeDeclaration)typeDeclaration;
    }

    public RMember(E member, IRType type, IRTypeDeclaration typeDeclaration) {
        this.member = member;
        this.typeDeclaration = (RTypeDeclaration)typeDeclaration;
        this.type = type;
        this.initialized = true;
    }

    protected final synchronized void checkInitialized() {
        if (!this.initialized) {
            this.initialize(this.typeDeclaration.getEffectiveTypeSystem());
            this.initialized = true;
        }
    }

    protected void initialize(ITypeSystem typeSystem) {
        this.type = RTypes.create(typeSystem, this.member.getType());
    }

    @Override
    public String getName() {
        return this.member.getName();
    }

    @Override
    public Visibility getVisibility() {
        return this.member.getVisibility();
    }

    @Override
    public IRTypeDeclaration getDeclaringType() {
        return this.typeDeclaration;
    }

    @Override
    public Set<IProblemCategory> getSuppressedWarnings() {
        return Collections.emptySet();
    }

    @Override
    public boolean isSuppressed(IProblemIdentifier problemIdentifier) {
        return false;
    }

    @Override
    public boolean isDeprecated() {
        return this.member.isDeprecated();
    }

    @Override
    public Object getSource() {
        return this.member;
    }

    @Override
    public IRType getType() {
        this.checkInitialized();
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.member.hashCode();
        result = 31 * result + this.typeDeclaration.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RMember other = (RMember)obj;
        return this.member.equals(other.member) && this.typeDeclaration.equals(other.typeDeclaration);
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public boolean isStatic() {
        return this.member.isStatic();
    }

    @Override
    public boolean isVisible() {
        return this.member.isVisible();
    }
}

