/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.typeinference.evaluators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.CallArgumentsList;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.evaluation.types.AmbiguousType;
import org.eclipse.dltk.ruby.ast.RubyReturnStatement;
import org.eclipse.dltk.ruby.core.RubyPlugin;
import org.eclipse.dltk.ruby.core.model.FakeMethod;
import org.eclipse.dltk.ruby.internal.parser.mixin.IRubyMixinElement;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinClass;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinMethod;
import org.eclipse.dltk.ruby.typeinference.MethodContext;
import org.eclipse.dltk.ruby.typeinference.RubyClassType;
import org.eclipse.dltk.ruby.typeinference.RubyModelUtils;
import org.eclipse.dltk.ruby.typeinference.RubyTypeInferencingUtils;
import org.eclipse.dltk.ruby.typeinference.evaluators.RubyMixinGoalEvaluator;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.InstanceContext;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.goals.MethodReturnTypeGoal;
import org.eclipse.dltk.ti.types.ClassType;
import org.eclipse.dltk.ti.types.IEvaluatedType;

public class MethodReturnTypeEvaluator
extends RubyMixinGoalEvaluator {
    private final List possibilities = new ArrayList();
    private final List evaluated = new ArrayList();
    private IEvaluatedType rdocResult = null;
    private MethodContext innerContext;

    public MethodReturnTypeEvaluator(IGoal goal) {
        super(goal);
    }

    private MethodReturnTypeGoal getTypedGoal() {
        return (MethodReturnTypeGoal)this.getGoal();
    }

    private InstanceContext getTypedContext() {
        return (InstanceContext)this.getGoal().getContext();
    }

    public Object produceResult() {
        if (this.rdocResult != null) {
            return this.rdocResult;
        }
        if (!this.evaluated.isEmpty()) {
            return RubyTypeInferencingUtils.combineTypes(this.evaluated);
        }
        return null;
    }

    public IGoal[] init() {
        String[] parameters;
        MethodReturnTypeGoal typedGoal = this.getTypedGoal();
        InstanceContext typedContext = this.getTypedContext();
        Object instanceType = typedContext.getInstanceType();
        if (instanceType instanceof AmbiguousType) {
            instanceType = ((AmbiguousType)instanceType).getPossibleTypes()[0];
        }
        String methodName = typedGoal.getMethodName();
        if (!(instanceType instanceof RubyClassType)) {
            return null;
        }
        IEvaluatedType intrinsicMethodReturnType = this.checkSpecialMethodReturnType((ClassType)instanceType, methodName, typedGoal.getArguments());
        if (intrinsicMethodReturnType != null) {
            this.evaluated.add(intrinsicMethodReturnType);
            return IGoal.NO_GOALS;
        }
        MethodDeclaration decl = null;
        ArrayList<IMethod> methods = new ArrayList<IMethod>();
        if (instanceType == null) {
            instanceType = new RubyClassType("Object");
        }
        if (instanceType instanceof RubyClassType) {
            IRubyMixinElement element;
            RubyMixinMethod mixinMethods;
            RubyClassType rubyClassType = (RubyClassType)((Object)instanceType);
            RubyMixinClass class1 = this.mixinModel.createRubyClass(rubyClassType);
            if (class1 != null && (mixinMethods = class1.getMethod(methodName)) != null) {
                methods.addAll(Arrays.asList(mixinMethods.getSourceMethods()));
            }
            if (rubyClassType.getModelKey().equals("Object") && (element = this.mixinModel.createRubyElement(methodName)) instanceof RubyMixinMethod) {
                RubyMixinMethod rubyMixinMethod = (RubyMixinMethod)element;
                methods.addAll(Arrays.asList(rubyMixinMethod.getSourceMethods()));
            }
        }
        IMethod resultMethod = null;
        IMethod resultMethodFromSameModule = null;
        for (IMethod method : methods) {
            String elementName;
            if (method instanceof FakeMethod || method == null || !(elementName = method.getElementName()).equals(methodName)) continue;
            if (method.getSourceModule().equals(typedContext.getSourceModule())) {
                resultMethodFromSameModule = method;
            }
            resultMethod = method;
        }
        if (resultMethodFromSameModule != null) {
            resultMethod = resultMethodFromSameModule;
        }
        if (resultMethod == null) {
            return IGoal.NO_GOALS;
        }
        ISourceModule sourceModule = resultMethod.getSourceModule();
        ModuleDeclaration module = RubyTypeInferencingUtils.parseSource(sourceModule);
        try {
            decl = RubyModelUtils.getNodeByMethod(module, resultMethod);
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        try {
            parameters = resultMethod.getParameterNames();
        }
        catch (ModelException e1) {
            RubyPlugin.log((Exception)((Object)e1));
            parameters = new String[]{};
        }
        this.innerContext = new MethodContext(this.goal.getContext(), sourceModule, module, parameters, typedGoal.getArguments());
        ASTVisitor visitor = new ASTVisitor(){

            public boolean visitGeneral(ASTNode node) throws Exception {
                if (node instanceof RubyReturnStatement) {
                    RubyReturnStatement statement = (RubyReturnStatement)node;
                    CallArgumentsList list = statement.getValue();
                    if (list.getChilds().size() == 0) {
                        MethodReturnTypeEvaluator.this.evaluated.add(new RubyClassType("NilClass"));
                    } else if (list.getChilds().size() > 1) {
                        MethodReturnTypeEvaluator.this.evaluated.add(new RubyClassType("Array"));
                    } else {
                        MethodReturnTypeEvaluator.this.possibilities.add(list.getChilds().get(0));
                    }
                }
                return super.visitGeneral(node);
            }
        };
        if (decl != null) {
            try {
                decl.traverse(visitor);
            }
            catch (Exception e) {
                RubyPlugin.log(e);
            }
            if (decl.getBody() != null) {
                this.possibilities.add(decl.getBody());
            }
        }
        IGoal[] newGoals = new IGoal[this.possibilities.size()];
        int i = 0;
        for (ASTNode st : this.possibilities) {
            ExpressionTypeGoal subgoal = new ExpressionTypeGoal((IContext)this.innerContext, st);
            newGoals[i++] = subgoal;
        }
        return newGoals;
    }

    private IEvaluatedType checkSpecialMethodReturnType(ClassType instanceType, String methodName, IEvaluatedType[] arguments) {
        if (methodName.equals("clone") && instanceType.getModelKey().endsWith("%")) {
            return instanceType;
        }
        if (instanceType == null || instanceType.getModelKey().endsWith("%") || instanceType.getModelKey().endsWith("%v")) {
            return null;
        }
        if (methodName.equals("new")) {
            return new RubyClassType(String.valueOf(instanceType.getModelKey()) + "%");
        }
        return null;
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        if (result != null) {
            this.evaluated.add(result);
        }
        return IGoal.NO_GOALS;
    }
}

