/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.browsing;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.IPlaceholderFolderLayout;

public class TclBrowsingPerspectiveFactory
implements IPerspectiveFactory {
    public static final String ID_PROJECTS_VIEW = "org.eclipse.dltk.tcl.ui.Projects";
    public static final String ID_PACKAGES_VIEW = "org.eclipse.dltk.tcl.ui.extbrowsing";
    public static final String ID_MEMBERS_VIEW = "org.eclipse.dltk.tcl.ui.Members";
    static IModelElement fgModelElementFromAction;

    public void createInitialLayout(IPageLayout layout) {
        this.createHorizontalLayout(layout);
        layout.addShowViewShortcut("org.eclipse.ui.views.ContentOutline");
        layout.addShowViewShortcut("org.eclipse.ui.views.ProblemView");
        layout.addShowViewShortcut("org.eclipse.ui.views.ResourceNavigator");
        layout.addShowViewShortcut("org.eclipse.ui.views.TaskList");
        layout.addShowViewShortcut("org.eclipse.ui.views.ProgressView");
        this.addActionSets(layout);
        this.addShowViewShortcuts(layout);
        this.addNewWizardShortcuts(layout);
    }

    private void createHorizontalLayout(IPageLayout layout) {
        String relativePartId = "org.eclipse.ui.editorss";
        int relativePos = 3;
        if (this.shouldShowProjectsView()) {
            layout.addView(ID_PROJECTS_VIEW, 3, 0.25f, "org.eclipse.ui.editorss");
            relativePartId = ID_PROJECTS_VIEW;
            relativePos = 2;
        }
        if (this.shouldShowPackagesView()) {
            layout.addView(ID_PACKAGES_VIEW, relativePos, 0.25f, relativePartId);
            relativePartId = ID_PACKAGES_VIEW;
            relativePos = 2;
        }
        layout.addView(ID_MEMBERS_VIEW, 2, 0.75f, ID_PACKAGES_VIEW);
        IPlaceholderFolderLayout placeHolderLeft = layout.createPlaceholderFolder("left", 1, 0.25f, "org.eclipse.ui.editorss");
        placeHolderLeft.addPlaceholder("org.eclipse.ui.views.ContentOutline");
        placeHolderLeft.addPlaceholder("org.eclipse.dltk.ui.ScriptExplorer");
        placeHolderLeft.addPlaceholder("org.eclipse.ui.views.ResourceNavigator");
        IPlaceholderFolderLayout placeHolderBottom = layout.createPlaceholderFolder("bottom", 4, 0.75f, "org.eclipse.ui.editorss");
        placeHolderBottom.addPlaceholder("org.eclipse.ui.views.ProblemView");
        placeHolderBottom.addPlaceholder("org.eclipse.ui.views.BookmarkView");
        placeHolderBottom.addPlaceholder("org.eclipse.ui.views.ProgressView");
    }

    protected void addNewWizardShortcuts(IPageLayout layout) {
        layout.addNewWizardShortcut("org.eclipse.dltk.tcl.internal.ui.wizards.TclProjectWizard");
        layout.addNewWizardShortcut("org.eclipse.dltk.tcl.internal.ui.wizards.TclFileCreationWizard");
        layout.addNewWizardShortcut("org.eclipse.dltk.tcl.ui.wizards.NewSourceFolderCreationWizard");
        layout.addNewWizardShortcut("org.eclipse.dltk.tcl.ui.wizards.NewPackageCreationWizard");
        layout.addNewWizardShortcut("org.eclipse.ui.wizards.new.folder");
        layout.addNewWizardShortcut("org.eclipse.ui.wizards.new.file");
        layout.addNewWizardShortcut("org.eclipse.ui.editors.wizards.UntitledTextFileWizard");
    }

    protected void addShowViewShortcuts(IPageLayout layout) {
        layout.addShowViewShortcut("org.eclipse.ui.views.ContentOutline");
        layout.addShowViewShortcut("org.eclipse.ui.views.ProblemView");
        layout.addShowViewShortcut("org.eclipse.ui.views.TaskList");
        layout.addShowViewShortcut("org.eclipse.ui.views.ProgressView");
    }

    protected void addActionSets(IPageLayout layout) {
        layout.addActionSet("org.eclipse.ui.NavigateActionSet");
        layout.addActionSet("org.eclipse.dltk.tcl.ui.TclActionSet");
    }

    private boolean shouldShowProjectsView() {
        return fgModelElementFromAction == null || fgModelElementFromAction.getElementType() == 1;
    }

    private boolean shouldShowPackagesView() {
        if (fgModelElementFromAction == null) {
            return true;
        }
        int type = fgModelElementFromAction.getElementType();
        return type == 1 || type == 2 || type == 3;
    }

    static void setInputFromAction(IAdaptable input) {
        fgModelElementFromAction = input instanceof IModelElement ? (IModelElement)input : null;
    }
}

