/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IIndexedValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.dltk.dbgp.IDbgpProperty;
import org.eclipse.dltk.dbgp.commands.IDbgpCoreCommands;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.debug.core.ScriptDebugManager;
import org.eclipse.dltk.debug.core.eval.IScriptEvaluationCommand;
import org.eclipse.dltk.debug.core.eval.IScriptEvaluationEngine;
import org.eclipse.dltk.debug.core.model.AtomicScriptType;
import org.eclipse.dltk.debug.core.model.IScriptStackFrame;
import org.eclipse.dltk.debug.core.model.IScriptThread;
import org.eclipse.dltk.debug.core.model.IScriptType;
import org.eclipse.dltk.debug.core.model.IScriptTypeFactory;
import org.eclipse.dltk.debug.core.model.IScriptValue;
import org.eclipse.dltk.internal.debug.core.eval.ScriptEvaluationCommand;
import org.eclipse.dltk.internal.debug.core.model.Messages;
import org.eclipse.dltk.internal.debug.core.model.ScriptDebugElement;
import org.eclipse.dltk.internal.debug.core.model.ScriptVariable;
import org.eclipse.dltk.internal.debug.core.model.UnknownVariable;
import org.eclipse.osgi.util.NLS;

public class ScriptValue
extends ScriptDebugElement
implements IScriptValue,
IIndexedValue {
    static final IVariable[] NO_VARIABLES = new IVariable[0];
    private final IScriptType type;
    final IVariable[] variables;
    private IScriptStackFrame frame;
    private int pageSize;
    private String name;
    private String fullname;
    private String value;
    private String details;
    private boolean hasChildren;
    private String key;
    private String rawValue;
    private String address;

    public static IScriptValue createValue(IScriptStackFrame frame, IDbgpProperty property) {
        IScriptType type = ScriptValue.createType(frame.getDebugTarget(), property);
        return new ScriptValue(frame, property, type);
    }

    private static IScriptType createType(IDebugTarget target, IDbgpProperty property) {
        IScriptType type = null;
        String rawType = property.getType();
        IScriptTypeFactory factory = ScriptDebugManager.getInstance().getTypeFactoryByDebugModel(target.getModelIdentifier());
        type = factory != null ? factory.buildType(rawType) : new AtomicScriptType(rawType);
        return type;
    }

    protected ScriptValue(IScriptStackFrame frame, IDbgpProperty property, IScriptType type) {
        this.frame = frame;
        this.type = type;
        this.key = property.getKey();
        this.name = property.getName();
        this.fullname = property.getEvalName();
        this.rawValue = property.getValue();
        this.value = null;
        this.hasChildren = property.hasChildren();
        this.pageSize = property.getPageSize();
        this.address = property.getAddress();
        int childrenCount = property.getChildrenCount();
        if (childrenCount > 0) {
            this.variables = new IVariable[childrenCount];
            this.fillVariables(property.getPage(), property);
        } else {
            this.variables = NO_VARIABLES;
        }
    }

    private void loadPage(int page) throws DbgpException {
        IDbgpCoreCommands commands = this.frame.getScriptThread().getDbgpSession().getCoreCommands();
        IDbgpProperty pageProperty = commands.getProperty(page, this.fullname, this.frame.getLevel());
        this.fillVariables(page, pageProperty);
        int endIndex = Math.min((page + 1) * this.pageSize, this.variables.length);
        int i = page * this.pageSize;
        while (i < endIndex) {
            if (this.variables[i] == null) {
                this.variables[i] = new UnknownVariable(this.frame, this, i);
            }
            ++i;
        }
    }

    private void fillVariables(int page, IDbgpProperty pageProperty) {
        int offset = this.getPageOffset(page);
        IDbgpProperty[] properties = pageProperty.getAvailableChildren();
        int size = Math.min(properties.length, this.variables.length - offset);
        if (size != properties.length) {
            DLTKDebugPlugin.logWarning(NLS.bind((String)Messages.AvailableChildrenExceedsVariableLength, (Object)this.name), null);
        }
        if (size > 0) {
            int i = 0;
            while (i < size) {
                IDbgpProperty p = properties[i];
                this.variables[offset + i] = new ScriptVariable(this.frame, p.getName(), p);
                ++i;
            }
            Arrays.sort(this.variables, offset, offset + size, ScriptDebugManager.getInstance().getVariableNameComparatorByDebugModel(this.getDebugTarget().getModelIdentifier()));
        }
        Assert.isLegal((this.pageSize > 0 || properties.length == this.variables.length ? 1 : 0) != 0);
    }

    private int getPageOffset(int page) {
        if (this.pageSize <= 0) {
            this.pageSize = this.frame.getScriptThread().getPropertyPageSize();
        }
        if (this.pageSize <= 0) {
            return 0;
        }
        return page * this.pageSize;
    }

    private int getPageForOffset(int offset) {
        Assert.isLegal((this.pageSize > 0 ? 1 : 0) != 0);
        return offset / this.pageSize;
    }

    public String getReferenceTypeName() {
        return this.getType().getName();
    }

    public String getValueString() {
        if (this.value == null || this.value.length() == 0) {
            this.value = this.type.formatValue(this);
        }
        return this.value;
    }

    public String getDetailsString() {
        if (this.details == null || this.details.length() == 0) {
            this.details = this.type.formatDetails(this);
        }
        return this.details;
    }

    public String getRawValue() {
        return this.rawValue;
    }

    public String getEvalName() {
        return this.fullname;
    }

    public boolean hasVariables() {
        return this.hasChildren;
    }

    public boolean isAllocated() {
        return true;
    }

    public String toString() {
        return this.getValueString();
    }

    public IDebugTarget getDebugTarget() {
        return this.frame.getDebugTarget();
    }

    public String getInstanceId() {
        return this.key;
    }

    public IScriptType getType() {
        return this.type;
    }

    public IScriptEvaluationCommand createEvaluationCommand(String messageTemplate, IScriptThread thread) {
        IScriptEvaluationEngine engine = thread.getEvaluationEngine();
        String pattern = "(%variable%)";
        String evalName = this.getEvalName();
        if (messageTemplate.indexOf(pattern) != -1) {
            String snippet = ScriptValue.replacePattern(messageTemplate, pattern, evalName);
            return new ScriptEvaluationCommand(engine, snippet, this.frame);
        }
        DLTKDebugPlugin.logWarning(NLS.bind((String)Messages.ScriptValue_detailFormatterRequiredToContainIdentifier, (Object)pattern), null);
        return new ScriptEvaluationCommand(engine, evalName, this.frame);
    }

    private static String replacePattern(String messageTemplate, String pattern, String evalName) {
        String result = messageTemplate;
        while (result.indexOf(pattern) != -1) {
            int pos = result.indexOf(pattern);
            result = String.valueOf(result.substring(0, pos)) + evalName + result.substring(pos + pattern.length(), result.length());
        }
        return result;
    }

    public int getInitialOffset() {
        return 0;
    }

    public int getSize() {
        return this.variables.length;
    }

    public IVariable getVariable(int offset) throws DebugException {
        try {
            if (this.variables[offset] == null) {
                this.loadPage(this.getPageForOffset(offset));
            }
            return this.variables[offset];
        }
        catch (DbgpException e) {
            throw this.wrapDbgpException(NLS.bind((String)Messages.ScriptValue_unableToLoadChildrenOf, (Object)this.name), e);
        }
    }

    public IVariable[] getVariables() throws DebugException {
        return this.getVariables(0, this.getSize());
    }

    public IVariable[] getVariables(int offset, int length) throws DebugException {
        IVariable[] variables = new IVariable[length];
        int i = 0;
        while (i < length) {
            variables[i] = this.getVariable(offset + i);
            ++i;
        }
        return variables;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IIndexedValue.class && this.type.isCollection()) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public String getName() {
        return this.name;
    }

    public String getMemoryAddress() {
        return this.address;
    }

    protected boolean hasChildrenValuesLoaded() {
        int i = 0;
        while (i < this.variables.length) {
            if (this.variables[i] != null) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

