/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search.indexing;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.CRC32;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.compiler.util.SimpleLookupTable;
import org.eclipse.dltk.compiler.util.Util;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceElementParser;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.search.BasicSearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.index.Index;
import org.eclipse.dltk.core.search.index.MixinIndex;
import org.eclipse.dltk.core.search.indexing.IIndexConstants;
import org.eclipse.dltk.core.search.indexing.IndexRequest;
import org.eclipse.dltk.core.search.indexing.ReadWriteMonitor;
import org.eclipse.dltk.core.search.indexing.RemoveFolderFromIndex;
import org.eclipse.dltk.core.search.indexing.RemoveFromIndex;
import org.eclipse.dltk.core.search.indexing.SourceIndexerRequestor;
import org.eclipse.dltk.internal.core.Model;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.core.search.PatternSearchJob;
import org.eclipse.dltk.internal.core.search.ProjectIndexerManager;
import org.eclipse.dltk.internal.core.search.processing.IJob;
import org.eclipse.dltk.internal.core.search.processing.JobManager;
import org.eclipse.dltk.internal.core.util.Messages;

public class IndexManager
extends JobManager
implements IIndexConstants {
    public SimpleLookupTable indexLocations = new SimpleLookupTable();
    private Map indexes = new HashMap(5);
    private boolean needToSave = false;
    private static final CRC32 checksumCalculator = new CRC32();
    private IPath scriptPluginLocation = null;
    private SimpleLookupTable indexStates = null;
    private File savedIndexNamesFile = this.getScriptPluginWorkingLocation().append("savedIndexNames.txt").toFile();
    public static final Integer SAVED_STATE = new Integer(0);
    public static final Integer UPDATING_STATE = new Integer(1);
    public static final Integer UNKNOWN_STATE = new Integer(2);
    public static final Integer REBUILDING_STATE = new Integer(3);
    public static final String SPECIAL = "#special#";
    public static final String SPECIAL_MIXIN = "#special#mixin#";
    public static final String SPECIAL_BUILTIN = "#special#builtin#";

    public synchronized void aboutToUpdateIndex(IPath containerPath, Integer newIndexState) {
        Integer currentIndexState;
        String indexLocation = this.computeIndexLocation(containerPath);
        Object state = this.getIndexStates().get(indexLocation);
        Integer n = currentIndexState = state == null ? UNKNOWN_STATE : (Integer)state;
        if (currentIndexState.equals(REBUILDING_STATE)) {
            return;
        }
        int compare = newIndexState.compareTo(currentIndexState);
        if (compare > 0) {
            this.updateIndexState(indexLocation, newIndexState);
        } else if (compare < 0 && this.indexes.get(indexLocation) == null) {
            this.rebuildIndex(indexLocation, containerPath);
        }
    }

    public void cleanUpIndexes() {
        File[] indexesFiles;
        File indexesDirectory;
        SimpleLookupTable knownPaths = new SimpleLookupTable();
        IDLTKSearchScope scope = BasicSearchEngine.createWorkspaceScope(null);
        PatternSearchJob job = new PatternSearchJob(null, SearchEngine.getDefaultSearchParticipant(), scope, null);
        Index[] selectedIndexes = job.getIndexes(null);
        int j = 0;
        int max = selectedIndexes.length;
        while (j < max) {
            String path = selectedIndexes[j].getIndexFile().getAbsolutePath();
            knownPaths.put(path, path);
            ++j;
        }
        if (this.indexStates != null) {
            Object[] keys = this.indexStates.keyTable;
            int keysLength = keys.length;
            int updates = 0;
            String[] locations = new String[keysLength];
            int i = 0;
            int l = keys.length;
            while (i < l) {
                String key = (String)keys[i];
                if (key != null && !knownPaths.containsKey(key)) {
                    locations[updates++] = key;
                }
                ++i;
            }
            if (updates > 0) {
                this.removeIndexesState(locations);
            }
        }
        if ((indexesDirectory = this.getScriptPluginWorkingLocation().toFile()).isDirectory() && (indexesFiles = indexesDirectory.listFiles()) != null) {
            int i = 0;
            int indexesFilesLength = indexesFiles.length;
            while (i < indexesFilesLength) {
                String fileName = indexesFiles[i].getAbsolutePath();
                if (!knownPaths.containsKey(fileName) && fileName.toLowerCase().endsWith(".index")) {
                    indexesFiles[i].delete();
                }
                ++i;
            }
        }
    }

    public synchronized String computeIndexLocation(IPath containerPath) {
        String indexLocation = (String)this.indexLocations.get(containerPath);
        if (indexLocation == null) {
            String pathString = containerPath.toString();
            checksumCalculator.reset();
            checksumCalculator.update(pathString.getBytes());
            String fileName = String.valueOf(Long.toString(checksumCalculator.getValue())) + ".index";
            indexLocation = this.getScriptPluginWorkingLocation().append(fileName).toOSString();
            this.indexLocations.put(containerPath, indexLocation);
        }
        return indexLocation;
    }

    public void ensureIndexExists(String indexLocation, IPath containerPath) {
        SimpleLookupTable states = this.getIndexStates();
        Object state = states.get(indexLocation);
        if (state == null) {
            this.updateIndexState(indexLocation, REBUILDING_STATE);
            this.getIndex(containerPath, indexLocation, true, true);
        }
    }

    public SourceIndexerRequestor getSourceRequestor(IScriptProject scriptProject) {
        IDLTKLanguageToolkit toolkit = null;
        toolkit = DLTKLanguageManager.getLanguageToolkit(scriptProject);
        if (toolkit != null) {
            return DLTKLanguageManager.createSourceRequestor(toolkit.getNatureId());
        }
        return null;
    }

    public ISourceElementParser getSourceElementParser(IScriptProject project) {
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(project);
        if (toolkit != null) {
            return DLTKLanguageManager.getSourceElementParser(toolkit.getNatureId());
        }
        return null;
    }

    public synchronized Index getIndex(IPath containerPath, boolean reuseExistingFile, boolean createIfMissing) {
        String indexLocation = this.computeIndexLocation(containerPath);
        return this.getIndex(containerPath, indexLocation, reuseExistingFile, createIfMissing);
    }

    public synchronized Index getSpecialIndex(String prefix, String path, String containerPath) {
        boolean mixin = prefix.equals(SPECIAL_MIXIN);
        String indexLocation = this.getSpecialIndexLocation(prefix, path);
        Index index = (Index)this.indexes.get(indexLocation);
        if (index == null) {
            File indexFile = new File(indexLocation);
            if (indexFile.exists()) {
                try {
                    index = mixin ? new MixinIndex(indexLocation, containerPath, true) : new Index(indexLocation, containerPath, true);
                    this.indexes.put(indexLocation, index);
                    return index;
                }
                catch (IOException iOException) {}
            }
            try {
                index = mixin ? new MixinIndex(indexLocation, containerPath, false) : new Index(indexLocation, containerPath, false);
                this.indexes.put(indexLocation, index);
                return index;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return index;
    }

    public String getSpecialIndexLocation(String prefix, String path) {
        return this.computeIndexLocation((IPath)new Path(String.valueOf(prefix) + path));
    }

    public synchronized Index getIndex(IPath containerPath, String indexLocation, boolean reuseExistingFile, boolean createIfMissing) {
        boolean mixin = containerPath.toString().startsWith(SPECIAL_MIXIN);
        Index index = (Index)this.indexes.get(indexLocation);
        if (index == null) {
            Integer currentIndexState;
            Object state = this.getIndexStates().get(indexLocation);
            Integer n = currentIndexState = state == null ? UNKNOWN_STATE : (Integer)state;
            if (currentIndexState.equals(UNKNOWN_STATE) && !createIfMissing) {
                this.rebuildIndex(indexLocation, containerPath);
                return null;
            }
            String containerPathString = containerPath.toString();
            if (reuseExistingFile) {
                block10: {
                    File indexFile = new File(indexLocation);
                    if (indexFile.exists()) {
                        try {
                            index = mixin ? new MixinIndex(indexLocation, containerPathString, true) : new Index(indexLocation, containerPathString, true);
                            this.indexes.put(indexLocation, index);
                            return index;
                        }
                        catch (IOException iOException) {
                            if (currentIndexState == REBUILDING_STATE || createIfMissing) break block10;
                            this.rebuildIndex(indexLocation, containerPath);
                            return null;
                        }
                    }
                }
                if (currentIndexState == SAVED_STATE && !createIfMissing) {
                    this.rebuildIndex(indexLocation, containerPath);
                    return null;
                }
            }
            if (createIfMissing) {
                try {
                    index = mixin ? new MixinIndex(indexLocation, containerPathString, false) : new Index(indexLocation, containerPathString, false);
                    this.indexes.put(indexLocation, index);
                    return index;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
        }
        return index;
    }

    public synchronized Index getIndex(String indexLocation) {
        return (Index)this.indexes.get(indexLocation);
    }

    public synchronized Index getIndexForUpdate(IPath containerPath, boolean reuseExistingFile, boolean createIfMissing) {
        String indexLocation = this.computeIndexLocation(containerPath);
        if (this.getIndexStates().get(indexLocation) == REBUILDING_STATE) {
            return this.getIndex(containerPath, indexLocation, reuseExistingFile, createIfMissing);
        }
        return null;
    }

    private SimpleLookupTable getIndexStates() {
        block5: {
            File indexesDirectory;
            block6: {
                char[][] names;
                if (this.indexStates != null) {
                    return this.indexStates;
                }
                this.indexStates = new SimpleLookupTable();
                char[] savedIndexNames = this.readIndexState();
                if (savedIndexNames.length <= 0 || (names = CharOperation.splitOn('\n', savedIndexNames)).length <= 0) break block5;
                indexesDirectory = this.getScriptPluginWorkingLocation().toFile();
                char[] dirName = indexesDirectory.getAbsolutePath().toCharArray();
                int delimiterPos = dirName.length;
                if (!CharOperation.match(names[0], 0, delimiterPos, dirName, 0, delimiterPos, true)) break block6;
                int i = 0;
                int l = names.length;
                while (i < l) {
                    char[] name = names[i];
                    if (name.length > 0) {
                        this.indexStates.put(new String(name), SAVED_STATE);
                    }
                    ++i;
                }
                break block5;
            }
            this.savedIndexNamesFile.delete();
            File[] files = indexesDirectory.listFiles();
            if (files == null) break block5;
            int i = 0;
            int l = files.length;
            while (i < l) {
                String fileName = files[i].getAbsolutePath();
                if (fileName.toLowerCase().endsWith(".index")) {
                    files[i].delete();
                }
                ++i;
            }
        }
        return this.indexStates;
    }

    private IPath getScriptPluginWorkingLocation() {
        IPath stateLocation;
        if (this.scriptPluginLocation != null) {
            return this.scriptPluginLocation;
        }
        this.scriptPluginLocation = stateLocation = DLTKCore.getPlugin().getStateLocation();
        return this.scriptPluginLocation;
    }

    public void jobWasCancelled(IPath containerPath) {
        String indexLocation = this.computeIndexLocation(containerPath);
        Object o = this.indexes.get(indexLocation);
        if (o instanceof Index) {
            ((Index)o).monitor = null;
            this.indexes.remove(indexLocation);
        }
        this.updateIndexState(indexLocation, UNKNOWN_STATE);
    }

    protected synchronized void moveToNextJob() {
        this.needToSave = true;
        super.moveToNextJob();
    }

    protected void notifyIdle(long idlingTime) {
        if (idlingTime > 1000L && this.needToSave) {
            this.saveIndexes();
        }
    }

    public String processName() {
        return Messages.process_name;
    }

    private void rebuildIndex(String indexLocation, IPath containerPath) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace == null) {
            return;
        }
        String cp = containerPath.toString();
        if (cp.startsWith(SPECIAL_MIXIN)) {
            cp = cp.substring(SPECIAL_MIXIN.length());
        }
        Path pathCP = new Path(cp);
        Object target = Model.getTarget((IContainer)workspace.getRoot(), (IPath)pathCP, true);
        if (target == null || target instanceof IFileHandle) {
            try {
                IScriptProject[] scriptProjects;
                IScriptProject[] iScriptProjectArray = scriptProjects = ModelManager.getModelManager().getModel().getScriptProjects();
                int n = scriptProjects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProjectFragment[] fragments;
                    IScriptProject project = iScriptProjectArray[n2];
                    IProjectFragment[] iProjectFragmentArray = fragments = project.getProjectFragments();
                    int n3 = fragments.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IProjectFragment fragment = iProjectFragmentArray[n4];
                        if (fragment.getPath().equals((Object)pathCP)) {
                            target = fragment;
                            break;
                        }
                        ++n4;
                    }
                    if (target == null) {
                        ++n2;
                        continue;
                    }
                    break;
                }
            }
            catch (ModelException e) {
                DLTKCore.error("Failed to obtain list of DLTK projects", (Throwable)((Object)e));
            }
        }
        if (target == null) {
            return;
        }
        this.updateIndexState(indexLocation, REBUILDING_STATE);
        IJob request = null;
        if (target instanceof IProject) {
            IProject p = (IProject)target;
            if (ScriptProject.hasScriptNature(p)) {
                ProjectIndexerManager.indexProject(p);
            }
        } else {
            if (target instanceof IProjectFragment) {
                ProjectIndexerManager.indexProjectFragment(((IProjectFragment)target).getScriptProject(), (IPath)pathCP);
                return;
            }
            if (target instanceof IFile) {
                return;
            }
            if (target instanceof IFileHandle) {
                return;
            }
        }
        if (request != null) {
            this.request(request);
        }
    }

    public synchronized Index recreateIndex(IPath containerPath) {
        boolean mixin = containerPath.toString().startsWith(SPECIAL_MIXIN);
        String containerPathString = containerPath.toString();
        try {
            String indexLocation = this.computeIndexLocation(containerPath);
            Index index = (Index)this.indexes.get(indexLocation);
            ReadWriteMonitor monitor = index == null ? null : index.monitor;
            index = mixin ? new MixinIndex(indexLocation, containerPathString, false) : new Index(indexLocation, containerPathString, false);
            this.indexes.put(indexLocation, index);
            index.monitor = monitor;
            return index;
        }
        catch (IOException e) {
            return null;
        }
    }

    public void remove(String containerRelativePath, IPath indexedContainer) {
        this.request(new RemoveFromIndex(containerRelativePath, indexedContainer, this));
    }

    public synchronized void removeIndex(IPath containerPath) {
        Object o;
        String indexLocation = this.computeIndexLocation(containerPath);
        File indexFile = new File(indexLocation);
        if (indexFile.exists()) {
            indexFile.delete();
        }
        if ((o = this.indexes.remove(indexLocation)) instanceof Index) {
            Index index = (Index)o;
            index.monitor = null;
            if (index.isRebuildable()) {
                this.updateIndexState(indexLocation, null);
            }
        }
    }

    public synchronized void removeIndexPath(IPath path) {
        Set keySet = this.indexes.keySet();
        Iterator keys = keySet.iterator();
        String[] locations = null;
        int max = keySet.size();
        int ptr = 0;
        while (keys.hasNext()) {
            String indexLocation = (String)keys.next();
            Path indexPath = new Path(indexLocation);
            if (path.isPrefixOf((IPath)indexPath)) {
                Index index = (Index)this.indexes.get(indexLocation);
                if (index != null) {
                    index.monitor = null;
                }
                if (locations == null) {
                    locations = new String[max];
                }
                locations[ptr++] = indexLocation;
                File indexFile = new File(indexLocation);
                if (!indexFile.exists()) continue;
                indexFile.delete();
                continue;
            }
            if (locations != null) continue;
            --max;
        }
        if (locations != null) {
            int i = 0;
            while (i < ptr) {
                this.indexes.remove(locations[i]);
                ++i;
            }
            this.removeIndexesState(locations);
        }
    }

    public synchronized void removeIndexFamily(IPath path) {
        ArrayList<IPath> toRemove = null;
        Object[] containerPaths = this.indexLocations.keyTable;
        int i = 0;
        int length = containerPaths.length;
        while (i < length) {
            IPath containerPath = (IPath)containerPaths[i];
            if (containerPath != null && path.isPrefixOf(containerPath)) {
                if (toRemove == null) {
                    toRemove = new ArrayList<IPath>();
                }
                toRemove.add(containerPath);
            }
            ++i;
        }
        if (toRemove != null) {
            i = 0;
            length = toRemove.size();
            while (i < length) {
                this.removeIndex((IPath)toRemove.get(i));
                ++i;
            }
        }
    }

    public void removeSourceFolderFromIndex(ScriptProject scriptProject, IPath sourceFolder, char[][] inclusionPatterns, char[][] exclusionPatterns) {
        IProject project = scriptProject.getProject();
        this.request(new RemoveFolderFromIndex(sourceFolder, inclusionPatterns, exclusionPatterns, project, this));
    }

    public synchronized void reset() {
        super.reset();
        if (this.indexes != null) {
            this.indexes = new HashMap(5);
            this.indexStates = null;
        }
        this.indexLocations = new SimpleLookupTable();
        this.scriptPluginLocation = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveIndex(Index index) throws IOException {
        Object containerPath;
        if (index.hasChanged()) {
            index.save();
        }
        if (!index.isRebuildable()) {
            return;
        }
        String indexLocation = index.getIndexFile().getPath();
        if (this.jobEnd > this.jobStart && (containerPath = this.indexLocations.keyForValue(indexLocation)) != null) {
            IndexManager indexManager = this;
            synchronized (indexManager) {
                int i = this.jobEnd;
                while (i > this.jobStart) {
                    IJob job = this.awaitingJobs[i];
                    if (job instanceof IndexRequest && ((IndexRequest)job).containerPath.equals(containerPath)) {
                        return;
                    }
                    --i;
                }
            }
        }
        this.updateIndexState(indexLocation, SAVED_STATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveIndexes() {
        ArrayList toSave = new ArrayList();
        IndexManager indexManager = this;
        synchronized (indexManager) {
            for (Object o : this.indexes.values()) {
                if (!(o instanceof Index)) continue;
                toSave.add(o);
            }
        }
        boolean allSaved = true;
        int i = 0;
        int length = toSave.size();
        while (i < length) {
            block14: {
                Index index = (Index)toSave.get(i);
                ReadWriteMonitor monitor = index.monitor;
                if (monitor != null) {
                    try {
                        monitor.enterRead();
                        if (!index.hasChanged()) break block14;
                        if (monitor.exitReadEnterWrite()) {
                            try {
                                try {
                                    this.saveIndex(index);
                                }
                                catch (IOException e) {
                                    allSaved = false;
                                    monitor.exitWriteEnterRead();
                                    break block14;
                                }
                            }
                            catch (Throwable throwable) {
                                monitor.exitWriteEnterRead();
                                throw throwable;
                            }
                            monitor.exitWriteEnterRead();
                            break block14;
                        }
                        allSaved = false;
                    }
                    finally {
                        monitor.exitRead();
                    }
                }
            }
            ++i;
        }
        this.needToSave = !allSaved;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(10);
        buffer.append(super.toString());
        buffer.append("In-memory indexes:\n");
        int count = 0;
        Iterator iter = this.indexes.values().iterator();
        while (iter.hasNext()) {
            buffer.append(++count).append(" - ").append(iter.next().toString()).append('\n');
        }
        return buffer.toString();
    }

    private char[] readIndexState() {
        try {
            return Util.getFileCharContent(this.savedIndexNamesFile, null);
        }
        catch (IOException iOException) {
            return new char[0];
        }
    }

    private synchronized void removeIndexesState(String[] locations) {
        this.getIndexStates();
        int length = locations.length;
        boolean changed = false;
        int i = 0;
        while (i < length) {
            if (locations[i] != null && this.indexStates.removeKey(locations[i]) != null) {
                changed = true;
            }
            ++i;
        }
        if (!changed) {
            return;
        }
        this.writeSavedIndexNamesFile();
    }

    private synchronized void updateIndexState(String indexLocation, Integer indexState) {
        this.getIndexStates();
        if (indexState != null) {
            if (indexState.equals(this.indexStates.get(indexLocation))) {
                return;
            }
            this.indexStates.put(indexLocation, indexState);
        } else {
            if (!this.indexStates.containsKey(indexLocation)) {
                return;
            }
            this.indexStates.removeKey(indexLocation);
        }
        this.writeSavedIndexNamesFile();
    }

    private void writeSavedIndexNamesFile() {
        block16: {
            BufferedWriter writer = null;
            try {
                try {
                    writer = new BufferedWriter(new FileWriter(this.savedIndexNamesFile));
                    Object[] keys = this.indexStates.keyTable;
                    Object[] states = this.indexStates.valueTable;
                    int i = 0;
                    int l = states.length;
                    while (i < l) {
                        if (states[i] == SAVED_STATE) {
                            writer.write((String)keys[i]);
                            writer.write(10);
                        }
                        ++i;
                    }
                }
                catch (IOException iOException) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public synchronized void rebuild() {
        File[] indexesFiles;
        this.disable();
        File indexesDirectory = this.getScriptPluginWorkingLocation().toFile();
        if (indexesDirectory.isDirectory() && (indexesFiles = indexesDirectory.listFiles()) != null) {
            int i = 0;
            int indexesFilesLength = indexesFiles.length;
            while (i < indexesFilesLength) {
                indexesFiles[i].delete();
                ++i;
            }
        }
        this.reset();
        this.enable();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = root.getProjects();
        int i = 0;
        while (i < projects.length) {
            if (DLTKLanguageManager.hasScriptNature(projects[i])) {
                ProjectIndexerManager.indexProject(projects[i]);
            }
            ++i;
        }
    }
}

