/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.viewsupport;

import java.util.HashMap;
import java.util.List;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.ui.DLTKUIMessages;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.Separator;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.dltk.ui.dialogs.StatusInfo;
import org.eclipse.dltk.ui.viewsupport.ViewHistory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HistoryListAction<E>
extends Action {
    private ViewHistory<E> fHistory;

    public HistoryListAction(ViewHistory history) {
        super(null, 8);
        this.fHistory = history;
        this.fHistory.configureHistoryListAction((IAction)this);
    }

    public void run() {
        HistoryListDialog dialog = new HistoryListDialog();
        if (dialog.open() == 0) {
            this.fHistory.setHistoryEntries(dialog.getRemaining(), dialog.getResult());
            this.fHistory.setMaxEntries(dialog.getMaxEntries());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HistoryListDialog
    extends StatusDialog {
        private static final int MAX_MAX_ENTRIES = 100;
        private ListDialogField fHistoryList;
        private StringDialogField fMaxEntriesField;
        private int fMaxEntries;
        private E fResult;

        private HistoryListDialog() {
            super(HistoryListAction.this.fHistory.getShell());
            this.setTitle(HistoryListAction.this.fHistory.getHistoryListDialogTitle());
            this.createHistoryList();
            this.createMaxEntriesField();
            this.setHelpAvailable(false);
        }

        private void createHistoryList() {
            IListAdapter adapter = new IListAdapter(){

                public void customButtonPressed(ListDialogField field, int index) {
                    HistoryListDialog.this.doCustomButtonPressed(index);
                }

                public void selectionChanged(ListDialogField field) {
                    HistoryListDialog.this.doSelectionChanged();
                }

                public void doubleClicked(ListDialogField field) {
                    HistoryListDialog.this.doDoubleClicked();
                }
            };
            String[] buttonLabels = new String[]{DLTKUIMessages.HistoryListAction_remove, DLTKUIMessages.HistoryListAction_remove_all};
            TestRunLabelProvider labelProvider = new TestRunLabelProvider();
            this.fHistoryList = new ListDialogField(adapter, buttonLabels, (ILabelProvider)labelProvider);
            this.fHistoryList.setLabelText(HistoryListAction.this.fHistory.getHistoryListDialogMessage());
            List historyEntries = HistoryListAction.this.fHistory.getHistoryEntries();
            this.fHistoryList.setElements(historyEntries);
            Object currentEntry = HistoryListAction.this.fHistory.getCurrentEntry();
            StructuredSelection sel = currentEntry != null ? new StructuredSelection(currentEntry) : new StructuredSelection();
            this.fHistoryList.selectElements((ISelection)sel);
        }

        private void createMaxEntriesField() {
            this.fMaxEntriesField = new StringDialogField();
            this.fMaxEntriesField.setLabelText(HistoryListAction.this.fHistory.getMaxEntriesMessage());
            this.fMaxEntriesField.setDialogFieldListener(new IDialogFieldListener(){

                public void dialogFieldChanged(DialogField field) {
                    boolean valid;
                    String maxString = HistoryListDialog.this.fMaxEntriesField.getText();
                    try {
                        HistoryListDialog.this.fMaxEntries = Integer.parseInt(maxString);
                        valid = HistoryListDialog.this.fMaxEntries > 0 && HistoryListDialog.this.fMaxEntries < 100;
                    }
                    catch (NumberFormatException numberFormatException) {
                        valid = false;
                    }
                    if (valid) {
                        HistoryListDialog.this.updateStatus(StatusInfo.OK_STATUS);
                    } else {
                        HistoryListDialog.this.updateStatus(new StatusInfo(4, Messages.format(DLTKUIMessages.HistoryListAction_max_entries_constraint, Integer.toString(100))));
                    }
                }
            });
            this.fMaxEntriesField.setText(Integer.toString(HistoryListAction.this.fHistory.getMaxEntries()));
        }

        protected Control createDialogArea(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite composite = (Composite)super.createDialogArea(parent);
            Composite inner = new Composite(composite, 0);
            inner.setLayoutData((Object)new GridData(1808));
            inner.setFont(composite.getFont());
            LayoutUtil.doDefaultLayout(inner, new DialogField[]{this.fHistoryList, new Separator()}, true);
            LayoutUtil.setHeightHint(this.fHistoryList.getListControl(null), this.convertHeightInCharsToPixels(12));
            LayoutUtil.setHorizontalGrabbing(this.fHistoryList.getListControl(null));
            Composite additionalControls = new Composite(inner, 0);
            additionalControls.setLayoutData((Object)new GridData(4, 4, true, false));
            LayoutUtil.doDefaultLayout(additionalControls, new DialogField[]{this.fMaxEntriesField}, false);
            LayoutUtil.setHorizontalGrabbing((Control)this.fMaxEntriesField.getTextControl(null));
            HistoryListDialog.applyDialogFont((Control)composite);
            return composite;
        }

        private void doCustomButtonPressed(int index) {
            switch (index) {
                case 0: {
                    this.fHistoryList.removeElements(this.fHistoryList.getSelectedElements());
                    this.fHistoryList.selectFirstElement();
                    break;
                }
                case 1: {
                    this.fHistoryList.removeAllElements();
                }
            }
        }

        private void doDoubleClicked() {
            this.okPressed();
        }

        private void doSelectionChanged() {
            List selected = this.fHistoryList.getSelectedElements();
            this.fResult = selected.size() >= 1 ? selected.get(0) : null;
            this.fHistoryList.enableButton(0, selected.size() != 0);
        }

        public E getResult() {
            return this.fResult;
        }

        public List<E> getRemaining() {
            return this.fHistoryList.getElements();
        }

        public int getMaxEntries() {
            return this.fMaxEntries;
        }

        public void create() {
            this.setShellStyle(this.getShellStyle() | 0x10);
            super.create();
        }
    }

    private final class TestRunLabelProvider
    extends LabelProvider {
        private final HashMap<ImageDescriptor, Image> fImages = new HashMap();

        private TestRunLabelProvider() {
        }

        public String getText(Object element) {
            return HistoryListAction.this.fHistory.getText(element);
        }

        public Image getImage(Object element) {
            ImageDescriptor imageDescriptor = HistoryListAction.this.fHistory.getImageDescriptor(element);
            return this.getCachedImage(imageDescriptor);
        }

        private Image getCachedImage(ImageDescriptor imageDescriptor) {
            Image cached = this.fImages.get(imageDescriptor);
            if (cached != null) {
                return cached;
            }
            Image image = imageDescriptor.createImage((Device)HistoryListAction.this.fHistory.getShell().getDisplay());
            this.fImages.put(imageDescriptor, image);
            return image;
        }

        public void dispose() {
            for (Image image : this.fImages.values()) {
                image.dispose();
            }
            this.fImages.clear();
        }
    }
}

