/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.core.codeassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.CallArgumentsList;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.ast.expressions.NumericLiteral;
import org.eclipse.dltk.ast.expressions.StringLiteral;
import org.eclipse.dltk.ast.parser.ISourceParser;
import org.eclipse.dltk.ast.references.ConstantReference;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.codeassist.ScriptCompletionEngine;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.Flags;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.mixin.IMixinElement;
import org.eclipse.dltk.core.mixin.MixinModel;
import org.eclipse.dltk.evaluation.types.AmbiguousType;
import org.eclipse.dltk.ruby.ast.RubyBlock;
import org.eclipse.dltk.ruby.ast.RubyColonExpression;
import org.eclipse.dltk.ruby.ast.RubyDAssgnExpression;
import org.eclipse.dltk.ruby.ast.RubyDVarExpression;
import org.eclipse.dltk.ruby.ast.RubySelfReference;
import org.eclipse.dltk.ruby.core.RubyPlugin;
import org.eclipse.dltk.ruby.core.model.FakeField;
import org.eclipse.dltk.ruby.core.utils.RubySyntaxUtils;
import org.eclipse.dltk.ruby.internal.core.codeassist.ProjectTypeComparator;
import org.eclipse.dltk.ruby.internal.core.codeassist.RubyKeyword;
import org.eclipse.dltk.ruby.internal.parser.mixin.IMixinSearchRequestor;
import org.eclipse.dltk.ruby.internal.parser.mixin.IRubyMixinElement;
import org.eclipse.dltk.ruby.internal.parser.mixin.PrefixNoCaseMixinSearchPattern;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinClass;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinElementInfo;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinMethod;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinModel;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinUtils;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinVariable;
import org.eclipse.dltk.ruby.internal.parsers.jruby.ASTUtils;
import org.eclipse.dltk.ruby.typeinference.RubyClassType;
import org.eclipse.dltk.ruby.typeinference.RubyModelUtils;
import org.eclipse.dltk.ruby.typeinference.RubyTypeInferencingUtils;
import org.eclipse.dltk.ti.BasicContext;
import org.eclipse.dltk.ti.DLTKTypeInferenceEngine;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.goals.AbstractTypeGoal;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.jruby.util.collections.WeakHashSet;

public class RubyCompletionEngine
extends ScriptCompletionEngine {
    private static final int TI_TIMEOUT = 2000;
    private static final int RELEVANCE_FREE_SPACE = 100000;
    private static final int RELEVANCE_KEYWORD = 1000000;
    private static final int RELEVANCE_TYPE = 2000000;
    private static final int RELEVANCE_METHODS = 10000000;
    private static final int RELEVANCE_VARIABLES = 100000000;
    private static final String[] globalVars = new String[]{"$DEBUG", "$$", "$-i", "$deferr", "$/", "$'", "$stdout", "$-l", "$-I", "$.", "$KCODE", "$binding", "$-w", "$FILENAME", "$defout", "$,", "$`", "$-F", "$*", "$LOADED_FEATURES", "$stdin", "$-p", "$:", "$\\", "$=", "$!", "$-v", "$>", "$&", "$;", "$SAFE", "$PROGRAM_NAME", "$\"", "$-d", "$?", "$-0", "$+", "$@", "$-a", "$VERBOSE", "$stderr", "$~", "$0", "$LOAD_PATH", "$<", "$_", "$-K"};
    private DLTKTypeInferenceEngine inferencer;
    private ISourceParser parser = null;
    private RubyMixinModel mixinModel;
    private HashSet completedNames = new HashSet();
    private WeakHashSet intresting = new WeakHashSet();
    private ASTNode completionNode;
    private ISourceModule currentModule;

    public RubyCompletionEngine() {
        this.inferencer = new DLTKTypeInferenceEngine();
        this.parser = DLTKLanguageManager.getSourceParser((String)"org.eclipse.dltk.ruby.core.nature");
    }

    protected int getEndOfEmptyToken() {
        return 0;
    }

    protected String processMethodName(IMethod method, String token) {
        return null;
    }

    protected String processTypeName(IType method, String token) {
        return null;
    }

    private boolean afterColons(String content, int position) {
        if (position < 2) {
            return false;
        }
        return content.charAt(position - 1) == ':' && content.charAt(position - 2) == ':';
    }

    private boolean afterDollar(String content, int position) {
        if (position < 1) {
            return false;
        }
        return content.charAt(position - 1) == '$';
    }

    private boolean afterAt(String content, int position) {
        if (position < 1) {
            return false;
        }
        return content.charAt(position - 1) == '@';
    }

    private boolean afterAt2(String content, int position) {
        if (position < 2) {
            return false;
        }
        return content.charAt(position - 1) == '@' && content.charAt(position - 2) == '@';
    }

    private boolean afterDot(String content, int position) {
        return position >= 1 && content.charAt(position - 1) == '.';
    }

    private String getWordStarting(String content, int position, int maxLen) {
        if (position <= 0 || position > content.length()) {
            return "";
        }
        int original = position;
        while (position > 0 && maxLen > 0 && (content.charAt(position - 1) == ':' || content.charAt(position - 1) == '\'' || content.charAt(position - 1) == '\"' || RubySyntaxUtils.isLessStrictIdentifierCharacter(content.charAt(position - 1)))) {
            --position;
            --maxLen;
        }
        return content.substring(position, original);
    }

    public void complete(IModuleSource module, int position, int i) {
        this.currentModule = (ISourceModule)module;
        this.mixinModel = RubyMixinModel.getInstance(this.currentModule.getScriptProject());
        this.completedNames.clear();
        this.actualCompletionPosition = position;
        this.requestor.beginReporting();
        try {
            String content = module.getSourceContents();
            String wordStarting = this.getWordStarting(content, position, 10);
            if (wordStarting.length() != 0) {
                this.setSourceRange(position - wordStarting.length(), position);
                String[] keywords = RubyKeyword.findByPrefix(wordStarting);
                int j = 0;
                while (j < keywords.length) {
                    this.reportKeyword(keywords[j]);
                    ++j;
                }
            }
            ModuleDeclaration moduleDeclaration = (ModuleDeclaration)this.parser.parse(module, null);
            if (this.afterDollar(content, position)) {
                this.completeGlobalVar(moduleDeclaration, "$", position);
            } else if (this.afterAt2(content, position)) {
                this.completeSimpleRef(moduleDeclaration, "@@", position);
            } else if (this.afterAt(content, position)) {
                this.completeSimpleRef(moduleDeclaration, "@", position);
            } else if (this.afterColons(content, position)) {
                ASTNode node = ASTUtils.findMaximalNodeEndingAt(moduleDeclaration, position - 2);
                this.setSourceRange(position, position);
                if (node != null) {
                    BasicContext basicContext = new BasicContext(this.currentModule, moduleDeclaration);
                    ExpressionTypeGoal goal = new ExpressionTypeGoal((IContext)basicContext, node);
                    IEvaluatedType type = this.inferencer.evaluateType((AbstractTypeGoal)goal, 3000);
                    this.reportSubElements(type, "");
                } else {
                    this.completeConstant(moduleDeclaration, "", position, true);
                }
            } else {
                ASTNode minimalNode = ASTUtils.findMinimalNode(moduleDeclaration, position, position);
                if (minimalNode != null) {
                    RubyClassType self;
                    if (minimalNode instanceof CallExpression) {
                        CallExpression callExp = (CallExpression)minimalNode;
                        if (position > 0 && content.charAt(position - 1) == ' ') {
                            minimalNode = callExp.getArgs();
                        }
                    }
                    this.completionNode = minimalNode;
                    if (minimalNode instanceof CallExpression) {
                        this.completeCall(moduleDeclaration, (CallExpression)minimalNode, position);
                    } else if (minimalNode instanceof CallArgumentsList) {
                        ExpressionTypeGoal goal;
                        IEvaluatedType self2;
                        this.completeSimpleRef(moduleDeclaration, wordStarting, position);
                        self = RubyTypeInferencingUtils.determineSelfClass(this.mixinModel, this.currentModule, moduleDeclaration, position);
                        if (self != null && "Object".equals(self.getTypeName()) && (self2 = this.inferencer.evaluateType((AbstractTypeGoal)(goal = new ExpressionTypeGoal((IContext)new BasicContext(this.currentModule, moduleDeclaration), minimalNode)), 2000)) != null) {
                            self = self2;
                        }
                        this.completeClassMethods(moduleDeclaration, (IEvaluatedType)self, "", true);
                    } else if (minimalNode instanceof ConstantReference) {
                        this.completeConstant(moduleDeclaration, (ConstantReference)minimalNode, position);
                    } else if (minimalNode instanceof RubyColonExpression) {
                        this.completeColonExpression(moduleDeclaration, (RubyColonExpression)minimalNode, position);
                    } else if (minimalNode instanceof SimpleReference) {
                        this.completeSimpleRef(moduleDeclaration, wordStarting, position);
                    } else if (minimalNode instanceof RubyDVarExpression) {
                        if (this.afterDot(content, position)) {
                            this.completeClassMethods(moduleDeclaration, minimalNode, wordStarting);
                        } else {
                            this.completeSimpleRef(moduleDeclaration, wordStarting, position);
                        }
                    } else if (minimalNode instanceof MethodDeclaration || minimalNode instanceof TypeDeclaration || minimalNode instanceof StringLiteral) {
                        ExpressionTypeGoal goal;
                        IEvaluatedType self2;
                        this.completeSimpleRef(moduleDeclaration, wordStarting, position);
                        self = RubyTypeInferencingUtils.determineSelfClass(this.mixinModel, this.currentModule, moduleDeclaration, position);
                        if (self != null && "Object".equals(self.getTypeName()) && (self2 = this.inferencer.evaluateType((AbstractTypeGoal)(goal = new ExpressionTypeGoal((IContext)new BasicContext(this.currentModule, moduleDeclaration), minimalNode)), 2000)) != null) {
                            self = self2;
                        }
                        this.completeClassMethods(moduleDeclaration, (IEvaluatedType)self, wordStarting, true);
                    } else if (minimalNode instanceof ModuleDeclaration) {
                        ExpressionTypeGoal goal = new ExpressionTypeGoal((IContext)new BasicContext(this.currentModule, moduleDeclaration), minimalNode);
                        IEvaluatedType self2 = this.inferencer.evaluateType((AbstractTypeGoal)goal, 2000);
                        this.completeClassMethods(moduleDeclaration, self2, wordStarting, true);
                    } else if (minimalNode instanceof NumericLiteral && position > 0 && position == minimalNode.sourceEnd() && position > minimalNode.sourceStart() && content.charAt(position - 1) == '.') {
                        this.setSourceRange(position, position);
                        this.completeClassMethods(moduleDeclaration, minimalNode, "");
                    } else {
                        this.completeSimpleRef(moduleDeclaration, wordStarting, position);
                        if (wordStarting.length() == 0 && !this.requestor.isContextInformationMode() && !this.afterContentAndSpace(moduleDeclaration, content, position)) {
                            this.reportCurrentElements(moduleDeclaration, position);
                        }
                    }
                }
            }
        }
        finally {
            this.requestor.endReporting();
        }
    }

    private boolean afterContentAndSpace(ModuleDeclaration moduleDeclaration, String content, int position) {
        while (position > 0) {
            char c = content.charAt(position - 1);
            if (c != ' ' && c != '\t') break;
            --position;
        }
        if (position > 0 && RubySyntaxUtils.isIdentifierCharacter(content.charAt(position - 1))) {
            ASTNode node = ASTUtils.findMinimalNode(moduleDeclaration, position, position);
            if (node instanceof CallExpression) {
                int begin = position;
                while (begin > 0 && content.charAt(begin - 1) != '\r' && content.charAt(begin - 1) != '\n') {
                    --begin;
                }
                ASTNode[] way = ASTUtils.restoreWayToNode(moduleDeclaration, node);
                int i = way.length - 1;
                while (--i >= 0) {
                    if (!(way[i] instanceof CallExpression)) continue;
                    return way[i].sourceStart() >= begin;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private void reportCurrentElements(ModuleDeclaration moduleDeclaration, int position) {
        this.setSourceRange(position, position);
        this.completeSimpleRef(moduleDeclaration, "", position);
        RubyClassType self = RubyTypeInferencingUtils.determineSelfClass(this.mixinModel, this.currentModule, moduleDeclaration, position);
        if (self == null) {
            return;
        }
        this.completeClassMethods(moduleDeclaration, (IEvaluatedType)self, "", true);
        if ("Object".equals(self.getTypeName())) {
            try {
                IModelElement[] children = this.currentModule.getChildren();
                if (children != null) {
                    int i = 0;
                    while (i < children.length) {
                        IModelElement element = children[i];
                        if (element instanceof IField) {
                            this.reportField((IField)element, 100000);
                        } else if (element instanceof IMethod) {
                            IMethod method = (IMethod)element;
                            if ((method.getFlags() & 0x80) == 0) {
                                this.reportMethod(method, 100000);
                            }
                        } else if (element instanceof IType && !element.getElementName().trim().startsWith("<<")) {
                            this.reportType((IType)element, 100000);
                        }
                        ++i;
                    }
                }
            }
            catch (ModelException e) {
                RubyPlugin.log((Exception)((Object)e));
            }
        }
    }

    private void completeClassMethods(ModuleDeclaration moduleDeclaration, RubyMixinClass rubyClass, String prefix, boolean isSelf) {
        CompletionMixinMethodRequestor mixinSearchRequestor = new CompletionMixinMethodRequestor(rubyClass, isSelf);
        rubyClass.findMethods(new PrefixNoCaseMixinSearchPattern(prefix), mixinSearchRequestor);
        mixinSearchRequestor.flush();
    }

    private void completeClassMethods(ModuleDeclaration moduleDeclaration, IEvaluatedType type, String prefix, boolean isSelf) {
        if (type instanceof RubyClassType) {
            RubyClassType rubyClassType = (RubyClassType)type;
            RubyMixinClass rubyClass = this.mixinModel.createRubyClass(rubyClassType);
            if (rubyClass != null) {
                this.completeClassMethods(moduleDeclaration, rubyClass, prefix, isSelf);
            }
        } else if (type instanceof AmbiguousType) {
            AmbiguousType type2 = (AmbiguousType)type;
            IEvaluatedType[] possibleTypes = type2.getPossibleTypes();
            int i = 0;
            while (i < possibleTypes.length) {
                this.completeClassMethods(moduleDeclaration, possibleTypes[i], prefix, isSelf);
                ++i;
            }
        }
    }

    private void completeClassMethods(ModuleDeclaration moduleDeclaration, ASTNode receiver, String pattern) {
        ExpressionTypeGoal goal = new ExpressionTypeGoal((IContext)new BasicContext(this.currentModule, moduleDeclaration), receiver);
        IEvaluatedType type = this.inferencer.evaluateType((AbstractTypeGoal)goal, 2000);
        this.completeClassMethods(moduleDeclaration, type, pattern, receiver instanceof RubySelfReference);
    }

    private void completeGlobalVar(ModuleDeclaration moduleDeclaration, String prefix, int position) {
        this.setSourceRange(position - (prefix != null ? prefix.length() : 0), position);
        IMixinElement[] elements = this.mixinModel.getRawModel().find(String.valueOf(prefix != null ? prefix : "") + "*");
        int i = 0;
        while (i < elements.length) {
            IRubyMixinElement rubyElement = this.mixinModel.createRubyElement(elements[i]);
            if (rubyElement instanceof RubyMixinVariable) {
                RubyMixinVariable variable = (RubyMixinVariable)rubyElement;
                IField[] sourceFields = variable.getSourceFields();
                int j = 0;
                while (j < sourceFields.length) {
                    if (sourceFields[j] != null) {
                        this.reportField(sourceFields[j], 100000000);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < globalVars.length) {
            if (prefix == null || globalVars[i].startsWith(prefix)) {
                this.reportField((IField)new FakeField(this.currentModule, globalVars[i], 0, 0), 100000000);
            }
            ++i;
        }
    }

    private void completeSimpleRef(ModuleDeclaration moduleDeclaration, String prefix, int position) {
        this.setSourceRange(position - prefix.length(), position);
        ASTNode[] wayToNode = ASTUtils.restoreWayToNode(moduleDeclaration, this.completionNode);
        int i = wayToNode.length - 1;
        while (i > 0) {
            if (wayToNode[i] instanceof RubyBlock) {
                RubyBlock rubyBlock = (RubyBlock)wayToNode[i];
                Set vars = rubyBlock.getVars();
                for (ASTNode n : vars) {
                    RubyDAssgnExpression rd;
                    if (!(n instanceof RubyDAssgnExpression) || !(rd = (RubyDAssgnExpression)n).getName().startsWith(prefix)) continue;
                    this.reportField((IField)new FakeField(this.currentModule, rd.getName(), 0, 0), 100000000);
                }
            }
            --i;
        }
        if (prefix.startsWith("$")) {
            this.completeGlobalVar(moduleDeclaration, prefix, position);
        } else {
            IField[] fields = RubyModelUtils.findFields(this.mixinModel, this.currentModule, moduleDeclaration, prefix, position);
            int i2 = 0;
            while (i2 < fields.length) {
                this.reportField(fields[i2], 100000000);
                ++i2;
            }
        }
    }

    private void reportSubElements(IEvaluatedType type, String prefix) {
        if (!(type instanceof RubyClassType)) {
            return;
        }
        RubyClassType rubyClassType = (RubyClassType)type;
        IMixinElement mixinElement = this.mixinModel.getRawModel().get(rubyClassType.getModelKey());
        if (mixinElement == null) {
            return;
        }
        ArrayList<IType> types = new ArrayList<IType>();
        ArrayList<IMethod> methods = new ArrayList<IMethod>();
        ArrayList<IField> fields = new ArrayList<IField>();
        IMixinElement[] children = mixinElement.getChildren();
        int i = 0;
        while (i < children.length) {
            Object[] objectArray = children[i].getAllObjects();
            int j = 0;
            while (j < objectArray.length) {
                RubyMixinElementInfo obj = (RubyMixinElementInfo)objectArray[j];
                if (obj.getObject() != null) {
                    IField fff;
                    IMethod method2;
                    if (obj.getKind() == 0 || obj.getKind() == 1) {
                        IType type2 = (IType)obj.getObject();
                        if (type2 != null && (prefix == null || type2.getElementName().startsWith(prefix))) {
                            types.add(type2);
                        }
                    } else if (obj.getKind() == 2 && (method2 = (IMethod)obj.getObject()) != null && (prefix == null || method2.getElementName().startsWith(prefix))) {
                        methods.add(method2);
                    }
                    if (obj.getKind() != 3 || (fff = (IField)obj.getObject()) == null || prefix != null && !fff.getElementName().startsWith(prefix)) break;
                    fields.add(fff);
                    break;
                }
                ++j;
            }
            ++i;
        }
        for (IField iField : fields) {
            this.reportField(iField, 100000000);
        }
        for (IType iType : types) {
            this.reportType(iType, 2000000);
        }
        for (IMethod iMethod : methods) {
            this.reportMethod(iMethod, 10000000);
        }
    }

    private void completeColonExpression(ModuleDeclaration moduleDeclaration, RubyColonExpression node, int position) {
        String content;
        try {
            content = this.currentModule.getSource();
        }
        catch (ModelException modelException) {
            return;
        }
        int pos = node.getLeft() != null ? node.getLeft().sourceEnd() + 2 : node.sourceStart();
        String starting = null;
        try {
            starting = content.substring(pos, position).trim();
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
            return;
        }
        if (starting.startsWith("::")) {
            this.setSourceRange(position - starting.length() + 2, position);
            this.completeConstant(moduleDeclaration, starting.substring(2), position, true);
            return;
        }
        this.setSourceRange(position - starting.length(), position);
        ExpressionTypeGoal goal = new ExpressionTypeGoal((IContext)new BasicContext(this.currentModule, moduleDeclaration), node.getLeft());
        IEvaluatedType type = this.inferencer.evaluateType((AbstractTypeGoal)goal, 3000);
        this.reportSubElements(type, starting);
    }

    private void completeConstant(ModuleDeclaration moduleDeclaration, String prefix, int position, boolean topLevelOnly) {
        IType[] types = RubyTypeInferencingUtils.getAllTypes(this.currentModule, prefix);
        Arrays.sort(types, new ProjectTypeComparator(this.currentModule));
        HashSet<String> names = new HashSet<String>();
        int i = 0;
        while (i < types.length) {
            String elementName = types[i].getElementName();
            if (names.add(elementName)) {
                this.reportType(types[i], 2000000);
            }
            ++i;
        }
        if (!topLevelOnly) {
            IMixinElement[] modelStaticScopes = RubyTypeInferencingUtils.getModelStaticScopes(this.mixinModel.getRawModel(), moduleDeclaration, position);
            int i2 = modelStaticScopes.length - 1;
            while (i2 >= 0) {
                IMixinElement scope = modelStaticScopes[i2];
                if (scope != null) {
                    this.reportSubElements((IEvaluatedType)new RubyClassType(scope.getKey()), prefix);
                }
                --i2;
            }
        }
        if (prefix != null && prefix.length() > 0) {
            String varkey = "Object" + MixinModel.SEPARATOR + prefix;
            String[] keys2 = this.mixinModel.getRawModel().findKeys(String.valueOf(varkey) + "*");
            int i3 = 0;
            while (i3 < keys2.length) {
                IRubyMixinElement element = this.mixinModel.createRubyElement(keys2[i3]);
                if (element instanceof RubyMixinVariable) {
                    RubyMixinVariable variable = (RubyMixinVariable)element;
                    IField[] sourceFields = variable.getSourceFields();
                    int j = 0;
                    while (j < sourceFields.length) {
                        if (sourceFields[j] != null) {
                            this.reportField(sourceFields[j], 100000000);
                            break;
                        }
                        ++j;
                    }
                }
                ++i3;
            }
        }
    }

    private void completeConstant(ModuleDeclaration moduleDeclaration, ConstantReference node, int position) {
        String content;
        try {
            content = this.currentModule.getSource();
        }
        catch (ModelException modelException) {
            return;
        }
        String prefix = content.substring(node.sourceStart(), position);
        this.setSourceRange(position - prefix.length(), position);
        this.completeConstant(moduleDeclaration, prefix, position, false);
    }

    private void completeCall(ModuleDeclaration moduleDeclaration, CallExpression node, int position) {
        String content;
        ASTNode receiver = node.getReceiver();
        try {
            content = this.currentModule.getSource();
        }
        catch (ModelException modelException) {
            return;
        }
        int pos = receiver != null ? (receiver.sourceEnd() == node.sourceStart() ? receiver.sourceStart() : receiver.sourceEnd() + 1) : node.sourceStart();
        int t = 0;
        while (t < 2) {
            if (pos < position && !RubySyntaxUtils.isStrictIdentifierCharacter(content.charAt(pos))) {
                ++pos;
            }
            ++t;
        }
        String starting = content.substring(pos, position).trim();
        if (receiver == null || receiver.sourceEnd() == node.sourceStart()) {
            this.completeSimpleRef(moduleDeclaration, starting, position);
            this.completeConstant(moduleDeclaration, starting, position, false);
        }
        this.setSourceRange(position - starting.length(), position);
        if (starting.startsWith("__")) {
            String[] keywords = RubyKeyword.findByPrefix("__");
            int j = 0;
            while (j < keywords.length) {
                this.reportKeyword(keywords[j]);
                ++j;
            }
        }
        if (receiver != null && receiver.sourceEnd() != node.sourceStart()) {
            this.completeClassMethods(moduleDeclaration, receiver, starting);
        } else {
            RubyClassType self = RubyTypeInferencingUtils.determineSelfClass(this.mixinModel, this.currentModule, moduleDeclaration, position);
            if (self != null && "Object".equals(self.getTypeName())) {
                CallExpression minNode = node;
                ASTNode[] wayToNode = ASTUtils.restoreWayToNode(moduleDeclaration, (ASTNode)node);
                int cnt = wayToNode.length - 2;
                while (cnt >= 0) {
                    if (wayToNode[cnt] instanceof TypeDeclaration || wayToNode[cnt] instanceof ModuleDeclaration) {
                        minNode = wayToNode[cnt];
                        break;
                    }
                    --cnt;
                }
                ExpressionTypeGoal goal = new ExpressionTypeGoal((IContext)new BasicContext(this.currentModule, moduleDeclaration), (ASTNode)minNode);
                IEvaluatedType self2 = this.inferencer.evaluateType((AbstractTypeGoal)goal, 2000);
                if (self2 != null) {
                    self = self2;
                }
            }
            this.completeClassMethods(moduleDeclaration, (IEvaluatedType)self, starting, true);
        }
    }

    private void reportMethod(IMethod method, int rel) {
        String name;
        this.intresting.add(method);
        String elementName = method.getElementName();
        if (this.completedNames.contains(elementName)) {
            return;
        }
        this.completedNames.add(elementName);
        if (elementName.indexOf(46) != -1) {
            elementName = elementName.substring(elementName.indexOf(46) + 1);
        }
        String compl = name = elementName;
        this.noProposal = false;
        if (!this.requestor.isIgnored(5)) {
            CompletionProposal proposal = this.createProposal(5, this.actualCompletionPosition);
            String[] params = null;
            try {
                params = method.getParameterNames();
            }
            catch (ModelException modelException) {}
            if (params != null && params.length > 0) {
                proposal.setParameterNames(params);
            }
            proposal.setModelElement((IModelElement)method);
            proposal.setName(name);
            proposal.setCompletion(compl);
            try {
                proposal.setFlags(method.getFlags());
            }
            catch (ModelException modelException) {}
            proposal.setReplaceRange(this.startPosition - this.offset, this.endPosition - this.offset);
            proposal.setRelevance(rel);
            this.requestor.accept(proposal);
            if (DEBUG) {
                this.printDebug(proposal);
            }
        }
    }

    private void reportType(IType type, int rel) {
        this.intresting.add(type);
        String elementName = type.getElementName();
        if (this.completedNames.contains(elementName)) {
            return;
        }
        this.completedNames.add(elementName);
        String name = elementName;
        if (name.length() == 0) {
            return;
        }
        this.noProposal = false;
        if (!this.requestor.isIgnored(7)) {
            CompletionProposal proposal = this.createProposal(7, this.actualCompletionPosition);
            proposal.setModelElement((IModelElement)type);
            proposal.setName(name);
            proposal.setCompletion(elementName);
            try {
                proposal.setFlags(type.getFlags());
            }
            catch (ModelException modelException) {}
            proposal.setReplaceRange(this.startPosition - this.offset, this.endPosition - this.offset);
            proposal.setRelevance(rel);
            this.requestor.accept(proposal);
            if (DEBUG) {
                this.printDebug(proposal);
            }
        }
    }

    private void reportField(IField field, int rel) {
        this.intresting.add(field);
        String elementName = field.getElementName();
        if (this.completedNames.contains(elementName)) {
            return;
        }
        this.completedNames.add(elementName);
        String name = elementName;
        if (name.length() == 0) {
            return;
        }
        this.noProposal = false;
        if (!this.requestor.isIgnored(1)) {
            CompletionProposal proposal = this.createProposal(1, this.actualCompletionPosition);
            proposal.setModelElement((IModelElement)field);
            proposal.setName(name);
            proposal.setCompletion(elementName);
            proposal.setReplaceRange(this.startPosition - this.offset, this.endPosition - this.offset);
            proposal.setRelevance(rel);
            this.requestor.accept(proposal);
            if (DEBUG) {
                this.printDebug(proposal);
            }
        }
    }

    private void reportKeyword(String name) {
        this.noProposal = false;
        if (!this.requestor.isIgnored(2)) {
            CompletionProposal proposal = this.createProposal(2, this.actualCompletionPosition);
            proposal.setName(name);
            proposal.setCompletion(name);
            proposal.setReplaceRange(this.startPosition - this.offset, this.endPosition - this.offset);
            proposal.setRelevance(1000000);
            this.requestor.accept(proposal);
            if (DEBUG) {
                this.printDebug(proposal);
            }
        }
    }

    private class CompletionMixinMethodRequestor
    implements IMixinSearchRequestor {
        private String lastParent = null;
        private boolean lastParentIsSuperClass = true;
        private final List group = new ArrayList();
        private final RubyMixinClass klass;
        private final boolean isSelf;

        public CompletionMixinMethodRequestor(RubyMixinClass klass, boolean isSelf) {
            this.klass = klass;
            this.isSelf = isSelf;
        }

        private boolean isSuperClass(String key) {
            if (!RubyMixinUtils.isObjectOrKernel(key)) {
                if (key.equals(this.klass.getKey())) {
                    return true;
                }
                RubyMixinClass superclass = this.klass.getSuperclass();
                while (superclass != null) {
                    String superClassKey = superclass.getKey();
                    if (RubyMixinUtils.isObjectOrKernel(superClassKey)) break;
                    if (key.equals(superClassKey)) {
                        return true;
                    }
                    superclass = superclass.getSuperclass();
                }
            }
            return false;
        }

        public void acceptResult(IRubyMixinElement element) {
            if (element instanceof RubyMixinMethod) {
                boolean shouldAdd;
                RubyMixinMethod method = (RubyMixinMethod)element;
                RubyMixinClass selfClass = method.getSelfType();
                if (this.lastParent == null || !this.lastParent.equals(selfClass.getKey())) {
                    if (this.lastParent != null) {
                        this.flush();
                    }
                    this.lastParent = selfClass.getKey();
                    this.lastParentIsSuperClass = this.isSuperClass(this.lastParent);
                }
                int flags = 0;
                IMethod[] methods = method.getSourceMethods();
                int cnt = 0;
                int max = methods.length;
                while (cnt < max) {
                    IMethod m = methods[cnt];
                    if (m != null) {
                        try {
                            flags |= m.getFlags();
                        }
                        catch (ModelException modelException) {}
                    }
                    ++cnt;
                }
                boolean bl = shouldAdd = Flags.isPublic((int)flags) || this.lastParentIsSuperClass && Flags.isProtected((int)flags) || Flags.isPrivate((int)flags) && this.isSelf || RubyMixinUtils.isKernel(selfClass.getKey());
                if (shouldAdd) {
                    this.group.add(method);
                }
            }
        }

        public void flush() {
            if (this.group.size() > 0) {
                RubyMixinMethod[] mixinMethods = this.group.toArray(new RubyMixinMethod[this.group.size()]);
                List methods = RubyModelUtils.getAllSourceMethods(mixinMethods, this.klass);
                int skew = 0;
                if (this.klass.getKey().equals(this.lastParent)) {
                    skew = 2;
                } else if (this.lastParentIsSuperClass) {
                    skew = 1;
                }
                int j = 0;
                int size = methods.size();
                while (j < size) {
                    RubyCompletionEngine.this.reportMethod((IMethod)methods.get(j), 10000000 + skew);
                    ++j;
                }
                this.group.clear();
            }
        }
    }
}

