/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.text;

import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.CorrectionEngine;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.tcl.core.TclPackagesManager;
import org.eclipse.dltk.tcl.core.packages.TclPackageInfo;
import org.eclipse.dltk.tcl.internal.core.packages.TclVariableResolver;
import org.eclipse.dltk.tcl.internal.ui.text.TclGlobalVariableSourceCorrectionMarkerResolution;
import org.eclipse.dltk.tcl.internal.ui.text.TclRequirePackageCorrectionMarkerResolution;
import org.eclipse.dltk.tcl.internal.ui.text.TclRequirePackageMarkerResolution;
import org.eclipse.dltk.tcl.internal.ui.text.TclSourceCorrectionMarkerResolution;
import org.eclipse.dltk.tcl.internal.ui.text.TclSourceMarkerResolution;
import org.eclipse.dltk.ui.editor.IScriptAnnotation;
import org.eclipse.dltk.ui.text.AnnotationResolutionProposal;
import org.eclipse.dltk.ui.text.IAnnotationResolution;
import org.eclipse.dltk.ui.text.IScriptCorrectionContext;
import org.eclipse.dltk.ui.text.IScriptCorrectionProcessor;
import org.eclipse.dltk.ui.text.MarkerResolutionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.ui.IMarkerResolution;

public class TclSourcePackageCorrectionProcessor
implements IScriptCorrectionProcessor {
    private static final String PACKAGES = String.valueOf(TclSourcePackageCorrectionProcessor.class.getName()) + "#PACKAGES";
    private static final String SOURCES = String.valueOf(TclSourcePackageCorrectionProcessor.class.getName()) + "#SOURCES";

    public boolean canFix(IScriptAnnotation annotation) {
        return TclSourcePackageCorrectionProcessor.isFixable(annotation);
    }

    public static boolean isFixable(IScriptAnnotation annotation) {
        if (annotation.getId() == 0x10000001) {
            IScriptProject project;
            ISourceModule module;
            String[] args = annotation.getArguments();
            if (args != null && args.length != 0 && args[0] != null && (module = annotation.getSourceModule()) != null && (project = module.getScriptProject()) != null && TclSourcePackageCorrectionProcessor.isFixable(args[0], project)) {
                return true;
            }
        } else {
            IScriptProject project;
            ISourceModule module;
            String[] args;
            if (annotation.getId() == 0x10000002) {
                return true;
            }
            if (annotation.getId() == 0x10000004) {
                return true;
            }
            if (annotation.getId() == 0x10000003 && (args = annotation.getArguments()) != null && args.length != 0 && args[0] != null && (module = annotation.getSourceModule()) != null && (project = module.getScriptProject()) != null && TclSourceMarkerResolution.fixAvailable(module, args[0])) {
                return true;
            }
        }
        return false;
    }

    public void computeQuickAssistProposals(IScriptAnnotation annotation, IScriptCorrectionContext context) {
        String fName;
        if (annotation.getId() == 0x10000001) {
            String pkgName;
            if (TclSourcePackageCorrectionProcessor.isFixable(annotation) && this.addPackageName(context, pkgName = annotation.getArguments()[0])) {
                context.addProposal((ICompletionProposal)new AnnotationResolutionProposal((IAnnotationResolution)new TclRequirePackageMarkerResolution(pkgName, context.getProject()), annotation));
            }
        } else if (annotation.getId() == 0x10000002) {
            String pkgName = annotation.getArguments()[0];
            if (this.addPackageName(context, pkgName)) {
                context.addProposal((ICompletionProposal)new AnnotationResolutionProposal((IAnnotationResolution)new TclRequirePackageCorrectionMarkerResolution(pkgName, context.getProject(), context.getModule()), annotation));
                this.addGlobalVariableProposals(annotation, context, pkgName);
            }
        } else if (annotation.getId() == 0x10000004) {
            String fName2 = annotation.getArguments()[0];
            if (this.addSourceFile(context, fName2)) {
                context.addProposal((ICompletionProposal)new AnnotationResolutionProposal((IAnnotationResolution)new TclSourceCorrectionMarkerResolution(fName2, context.getProject(), context.getModule()), annotation));
                this.addGlobalVariableProposals(annotation, context, fName2);
            }
        } else if (annotation.getId() == 0x10000003 && this.addSourceFile(context, fName = annotation.getArguments()[0]) && TclSourceMarkerResolution.fixAvailable(context.getModule(), fName)) {
            context.addProposal((ICompletionProposal)new AnnotationResolutionProposal((IAnnotationResolution)new TclSourceMarkerResolution(fName, context.getProject(), context.getModule()), annotation));
        }
    }

    private void addGlobalVariableProposals(IScriptAnnotation annotation, IScriptCorrectionContext context, String fName) {
        String[] names = TclVariableResolver.extractVariableNames((String)fName);
        Map eMap = TclPackagesManager.getVariables((String)context.getProject().getElementName());
        if (names != null) {
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String var = stringArray[n2];
                if (!eMap.containsKey(var)) {
                    context.addProposal((ICompletionProposal)new AnnotationResolutionProposal((IAnnotationResolution)new TclGlobalVariableSourceCorrectionMarkerResolution(var, context.getProject()), annotation));
                }
                ++n2;
            }
        }
    }

    private boolean addPackageName(IScriptCorrectionContext context, String pkgName) {
        return this.addAttributeValue(context, PACKAGES, pkgName);
    }

    private boolean addSourceFile(IScriptCorrectionContext context, String source) {
        return this.addAttributeValue(context, SOURCES, source);
    }

    private boolean addAttributeValue(IScriptCorrectionContext context, String attribute, String value) {
        HashSet<String> values = (HashSet<String>)context.getAttribute(attribute);
        if (values != null) {
            return values.add(value);
        }
        values = new HashSet<String>();
        values.add(value);
        context.setAttribute(attribute, values);
        return true;
    }

    public boolean canFix(IMarker marker) {
        return TclSourcePackageCorrectionProcessor.isFixable(marker);
    }

    public static boolean isFixable(IMarker marker) {
        int idValue = marker.getAttribute("id", 0);
        if (idValue == 0x10000001) {
            IResource resource;
            IProject project;
            IScriptProject scriptProject;
            String[] args = CorrectionEngine.getProblemArguments((IMarker)marker);
            if (args != null && args.length != 0 && args[0] != null && TclSourcePackageCorrectionProcessor.isFixable(args[0], scriptProject = DLTKCore.create((IProject)(project = (resource = marker.getResource()).getProject())))) {
                return true;
            }
        } else {
            IResource resource;
            String[] args;
            if (idValue == 0x10000002) {
                return true;
            }
            if (idValue == 0x10000004) {
                return true;
            }
            if (idValue == 0x10000003 && (args = CorrectionEngine.getProblemArguments((IMarker)marker)) != null && args.length != 0 && args[0] != null && TclSourceMarkerResolution.fixAvailable((ISourceModule)DLTKCore.create((IResource)(resource = marker.getResource())), args[0])) {
                return true;
            }
        }
        return false;
    }

    public void computeQuickAssistProposals(IMarker marker, IScriptCorrectionContext context) {
        if (marker.getAttribute("id", 0) == 0x10000001) {
            String pkgName;
            if (TclSourcePackageCorrectionProcessor.isFixable(marker) && this.addPackageName(context, pkgName = CorrectionEngine.getProblemArguments((IMarker)marker)[0])) {
                context.addProposal((ICompletionProposal)new MarkerResolutionProposal((IMarkerResolution)new TclRequirePackageMarkerResolution(pkgName, context.getProject()), marker));
            }
        } else if (marker.getAttribute("id", 0) == 0x10000002) {
            String pkgName = CorrectionEngine.getProblemArguments((IMarker)marker)[0];
            if (this.addPackageName(context, pkgName)) {
                context.addProposal((ICompletionProposal)new MarkerResolutionProposal((IMarkerResolution)new TclRequirePackageCorrectionMarkerResolution(pkgName, context.getProject(), context.getModule()), marker));
                this.addGlobalVariablesProposals(marker, context, pkgName);
            }
            this.addGlobalVariablesProposals(marker, context, pkgName);
        } else if (marker.getAttribute("id", 0) == 0x10000004) {
            String fName = CorrectionEngine.getProblemArguments((IMarker)marker)[0];
            context.addProposal((ICompletionProposal)new MarkerResolutionProposal((IMarkerResolution)new TclSourceCorrectionMarkerResolution(fName, context.getProject(), context.getModule()), marker));
        } else if (marker.getAttribute("id", 0) == 0x10000003) {
            String fName = CorrectionEngine.getProblemArguments((IMarker)marker)[0];
            if (TclSourceMarkerResolution.fixAvailable(context.getModule(), fName)) {
                context.addProposal((ICompletionProposal)new MarkerResolutionProposal((IMarkerResolution)new TclSourceMarkerResolution(fName, context.getProject(), context.getModule()), marker));
            }
        }
    }

    private void addGlobalVariablesProposals(IMarker marker, IScriptCorrectionContext context, String pkgName) {
        String[] names = TclVariableResolver.extractVariableNames((String)pkgName);
        Map eMap = TclPackagesManager.getVariables((String)context.getProject().getElementName());
        if (names != null) {
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String var = stringArray[n2];
                if (!eMap.containsKey(var)) {
                    context.addProposal((ICompletionProposal)new MarkerResolutionProposal((IMarkerResolution)new TclGlobalVariableSourceCorrectionMarkerResolution(var, context.getProject()), marker));
                }
                ++n2;
            }
        }
    }

    public static boolean isFixable(String pkgName, IScriptProject scriptProject) {
        IDLTKLanguageToolkit toolkit = null;
        toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)scriptProject);
        if (toolkit != null && toolkit.getNatureId().equals("org.eclipse.dltk.tcl.core.nature")) {
            IInterpreterInstall install;
            block4: {
                install = null;
                try {
                    install = ScriptRuntime.getInterpreterInstall((IScriptProject)scriptProject);
                }
                catch (CoreException e) {
                    if (!DLTKCore.DEBUG) break block4;
                    e.printStackTrace();
                }
            }
            if (install != null) {
                TclPackageInfo info = TclPackagesManager.getPackageInfo((IInterpreterInstall)install, (String)pkgName, (boolean)true);
                return info != null && info.isFetched();
            }
        }
        return false;
    }
}

