/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.activestatedebugger.spawnpoint;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.dltk.tcl.activestatedebugger.TclActiveStateDebuggerPlugin;
import org.eclipse.dltk.tcl.activestatedebugger.spawnpoint.SpawnpointCommands;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpawnpointCommandManager {
    private static final String EXTENSION_POINT = "org.eclipse.dltk.tcl.debug.spawnpointCommand";
    private static Map<String, Boolean> commands = null;
    private static final Pattern COMMAND_PATTERN = Pattern.compile("[\\w_]+(::[\\w_]+)*");
    private static final String COMMAND_SEPARATOR = ";";
    private static final char VALUE_SEPARATOR = '=';
    private static final String VALUE_FALSE = "0";

    private SpawnpointCommandManager() {
    }

    public static Set<String> getContributedCommands() {
        return SpawnpointCommandManager.getContributedCommandMap().keySet();
    }

    public static Map<String, Boolean> getContributedCommandMap() {
        if (commands == null) {
            IConfigurationElement[] elements;
            HashMap<String, Boolean> names = new HashMap<String, Boolean>();
            IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT);
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                String name = element.getAttribute("name");
                if (SpawnpointCommandManager.isValidCommandName(name)) {
                    names.put(name, SpawnpointCommandManager.toBoolean(element.getAttribute("enabled"), true));
                }
                ++n2;
            }
            commands = Collections.unmodifiableMap(names);
        }
        return commands;
    }

    private static boolean toBoolean(String value, boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public static boolean isValidCommandName(String name) {
        return name != null && name.length() != 0 && COMMAND_PATTERN.matcher(name).matches();
    }

    public static SpawnpointCommands loadFromPreferences() {
        return SpawnpointCommandManager.decode(SpawnpointCommandManager.getPluginPreferences().getString("tcl.debug.spawnpoints"));
    }

    public static SpawnpointCommands decode(String value) {
        ArrayList<String> commandNames = new ArrayList<String>();
        HashSet<String> selected = new HashSet<String>();
        if (value != null && value.length() != 0) {
            StringTokenizer st = new StringTokenizer(value, COMMAND_SEPARATOR);
            while (st.hasMoreTokens()) {
                boolean enabled;
                String commandName;
                String token = st.nextToken();
                int pos = token.indexOf(61);
                if (pos >= 0) {
                    commandName = token.substring(0, pos);
                    enabled = !VALUE_FALSE.equals(token.substring(pos + 1));
                } else {
                    commandName = token;
                    enabled = true;
                }
                if (!SpawnpointCommandManager.isValidCommandName(commandName)) continue;
                commandNames.add(commandName);
                if (!enabled) continue;
                selected.add(commandName);
            }
        }
        final Map<String, Boolean> contributed = SpawnpointCommandManager.getContributedCommandMap();
        for (Map.Entry<String, Boolean> commandName : contributed.entrySet()) {
            if (commandNames.contains(commandName.getKey())) continue;
            commandNames.add(commandName.getKey());
            if (!commandName.getValue().booleanValue()) continue;
            selected.add(commandName.getKey());
        }
        Collections.sort(commandNames, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                boolean contributed2;
                boolean contributed1 = contributed.containsKey(o1);
                if (contributed1 != (contributed2 = contributed.containsKey(o2))) {
                    return contributed1 ? -1 : 1;
                }
                return o1.compareToIgnoreCase(o2);
            }
        });
        return new SpawnpointCommands(commandNames, selected);
    }

    public static void saveToPreferences(SpawnpointCommands commandNames) {
        SpawnpointCommandManager.getPluginPreferences().setValue("tcl.debug.spawnpoints", SpawnpointCommandManager.encode(commandNames));
    }

    private static Preferences getPluginPreferences() {
        return TclActiveStateDebuggerPlugin.getDefault().getPluginPreferences();
    }

    public static String encode(SpawnpointCommands commandNames) {
        Map<String, Boolean> contributed = SpawnpointCommandManager.getContributedCommandMap();
        StringBuffer buffer = new StringBuffer();
        for (String commandName : commandNames.getCommands()) {
            Boolean contributedEnabled = contributed.get(commandName);
            if (contributedEnabled != null && commandNames.isSelected(commandName) == contributedEnabled.booleanValue()) continue;
            if (buffer.length() != 0) {
                buffer.append(COMMAND_SEPARATOR);
            }
            buffer.append(commandName);
            if (commandNames.isSelected(commandName)) continue;
            buffer.append('=');
            buffer.append(VALUE_FALSE);
        }
        return buffer.toString();
    }
}

