/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.tests.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModule;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;

public class ModelTestUtils {
    public static void assertParameterNames(IMethod method, String[] names) throws Exception {
        String[] params = method.getParameters();
        TestCase.assertNotNull((Object)params);
        int index = 0;
        int i = 0;
        while (i < params.length) {
            TestCase.assertNotNull((Object)params[i]);
            TestCase.assertEquals((String)params[i], (String)names[index]);
            ++index;
            ++i;
        }
    }

    public static void counterAssert(IModelElement[] children, int classCountNeed, int fieldCountNeed, int methodCountNeed) throws Exception {
        int classCount = 0;
        int fieldCount = 0;
        int methodCount = 0;
        IModelElement parent = ModelTestUtils.getElementsParent(children);
        if (parent == null) {
            TestCase.assertTrue((String)"Can't get children's parent", (boolean)false);
        }
        ArrayList classes = new ArrayList(1);
        ArrayList methods = new ArrayList(1);
        ArrayList fields = new ArrayList(1);
        ModelTestUtils.getElementChildren(parent, classes, methods, fields);
        classCount = classes.size();
        methodCount = methods.size();
        fieldCount = fields.size();
        TestCase.assertEquals((int)classCountNeed, (int)classCount);
        TestCase.assertEquals((int)fieldCountNeed, (int)fieldCount);
        TestCase.assertEquals((int)methodCountNeed, (int)methodCount);
    }

    public static IField getAssertField(IModelElement[] elements, String name) throws Exception {
        IModelElement parent = ModelTestUtils.getElementsParent(elements);
        if (parent == null) {
            TestCase.assertTrue((String)"Can't get children's parent", (boolean)false);
        }
        ArrayList classes = new ArrayList(1);
        ArrayList methods = new ArrayList(1);
        ArrayList fields = new ArrayList(1);
        ModelTestUtils.getElementChildren(parent, classes, methods, fields);
        Iterator i = fields.iterator();
        while (i.hasNext()) {
            IModelElement element = (IModelElement)i.next();
            IField field = (IField)element;
            TestCase.assertNotNull((Object)field);
            if (!field.getElementName().equals(name)) continue;
            return field;
        }
        TestCase.assertEquals((String)"Field not exist", (String)"", (String)name);
        return null;
    }

    public static IMethod getAssertMethod(IModelElement[] elements, String name, int argCount) throws Exception {
        IModelElement parent = ModelTestUtils.getElementsParent(elements);
        if (parent == null) {
            TestCase.assertTrue((String)"Can't get children's parent", (boolean)false);
        }
        ArrayList classes = new ArrayList(1);
        ArrayList methods = new ArrayList(1);
        ArrayList fields = new ArrayList(1);
        ModelTestUtils.getElementChildren(parent, classes, methods, fields);
        Iterator i = methods.iterator();
        while (i.hasNext()) {
            IModelElement element = (IModelElement)i.next();
            IMethod method = (IMethod)element;
            TestCase.assertNotNull((Object)method);
            if (!method.getElementName().equals(name)) continue;
            String[] params = method.getParameters();
            TestCase.assertNotNull((Object)params);
            TestCase.assertEquals((int)argCount, (int)params.length);
            return method;
        }
        TestCase.assertEquals((String)"Method not exist", (String)name, (String)"");
        return null;
    }

    public static IType getAssertClass(IModelElement[] elements, String name) throws Exception {
        IModelElement parent = ModelTestUtils.getElementsParent(elements);
        if (parent == null) {
            TestCase.assertTrue((String)"Can't get children's parent", (boolean)false);
        }
        ArrayList classes = new ArrayList(1);
        ArrayList methods = new ArrayList(1);
        ArrayList fields = new ArrayList(1);
        ModelTestUtils.getElementChildren(parent, classes, methods, fields);
        Iterator i = classes.iterator();
        while (i.hasNext()) {
            IModelElement element = (IModelElement)i.next();
            IType classElement = (IType)element;
            TestCase.assertNotNull((Object)classElement);
            if (!classElement.getElementName().equals(name)) continue;
            return classElement;
        }
        TestCase.assertEquals((String)"Class not exist", (String)"", (String)name);
        return null;
    }

    private static void getElementChildren(IModelElement element, Collection classes, Collection methods, Collection fields) throws ModelException {
        classes.clear();
        fields.clear();
        methods.clear();
        if (element.getElementType() == 5) {
            IModule parentModule = (IModule)element;
            IModelElement[] childs = parentModule.getChildren();
            int i = 0;
            while (i < childs.length) {
                IModelElement c = childs[i];
                if (c.getElementType() == 8) {
                    fields.add(c);
                } else if (c.getElementType() == 9) {
                    methods.add(c);
                } else if (c.getElementType() == 7) {
                    classes.add(c);
                }
                ++i;
            }
        } else if (element.getElementType() == 7) {
            IType parentClass = (IType)element;
            IModelElement[] childs = parentClass.getChildren();
            int i = 0;
            while (i < childs.length) {
                IModelElement c = childs[i];
                if (c.getElementType() == 8) {
                    fields.add(c);
                } else if (c.getElementType() == 9) {
                    methods.add(c);
                } else if (c.getElementType() == 7) {
                    classes.add(c);
                }
                ++i;
            }
        } else if (element.getElementType() == 9) {
            IMethod parentMethod = (IMethod)element;
            IModelElement[] childs = parentMethod.getChildren();
            int i = 0;
            while (i < childs.length) {
                IModelElement c = childs[i];
                if (c.getElementType() == 8) {
                    fields.add((IField)c);
                }
                if (c.getElementType() == 9) {
                    methods.add(c);
                } else if (c.getElementType() == 7) {
                    classes.add(c);
                }
                ++i;
            }
        } else {
            return;
        }
    }

    private static IModelElement getElementsParent(IModelElement[] elements) {
        if (elements.length == 0) {
            return null;
        }
        if (elements[0] != null) {
            return elements[0].getParent();
        }
        return null;
    }

    public static void exractZipInto(IScriptProject scriptProject, URL entry) throws IOException, CoreException {
        ZipEntry nextEntry;
        IProject prj = scriptProject.getProject();
        NullProgressMonitor monitor = new NullProgressMonitor();
        InputStream openStream = entry.openStream();
        ZipInputStream zis = new ZipInputStream(openStream);
        while ((nextEntry = zis.getNextEntry()) != null) {
            String name = nextEntry.getName();
            if (!nextEntry.isDirectory()) {
                int len;
                byte[] buf = new byte[1024];
                ByteArrayOutputStream arrayOut = new ByteArrayOutputStream();
                while ((len = zis.read(buf)) > 0) {
                    arrayOut.write(buf, 0, len);
                }
                ByteArrayInputStream bis = new ByteArrayInputStream(arrayOut.toByteArray());
                IFile file = prj.getFile((IPath)new Path(name));
                file.create((InputStream)bis, true, (IProgressMonitor)monitor);
            } else {
                IFolder f = prj.getFolder((IPath)new Path(name));
                f.create(true, true, (IProgressMonitor)monitor);
            }
            zis.closeEntry();
        }
    }
}

