/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.debug.model;

import org.eclipse.core.runtime.Assert;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.dltk.dbgp.IDbgpSession;
import org.eclipse.dltk.dbgp.IDbgpThreadAcceptor;
import org.eclipse.dltk.internal.debug.core.model.DebugEventHelper;
import org.eclipse.dltk.internal.debug.core.model.ScriptDebugTarget;
import org.eclipse.dltk.internal.debug.core.model.ScriptThread;

public class RubyThreadManager
implements ISuspendResume,
ITerminate,
IDbgpThreadAcceptor {
    private static final int WAITING = 0;
    private static final int ACCEPTING = 1;
    private static final int TERMINATING = 2;
    private static final int TERMINATED = 3;
    private Object lock = new Object();
    private int state;
    private ScriptThread[] threads;
    private ScriptDebugTarget debugTarget;

    private void destroy() {
        this.state = 3;
    }

    private void addThread(ScriptThread thread) {
        ScriptThread[] newThreads = new ScriptThread[this.threads.length + 1];
        System.arraycopy(this.threads, 0, newThreads, 0, this.threads.length);
        newThreads[this.threads.length] = thread;
        this.threads = newThreads;
    }

    private void removeThread(ScriptThread thread) {
        ScriptThread[] newThreads = new ScriptThread[this.threads.length - 1];
        int i = 0;
        int j = 0;
        while (i < this.threads.length) {
            if (this.threads[i] != thread) {
                newThreads[j++] = this.threads[i];
            }
            ++i;
        }
        this.threads = newThreads;
    }

    protected void createThread(IDbgpSession session) {
        IDebugElement thread = null;
        this.addThread((ScriptThread)thread);
        DebugEventHelper.fireCreateEvent(thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateThread(ScriptThread thread) {
        Object object = this.lock;
        synchronized (object) {
            this.removeThread(thread);
            DebugEventHelper.fireTerminateEvent((IDebugElement)thread);
            if (!this.hasThreads()) {
                this.destroy();
            }
        }
    }

    public RubyThreadManager(ScriptDebugTarget debugTarget) {
        this.debugTarget = debugTarget;
        this.state = 0;
        this.threads = new ScriptThread[0];
    }

    public ScriptDebugTarget getDebugTarget() {
        return this.debugTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptThread[] getThreads() {
        Object object = this.lock;
        synchronized (object) {
            return (ScriptThread[])this.threads.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasThreads() {
        Object object = this.lock;
        synchronized (object) {
            return this.threads.length > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canResume() {
        Object object = this.lock;
        synchronized (object) {
            if (this.state == 1) {
                Assert.isTrue((boolean)this.hasThreads());
                int i = 0;
                while (i < this.threads.length) {
                    if (this.threads[i].canResume()) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canSuspend() {
        Object object = this.lock;
        synchronized (object) {
            if (this.state == 1) {
                Assert.isTrue((boolean)this.hasThreads());
                int i = 0;
                while (i < this.threads.length) {
                    if (this.threads[i].canSuspend()) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSuspended() {
        Object object = this.lock;
        synchronized (object) {
            if (this.state != 1) {
                return false;
            }
            Assert.isTrue((boolean)this.hasThreads());
            int i = 0;
            while (true) {
                if (i >= this.threads.length) {
                    return true;
                }
                if (!this.threads[i].isSuspended()) {
                    return false;
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() throws DebugException {
        Object object = this.lock;
        synchronized (object) {
            if (this.state == 1) {
                Assert.isTrue((boolean)this.hasThreads());
                int i = 0;
                while (i < this.threads.length) {
                    ScriptThread thread = this.threads[i];
                    if (thread.canResume()) {
                        thread.resume();
                    }
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() throws DebugException {
        Object object = this.lock;
        synchronized (object) {
            if (this.state == 1) {
                Assert.isTrue((boolean)this.hasThreads());
                int i = 0;
                while (i < this.threads.length) {
                    ScriptThread thread = this.threads[i];
                    if (thread.canSuspend()) {
                        thread.suspend();
                    }
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canTerminate() {
        Object object = this.lock;
        synchronized (object) {
            return this.state == 0 || this.state == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTerminated() {
        Object object = this.lock;
        synchronized (object) {
            return this.state == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() throws DebugException {
        Object object = this.lock;
        synchronized (object) {
            if (this.state == 0) {
                this.destroy();
            } else if (this.state == 1) {
                this.state = 2;
                ScriptThread[] temp = this.getThreads();
                int i = 0;
                while (i < temp.length) {
                    temp[i].terminate();
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptDbgpThread(IDbgpSession session) {
        Object object = this.lock;
        synchronized (object) {
            if (this.state == 3 || this.state == 2) {
                return;
            }
            this.createThread(session);
            if (this.state == 0) {
                this.state = 1;
            }
        }
    }

    public void acceptDbgpThreadNotUnavailable() {
    }
}

