/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.navigator;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.navigator.ScriptExplorerContentProvider;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.IExtensionStateModel;
import org.eclipse.ui.navigator.IPipelinedTreeContentProvider;
import org.eclipse.ui.navigator.PipelinedShapeModification;
import org.eclipse.ui.navigator.PipelinedViewerUpdate;

public class ScriptNavigatorContentProvider
extends ScriptExplorerContentProvider
implements IPipelinedTreeContentProvider {
    public static final String JDT_EXTENSION_ID = "org.eclipse.jdt.ui.javaContent";
    private IExtensionStateModel fStateModel;
    private Object fRealInput;

    public ScriptNavigatorContentProvider() {
        super(false);
    }

    public ScriptNavigatorContentProvider(boolean provideMembers) {
        super(provideMembers);
    }

    public void init(ICommonContentExtensionSite commonContentExtensionSite) {
        IExtensionStateModel stateModel = commonContentExtensionSite.getExtensionStateModel();
        IMemento memento = commonContentExtensionSite.getMemento();
        this.fStateModel = stateModel;
        this.restoreState(memento);
        this.fStateModel.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("isLayoutFlat".equals(event.getProperty()) && event.getNewValue() != null) {
                    boolean newValue = (Boolean)event.getNewValue() != false;
                    ScriptNavigatorContentProvider.this.setIsFlatLayout(newValue);
                }
            }
        });
        IPreferenceStore store = this.getPreferenceStore();
        boolean showCUChildren = store.getBoolean("org.eclipse.dltk.ui.packages.cuchildren");
        this.setProvideMembers(showCUChildren);
    }

    protected IPreferenceStore getPreferenceStore() {
        return DLTKUIPlugin.getDefault().getPreferenceStore();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fRealInput = newInput;
        super.inputChanged(viewer, oldInput, this.findInputElement(newInput));
    }

    public Object getParent(Object element) {
        Object parent = super.getParent(element);
        if (parent instanceof IScriptModel) {
            if (this.getViewerInput() != null) {
                if (this.fRealInput != element) {
                    return this.fRealInput;
                }
                return null;
            }
            return parent;
        }
        return parent;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IWorkspaceRoot) {
            return super.getElements(DLTKCore.create((IWorkspaceRoot)((IWorkspaceRoot)inputElement)));
        }
        return super.getElements(inputElement);
    }

    private Object findInputElement(Object newInput) {
        if (newInput instanceof IWorkspaceRoot) {
            return DLTKCore.create((IWorkspaceRoot)((IWorkspaceRoot)newInput));
        }
        return newInput;
    }

    public void restoreState(IMemento memento) {
    }

    public void saveState(IMemento memento) {
    }

    public void getPipelinedChildren(Object parent, Set currentChildren) {
        Object[] children = this.getChildren(parent);
        Iterator iter = currentChildren.iterator();
        while (iter.hasNext()) {
            if (!(iter.next() instanceof IResource)) continue;
            iter.remove();
        }
        currentChildren.addAll(Arrays.asList(children));
    }

    public void getPipelinedElements(Object input, Set currentElements) {
        Object[] children = this.getElements(input);
        Iterator iter = currentElements.iterator();
        while (iter.hasNext()) {
            if (!(iter.next() instanceof IResource)) continue;
            iter.remove();
        }
        currentElements.addAll(Arrays.asList(children));
    }

    public Object getPipelinedParent(Object object, Object suggestedParent) {
        return this.getParent(object);
    }

    public PipelinedShapeModification interceptAdd(PipelinedShapeModification addModification) {
        this.convertToJavaElements(addModification);
        return addModification;
    }

    public PipelinedShapeModification interceptRemove(PipelinedShapeModification removeModification) {
        this.convertToJavaElements(removeModification.getChildren());
        return removeModification;
    }

    private boolean convertToJavaElements(PipelinedShapeModification modification) {
        IModelElement element;
        Object parent = modification.getParent();
        if (parent instanceof IContainer && (element = DLTKCore.create((IResource)((IContainer)parent))) != null && element.exists()) {
            if (!(element instanceof IScriptModel)) {
                modification.setParent((Object)element);
            }
            return this.convertToJavaElements(modification.getChildren());
        }
        return false;
    }

    private boolean convertToJavaElements(Set currentChildren) {
        LinkedHashSet<IModelElement> convertedChildren = new LinkedHashSet<IModelElement>();
        Iterator childrenItr = currentChildren.iterator();
        while (childrenItr.hasNext()) {
            IModelElement newChild;
            Object child = childrenItr.next();
            if (!(child instanceof IResource) || (newChild = DLTKCore.create((IResource)((IResource)child))) == null || !newChild.exists()) continue;
            childrenItr.remove();
            convertedChildren.add(newChild);
        }
        if (!convertedChildren.isEmpty()) {
            currentChildren.addAll(convertedChildren);
            return true;
        }
        return false;
    }

    public boolean interceptRefresh(PipelinedViewerUpdate refreshSynchronization) {
        return this.convertToJavaElements(refreshSynchronization.getRefreshTargets());
    }

    public boolean interceptUpdate(PipelinedViewerUpdate updateSynchronization) {
        return this.convertToJavaElements(updateSynchronization.getRefreshTargets());
    }

    protected void postAdd(Object parent, Object element) {
        if (parent instanceof IScriptModel) {
            super.postAdd(((IScriptModel)parent).getWorkspace(), element);
        } else {
            super.postAdd(parent, element);
        }
    }

    protected void postRefresh(List toRefresh, boolean updateLabels) {
        Iterator iter = toRefresh.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof IScriptModel)) continue;
            iter.remove();
            toRefresh.add(this.fRealInput);
            super.postRefresh(toRefresh, updateLabels);
            return;
        }
        super.postRefresh(toRefresh, updateLabels);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IScriptModel) {
            try {
                return this.getScriptProjects((IScriptModel)parentElement);
            }
            catch (ModelException modelException) {
                return NO_CHILDREN;
            }
        }
        return super.getChildren(parentElement);
    }
}

