/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.dbgp.internal.utils;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.dltk.dbgp.exceptions.DbgpDebuggingEngineException;
import org.eclipse.dltk.dbgp.exceptions.DbgpIOException;
import org.eclipse.dltk.dbgp.exceptions.DbgpProtocolException;
import org.eclipse.dltk.dbgp.internal.utils.Base64Helper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DbgpXmlParser {
    protected DbgpXmlParser() {
    }

    protected static int getPosition(String s) {
        return Integer.parseInt(s.substring(s.indexOf(58) + 1));
    }

    protected static boolean makeBoolean(String s) {
        return Integer.parseInt(s) != 0;
    }

    public static Document parseXml(String xml) throws DbgpProtocolException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            StringReader reader = new StringReader(xml);
            return builder.parse(new InputSource(reader));
        }
        catch (ParserConfigurationException e) {
            throw new DbgpProtocolException(e);
        }
        catch (SAXException e) {
            throw new DbgpProtocolException(e);
        }
        catch (IOException e) {
            throw new DbgpProtocolException(e);
        }
    }

    protected static String parseContent(Element element) {
        NodeList list = element.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node e = list.item(i);
            short type = e.getNodeType();
            if (type == 3 || type == 4) {
                return e.getNodeValue();
            }
            ++i;
        }
        return "";
    }

    public static String parseBase64Content(Element element) {
        try {
            return Base64Helper.decodeString(DbgpXmlParser.parseContent(element));
        }
        catch (DbgpIOException dbgpIOException) {
            return "";
        }
    }

    public static DbgpDebuggingEngineException checkError(Element element) {
        NodeList errors = element.getElementsByTagName("error");
        if (errors.getLength() > 0) {
            Element error = (Element)errors.item(0);
            int errorCode = Integer.parseInt(error.getAttribute("code"));
            String errorText = "No message";
            NodeList messages = error.getElementsByTagName("message");
            if (messages.getLength() > 0) {
                errorText = DbgpXmlParser.parseContent((Element)messages.item(0));
            }
            return new DbgpDebuggingEngineException(errorCode, errorText);
        }
        return null;
    }

    public static boolean parseSuccess(Element response) {
        if (!response.hasAttribute("success")) {
            return true;
        }
        return DbgpXmlParser.makeBoolean(response.getAttribute("success"));
    }
}

