/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.InterpreterStandin;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;

public abstract class ProjectWizardFirstPage
extends WizardPage {
    private NameGroup fNameGroup;
    private LocationGroup fLocationGroup;
    private boolean interpretersPresent;
    private DetectGroup fDetectGroup;
    private Validator fValidator;
    private String fInitialName;
    private static final String PAGE_NAME = NewWizardMessages.ScriptProjectWizardFirstPage_page_pageName;

    public ProjectWizardFirstPage() {
        super(PAGE_NAME);
        this.setPageComplete(false);
        this.setTitle(NewWizardMessages.ScriptProjectWizardFirstPage_page_title);
        this.setDescription(NewWizardMessages.ScriptProjectWizardFirstPage_page_description);
        this.fInitialName = "";
    }

    public void setName(String name) {
        this.fInitialName = name;
        if (this.fNameGroup != null) {
            this.fNameGroup.setName(name);
        }
    }

    protected abstract boolean interpeterRequired();

    protected abstract boolean supportInterpreter();

    protected abstract void createInterpreterGroup(Composite var1);

    protected abstract void handlePossibleInterpreterChange();

    protected abstract Observable getInterpreterGroupObservable();

    protected abstract IInterpreterInstall getInterpreter();

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)this.initGridLayout(new GridLayout(1, false), true));
        composite.setLayoutData((Object)new GridData(256));
        this.fNameGroup = new NameGroup(composite, this.fInitialName);
        this.fLocationGroup = new LocationGroup(composite);
        if (this.supportInterpreter()) {
            this.createInterpreterGroup(composite);
        }
        this.fDetectGroup = new DetectGroup(composite);
        this.fNameGroup.addObserver(this.fLocationGroup);
        this.fLocationGroup.addObserver(this.fDetectGroup);
        this.fNameGroup.notifyObservers();
        this.fValidator = new Validator();
        Observable interpreterGroupObservable = this.getInterpreterGroupObservable();
        if (this.supportInterpreter() && interpreterGroupObservable != null) {
            interpreterGroupObservable.addObserver(this.fValidator);
            this.handlePossibleInterpreterChange();
        }
        this.fNameGroup.addObserver(this.fValidator);
        this.fLocationGroup.addObserver(this.fValidator);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        if (DLTKCore.DEBUG) {
            System.err.println("Add help support here...");
        }
    }

    public IPath getLocationPath() {
        return this.fLocationGroup.getLocation();
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.fNameGroup.getName());
    }

    public boolean isInWorkspace() {
        return this.fLocationGroup.isInWorkspace();
    }

    public String getProjectName() {
        return this.fNameGroup.getName();
    }

    public boolean getDetect() {
        return this.fDetectGroup.mustDetect();
    }

    public boolean isSrc() {
        return false;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fNameGroup.postSetFocus();
        }
    }

    protected GridLayout initGridLayout(GridLayout layout, boolean margins) {
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        if (margins) {
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        } else {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        return layout;
    }

    protected GridData setButtonLayoutData(Button button) {
        return super.setButtonLayoutData(button);
    }

    protected abstract class AbstractInterpreterGroup
    extends Observable
    implements Observer,
    SelectionListener,
    IDialogFieldListener {
        private final SelectionButtonDialogField fUseDefaultInterpreterEnvironment;
        private final SelectionButtonDialogField fUseProjectInterpreterEnvironment;
        private final ComboDialogField fInterpreterEnvironmentCombo;
        private final Group fGroup;
        private String[] fComplianceLabels;
        private final Link fPreferenceLink;
        private IInterpreterInstall[] fInstalledInterpreters;

        public AbstractInterpreterGroup(Composite composite) {
            this.fGroup = new Group(composite, 0);
            this.fGroup.setFont(composite.getFont());
            this.fGroup.setLayoutData((Object)new GridData(768));
            this.fGroup.setLayout((Layout)ProjectWizardFirstPage.this.initGridLayout(new GridLayout(3, false), true));
            this.fGroup.setText(NewWizardMessages.ScriptProjectWizardFirstPage_InterpreterEnvironmentGroup_title);
            this.fUseDefaultInterpreterEnvironment = new SelectionButtonDialogField(16);
            this.fUseDefaultInterpreterEnvironment.setLabelText(this.getDefaultInterpreterLabel());
            this.fUseDefaultInterpreterEnvironment.doFillIntoGrid((Composite)this.fGroup, 2);
            this.fPreferenceLink = new Link((Composite)this.fGroup, 0);
            this.fPreferenceLink.setFont(this.fGroup.getFont());
            this.fPreferenceLink.setText(NewWizardMessages.ScriptProjectWizardFirstPage_InterpreterEnvironmentGroup_link_description);
            this.fPreferenceLink.setLayoutData((Object)new GridData(3, 2, false, false));
            this.fPreferenceLink.addSelectionListener((SelectionListener)this);
            this.fUseProjectInterpreterEnvironment = new SelectionButtonDialogField(16);
            this.fUseProjectInterpreterEnvironment.setLabelText(NewWizardMessages.ScriptProjectWizardFirstPage_InterpreterEnvironmentGroup_specific_compliance);
            this.fUseProjectInterpreterEnvironment.doFillIntoGrid((Composite)this.fGroup, 1);
            this.fUseProjectInterpreterEnvironment.setDialogFieldListener(this);
            this.fInterpreterEnvironmentCombo = new ComboDialogField(8);
            this.fillInstalledInterpreterEnvironments(this.fInterpreterEnvironmentCombo);
            this.fInterpreterEnvironmentCombo.setDialogFieldListener(this);
            Combo comboControl = this.fInterpreterEnvironmentCombo.getComboControl((Composite)this.fGroup);
            GridData gridData = new GridData(1, 2, true, false);
            gridData.minimumWidth = 100;
            comboControl.setLayoutData((Object)gridData);
            comboControl.setVisibleItemCount(20);
            DialogField.createEmptySpace((Composite)this.fGroup);
            this.fUseDefaultInterpreterEnvironment.setSelection(true);
            this.fInterpreterEnvironmentCombo.setEnabled(this.fUseProjectInterpreterEnvironment.isSelected());
        }

        private void fillInstalledInterpreterEnvironments(ComboDialogField comboField) {
            String selectedItem = null;
            int selectionIndex = -1;
            if (this.fUseProjectInterpreterEnvironment.isSelected() && (selectionIndex = comboField.getSelectionIndex()) != -1) {
                selectedItem = comboField.getItems()[selectionIndex];
            }
            this.fInstalledInterpreters = this.getWorkspaceInterpeters();
            selectionIndex = -1;
            this.fComplianceLabels = new String[this.fInstalledInterpreters.length];
            int i = 0;
            while (i < this.fInstalledInterpreters.length) {
                this.fComplianceLabels[i] = this.fInstalledInterpreters[i].getName();
                if (selectedItem != null && this.fComplianceLabels[i].equals(selectedItem)) {
                    selectionIndex = i;
                }
                ++i;
            }
            comboField.setItems(this.fComplianceLabels);
            if (selectionIndex == -1) {
                this.fInterpreterEnvironmentCombo.selectItem(this.getDefaultInterpreterName());
            } else {
                this.fInterpreterEnvironmentCombo.selectItem(selectedItem);
            }
            ProjectWizardFirstPage.this.interpretersPresent = this.fInstalledInterpreters.length > 0;
        }

        private IInterpreterInstall[] getWorkspaceInterpeters() {
            ArrayList<InterpreterStandin> standins = new ArrayList<InterpreterStandin>();
            IInterpreterInstallType[] types = ScriptRuntime.getInterpreterInstallTypes((String)this.getCurrentLanguageNature());
            int i = 0;
            while (i < types.length) {
                IInterpreterInstallType type = types[i];
                IInterpreterInstall[] installs = type.getInterpreterInstalls();
                int j = 0;
                while (j < installs.length) {
                    IInterpreterInstall install = installs[j];
                    standins.add(new InterpreterStandin(install));
                    ++j;
                }
                ++i;
            }
            return standins.toArray(new IInterpreterInstall[standins.size()]);
        }

        private String getDefaultInterpreterName() {
            IInterpreterInstall inst = ScriptRuntime.getDefaultInterpreterInstall((String)this.getCurrentLanguageNature());
            if (inst != null) {
                return inst.getName();
            }
            return "undefined";
        }

        private String getDefaultInterpreterLabel() {
            return Messages.format(NewWizardMessages.ScriptProjectWizardFirstPage_InterpreterEnvironmentGroup_default_compliance, this.getDefaultInterpreterName());
        }

        public void update(Observable o, Object arg) {
            this.updateEnableState();
        }

        private void updateEnableState() {
            if (ProjectWizardFirstPage.this.fDetectGroup == null) {
                return;
            }
            boolean detect = ProjectWizardFirstPage.this.fDetectGroup.mustDetect();
            this.fUseDefaultInterpreterEnvironment.setEnabled(!detect);
            this.fUseProjectInterpreterEnvironment.setEnabled(!detect);
            this.fInterpreterEnvironmentCombo.setEnabled(!detect && this.fUseProjectInterpreterEnvironment.isSelected());
            this.fPreferenceLink.setEnabled(!detect);
            this.fGroup.setEnabled(!detect);
        }

        public void widgetSelected(SelectionEvent e) {
            this.widgetDefaultSelected(e);
        }

        protected abstract void showInterpreterPreferencePage();

        protected abstract String getCurrentLanguageNature();

        public void widgetDefaultSelected(SelectionEvent e) {
            this.showInterpreterPreferencePage();
            this.handlePossibleInterpreterChange();
        }

        public void handlePossibleInterpreterChange() {
            this.fUseDefaultInterpreterEnvironment.setLabelText(this.getDefaultInterpreterLabel());
            this.fillInstalledInterpreterEnvironments(this.fInterpreterEnvironmentCombo);
            this.setChanged();
            this.notifyObservers();
        }

        public void dialogFieldChanged(DialogField field) {
            this.updateEnableState();
        }

        public boolean isUseSpecific() {
            return this.fUseProjectInterpreterEnvironment.isSelected();
        }

        public IInterpreterInstall getSelectedInterpreter() {
            int index;
            if (this.fUseProjectInterpreterEnvironment.isSelected() && (index = this.fInterpreterEnvironmentCombo.getSelectionIndex()) >= 0 && index < this.fComplianceLabels.length) {
                return this.fInstalledInterpreters[index];
            }
            return null;
        }
    }

    private final class DetectGroup
    extends Observable
    implements Observer,
    SelectionListener {
        private final Link fHintText;
        private boolean fDetect;

        public DetectGroup(Composite composite) {
            Link InterpreterEnvironment50Text = new Link(composite, 64);
            InterpreterEnvironment50Text.setFont(composite.getFont());
            InterpreterEnvironment50Text.addSelectionListener((SelectionListener)this);
            GridData gridData = new GridData(4, 4, true, true);
            gridData.widthHint = ProjectWizardFirstPage.this.convertWidthInCharsToPixels(50);
            InterpreterEnvironment50Text.setLayoutData((Object)gridData);
            this.fHintText = InterpreterEnvironment50Text;
            if (ProjectWizardFirstPage.this.supportInterpreter()) {
                ProjectWizardFirstPage.this.handlePossibleInterpreterChange();
            }
        }

        public void update(Observable o, Object arg) {
            if (o instanceof LocationGroup) {
                boolean oldDetectState = this.fDetect;
                if (ProjectWizardFirstPage.this.fLocationGroup.isInWorkspace()) {
                    String name = ProjectWizardFirstPage.this.getProjectName();
                    if (name.length() == 0 || DLTKUIPlugin.getWorkspace().getRoot().findMember(name) != null) {
                        this.fDetect = false;
                    } else {
                        File directory = ProjectWizardFirstPage.this.fLocationGroup.getLocation().append(ProjectWizardFirstPage.this.getProjectName()).toFile();
                        this.fDetect = directory.isDirectory();
                    }
                } else {
                    File directory = ProjectWizardFirstPage.this.fLocationGroup.getLocation().toFile();
                    this.fDetect = directory.isDirectory();
                }
                if (oldDetectState != this.fDetect) {
                    this.setChanged();
                    this.notifyObservers();
                    if (this.fDetect) {
                        this.fHintText.setVisible(true);
                        this.fHintText.setText(NewWizardMessages.ScriptProjectWizardFirstPage_DetectGroup_message);
                    } else if (ProjectWizardFirstPage.this.supportInterpreter()) {
                        ProjectWizardFirstPage.this.handlePossibleInterpreterChange();
                    }
                }
            }
        }

        public boolean mustDetect() {
            return this.fDetect;
        }

        public void widgetSelected(SelectionEvent e) {
            this.widgetDefaultSelected(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            if (DLTKCore.DEBUG) {
                System.err.println("DetectGroup show compilancePreferencePage...");
            }
            if (ProjectWizardFirstPage.this.supportInterpreter()) {
                ProjectWizardFirstPage.this.handlePossibleInterpreterChange();
            }
        }
    }

    private final class LocationGroup
    extends Observable
    implements Observer,
    IStringButtonAdapter,
    IDialogFieldListener {
        protected final SelectionButtonDialogField fWorkspaceRadio;
        protected final SelectionButtonDialogField fExternalRadio;
        protected final StringButtonDialogField fLocation;
        private String fPreviousExternalLocation;
        private static final String DIALOGSTORE_LAST_EXTERNAL_LOC = "org.eclipse.dltk.ui.last.external.project";

        public LocationGroup(Composite composite) {
            Group group = new Group(composite, 0);
            group.setLayoutData((Object)new GridData(768));
            group.setLayout((Layout)ProjectWizardFirstPage.this.initGridLayout(new GridLayout(3, false), true));
            group.setText(NewWizardMessages.ScriptProjectWizardFirstPage_LocationGroup_title);
            this.fWorkspaceRadio = new SelectionButtonDialogField(16);
            this.fWorkspaceRadio.setDialogFieldListener(this);
            this.fWorkspaceRadio.setLabelText(NewWizardMessages.ScriptProjectWizardFirstPage_LocationGroup_workspace_desc);
            this.fExternalRadio = new SelectionButtonDialogField(16);
            this.fExternalRadio.setLabelText(NewWizardMessages.ScriptProjectWizardFirstPage_LocationGroup_external_desc);
            this.fLocation = new StringButtonDialogField(this);
            this.fLocation.setDialogFieldListener(this);
            this.fLocation.setLabelText(NewWizardMessages.ScriptProjectWizardFirstPage_LocationGroup_locationLabel_desc);
            this.fLocation.setButtonLabel(NewWizardMessages.ScriptProjectWizardFirstPage_LocationGroup_browseButton_desc);
            this.fExternalRadio.attachDialogField(this.fLocation);
            this.fWorkspaceRadio.setSelection(true);
            this.fExternalRadio.setSelection(false);
            this.fPreviousExternalLocation = "";
            this.fWorkspaceRadio.doFillIntoGrid((Composite)group, 3);
            this.fExternalRadio.doFillIntoGrid((Composite)group, 3);
            this.fLocation.doFillIntoGrid((Composite)group, 3);
            LayoutUtil.setHorizontalGrabbing((Control)this.fLocation.getTextControl(null));
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        protected String getDefaultPath(String name) {
            IPath path = Platform.getLocation().append(name);
            return path.toOSString();
        }

        public void update(Observable o, Object arg) {
            if (this.isInWorkspace()) {
                this.fLocation.setText(this.getDefaultPath(ProjectWizardFirstPage.this.fNameGroup.getName()));
            }
            this.fireEvent();
        }

        public IPath getLocation() {
            if (this.isInWorkspace()) {
                return Platform.getLocation();
            }
            return Path.fromOSString((String)this.fLocation.getText().trim());
        }

        public boolean isInWorkspace() {
            return this.fWorkspaceRadio.isSelected();
        }

        public void changeControlPressed(DialogField field) {
            String selectedDirectory;
            File path;
            String prevLocation;
            DirectoryDialog dialog = new DirectoryDialog(ProjectWizardFirstPage.this.getShell());
            dialog.setMessage(NewWizardMessages.ScriptProjectWizardFirstPage_directory_message);
            String directoryName = this.fLocation.getText().trim();
            if (directoryName.length() == 0 && (prevLocation = DLTKUIPlugin.getDefault().getDialogSettings().get(DIALOGSTORE_LAST_EXTERNAL_LOC)) != null) {
                directoryName = prevLocation;
            }
            if (directoryName.length() > 0 && (path = new File(directoryName)).exists()) {
                dialog.setFilterPath(directoryName);
            }
            if ((selectedDirectory = dialog.open()) != null) {
                this.fLocation.setText(selectedDirectory);
                DLTKUIPlugin.getDefault().getDialogSettings().put(DIALOGSTORE_LAST_EXTERNAL_LOC, selectedDirectory);
            }
        }

        public void dialogFieldChanged(DialogField field) {
            if (field == this.fWorkspaceRadio) {
                boolean checked = this.fWorkspaceRadio.isSelected();
                if (checked) {
                    this.fPreviousExternalLocation = this.fLocation.getText();
                    this.fLocation.setText(this.getDefaultPath(ProjectWizardFirstPage.this.fNameGroup.getName()));
                } else {
                    this.fLocation.setText(this.fPreviousExternalLocation);
                }
            }
            this.fireEvent();
        }
    }

    private final class NameGroup
    extends Observable
    implements IDialogFieldListener {
        protected final StringDialogField fNameField;

        public NameGroup(Composite composite, String initialName) {
            Composite nameComposite = new Composite(composite, 0);
            nameComposite.setFont(composite.getFont());
            nameComposite.setLayout((Layout)ProjectWizardFirstPage.this.initGridLayout(new GridLayout(2, false), false));
            nameComposite.setLayoutData((Object)new GridData(768));
            this.fNameField = new StringDialogField();
            this.fNameField.setLabelText(NewWizardMessages.ScriptProjectWizardFirstPage_NameGroup_label_text);
            this.fNameField.setDialogFieldListener(this);
            this.setName(initialName);
            this.fNameField.doFillIntoGrid(nameComposite, 2);
            LayoutUtil.setHorizontalGrabbing((Control)this.fNameField.getTextControl(null));
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        public String getName() {
            return this.fNameField.getText().trim();
        }

        public void postSetFocus() {
            this.fNameField.postSetFocusOnDialogField(ProjectWizardFirstPage.this.getShell().getDisplay());
        }

        public void setName(String name) {
            this.fNameField.setText(name);
        }

        public void dialogFieldChanged(DialogField field) {
            this.fireEvent();
        }
    }

    private final class Validator
    implements Observer {
        private Validator() {
        }

        public void update(Observable o, Object arg) {
            IStatus locationStatus;
            IWorkspace workspace = DLTKUIPlugin.getWorkspace();
            String name = ProjectWizardFirstPage.this.fNameGroup.getName();
            if (name.length() == 0) {
                ProjectWizardFirstPage.this.setErrorMessage(null);
                ProjectWizardFirstPage.this.setMessage(NewWizardMessages.ScriptProjectWizardFirstPage_Message_enterProjectName);
                ProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            IStatus nameStatus = workspace.validateName(name, 4);
            if (!nameStatus.isOK()) {
                ProjectWizardFirstPage.this.setErrorMessage(nameStatus.getMessage());
                ProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            IProject handle = ProjectWizardFirstPage.this.getProjectHandle();
            if (handle.exists()) {
                ProjectWizardFirstPage.this.setErrorMessage(NewWizardMessages.ScriptProjectWizardFirstPage_Message_projectAlreadyExists);
                ProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            String location = ProjectWizardFirstPage.this.fLocationGroup.getLocation().toOSString();
            if (location.length() == 0) {
                ProjectWizardFirstPage.this.setErrorMessage(null);
                ProjectWizardFirstPage.this.setMessage(NewWizardMessages.ScriptProjectWizardFirstPage_Message_enterLocation);
                ProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            if (!Path.EMPTY.isValidPath(location)) {
                ProjectWizardFirstPage.this.setErrorMessage(NewWizardMessages.ScriptProjectWizardFirstPage_Message_invalidDirectory);
                ProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            IPath projectPath = Path.fromOSString((String)location);
            if (!ProjectWizardFirstPage.this.fLocationGroup.isInWorkspace() && Platform.getLocation().isPrefixOf(projectPath)) {
                ProjectWizardFirstPage.this.setErrorMessage(NewWizardMessages.ScriptProjectWizardFirstPage_Message_cannotCreateInWorkspace);
                ProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            if (!ProjectWizardFirstPage.this.fLocationGroup.isInWorkspace() && !(locationStatus = workspace.validateProjectLocation(handle, projectPath)).isOK()) {
                ProjectWizardFirstPage.this.setErrorMessage(locationStatus.getMessage());
                ProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            if (ProjectWizardFirstPage.this.supportInterpreter() && ProjectWizardFirstPage.this.interpeterRequired() && !ProjectWizardFirstPage.this.interpretersPresent) {
                ProjectWizardFirstPage.this.setErrorMessage("Please configure interpreters");
                ProjectWizardFirstPage.this.setPageComplete(false);
                return;
            }
            ProjectWizardFirstPage.this.setPageComplete(true);
            ProjectWizardFirstPage.this.setErrorMessage(null);
            ProjectWizardFirstPage.this.setMessage(null);
        }
    }
}

