/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ui.text.util.IPartitionFilter;
import org.eclipse.dltk.ui.text.util.ITabPreferencesProvider;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;

public class AutoEditUtils {
    private AutoEditUtils() {
        throw new AssertionError((Object)"Cannot instantiate utility class");
    }

    public static char getBracePair(char b) {
        switch (b) {
            case '(': {
                return ')';
            }
            case ')': {
                return '(';
            }
            case '[': {
                return ']';
            }
            case ']': {
                return '[';
            }
            case '{': {
                return '}';
            }
            case '}': {
                return '{';
            }
            case '\"': {
                return '\"';
            }
            case '\'': {
                return '\'';
            }
        }
        return b;
    }

    public static boolean isNewLineInsertionCommand(IDocument d, DocumentCommand c) {
        if (c.length > 0 || c.text == null) {
            return false;
        }
        String[] legalLineDelimiters = d.getLegalLineDelimiters();
        int i = 0;
        while (i < legalLineDelimiters.length) {
            if (legalLineDelimiters[i].equals(c.text)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isSingleCharactedInsertionOrReplaceCommand(DocumentCommand c) {
        return c.length <= 1 && c.text.length() == 1;
    }

    public static String getNSpaces(int spaces) {
        return AutoEditUtils.getNChars(spaces, ' ');
    }

    public static String getNChars(int count, char ch) {
        StringBuffer buf = new StringBuffer(count);
        int i = 0;
        while (i < count) {
            buf.append(ch);
            ++i;
        }
        return buf.toString();
    }

    public static boolean rangeContainsPartitions(IDocument document, int startOffset, int length, String[] partitions, String partitioning) throws BadLocationException {
        int offset = startOffset;
        while (offset < startOffset + length) {
            ITypedRegion region = TextUtilities.getPartition((IDocument)document, (String)partitioning, (int)offset, (boolean)true);
            String rt = region.getType();
            if (AutoEditUtils.isPartitionOneOf(rt, partitions)) {
                return true;
            }
            offset = region.getOffset() + region.getLength();
            ++offset;
        }
        return false;
    }

    public static boolean rangeIsInsideDefaultPartition(IDocument document, int startOffset, int length, String partitioning) throws BadLocationException {
        int offset = startOffset;
        while (offset < startOffset + length) {
            ITypedRegion region = TextUtilities.getPartition((IDocument)document, (String)partitioning, (int)offset, (boolean)true);
            String rt = region.getType();
            if (rt != "__dftl_partition_content_type") {
                return false;
            }
            offset = region.getOffset() + region.getLength();
            ++offset;
        }
        return true;
    }

    public static boolean isStartOfLine(IDocument document, int offset) throws BadLocationException {
        String string;
        if (offset >= 2) {
            string = document.get(offset - 2, 2);
        } else if (offset >= 1) {
            string = document.get(offset - 1, 1);
        } else {
            return true;
        }
        return TextUtilities.endsWith((String[])document.getLegalLineDelimiters(), (String)string) != -1;
    }

    public static String getLineIndent(IDocument document, int line) throws BadLocationException {
        if (line > -1) {
            int start = document.getLineOffset(line);
            int end = start + document.getLineLength(line);
            int whiteend = AutoEditUtils.findEndOfWhiteSpace(document, start, end);
            return document.get(start, whiteend - start);
        }
        return "";
    }

    public static int findEndOfWhiteSpace(IDocument document, int offset, int end) throws BadLocationException {
        while (offset < end) {
            char c = document.getChar(offset);
            if (c != ' ' && c != '\t') {
                return offset;
            }
            ++offset;
        }
        return end;
    }

    public static String getLineIndent(String line) {
        int end;
        int whiteend = end = line.length();
        int offset = 0;
        while (offset < end) {
            char c = line.charAt(offset);
            if (c != ' ' && c != '\t') {
                whiteend = offset;
                break;
            }
            ++offset;
        }
        return line.substring(0, whiteend);
    }

    public static String getDocumentLine(IDocument document, int line) throws BadLocationException {
        int lineStart = document.getLineOffset(line);
        int lineLength = document.getLineLength(line);
        return document.get(lineStart, lineLength);
    }

    public static int getLastNonEmptyLine(IDocument d, int line, String commentString) throws BadLocationException {
        if (commentString == null) {
            int res = line;
            while (res >= 0) {
                String str = AutoEditUtils.getDocumentLine(d, res).trim();
                if (str.trim().length() > 0) {
                    return res;
                }
                --res;
            }
        } else {
            int res = line;
            while (res >= 0) {
                String str = AutoEditUtils.getDocumentLine(d, res).trim();
                if (!str.startsWith(commentString) && str.trim().length() > 0) {
                    return res;
                }
                --res;
            }
        }
        return -1;
    }

    public static String getRegionType(IDocument d, String partitioning, int offset) throws BadLocationException {
        int p = offset == d.getLength() ? offset - 1 : offset;
        ITypedRegion region = TextUtilities.getPartition((IDocument)d, (String)partitioning, (int)p, (boolean)true);
        return region.getType();
    }

    /*
     * Unable to fully structure code
     */
    public static int findMatchingCharacter(IDocument document, int startingOffset, boolean forward, String partitioning, char opening, char closing, IPartitionFilter partitionFilter, int maxCharsAway) throws BadLocationException {
        block10: {
            deep = 0;
            offset = startingOffset;
            if (!forward) ** GOTO lbl30
            while (offset < document.getLength()) {
                if (partitionFilter != null && !partitionFilter.allowPartition((region = TextUtilities.getPartition((IDocument)document, (String)partitioning, (int)offset, (boolean)true)).getType())) {
                    offset = region.getOffset() + region.getLength();
                    continue;
                }
                c = document.getChar(offset);
                if (c == opening) {
                    ++deep;
                }
                if (c == closing) {
                    if (deep == 0) {
                        return offset;
                    }
                    --deep;
                }
                if (++offset - startingOffset <= maxCharsAway) continue;
                return -1;
            }
            break block10;
lbl-1000:
            // 1 sources

            {
                if (partitionFilter != null && !partitionFilter.allowPartition((region = TextUtilities.getPartition((IDocument)document, (String)partitioning, (int)offset, (boolean)true)).getType())) {
                    offset = region.getOffset() - 1;
                    continue;
                }
                c = document.getChar(offset);
                if (c == closing) {
                    ++deep;
                }
                if (c == opening) {
                    if (deep == 0) {
                        return offset;
                    }
                    --deep;
                }
                if (startingOffset - --offset <= maxCharsAway) continue;
                return -1;
lbl30:
                // 3 sources

                ** while (offset >= 0)
            }
        }
        return -1;
    }

    public static boolean isPartitionOneOf(String partition, String[] list) {
        int i = 0;
        while (i < list.length) {
            String item = list[i];
            if (partition == item) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int calculateVisualLength(ITabPreferencesProvider prefs, IDocument document, int lineStart, int lineLength, int start, int end) throws BadLocationException {
        if (end == document.getLength()) {
            --end;
        }
        int res = 0;
        int tabSize = prefs.getTabSize();
        Assert.isLegal((end <= lineStart + lineLength ? 1 : 0) != 0, (String)"Cannot calculate visual length for several lines");
        int col = 0;
        int offset = lineStart;
        while (offset < start) {
            col = document.getChar(offset) != '\t' ? ++col : (col += tabSize - col % tabSize);
            ++offset;
        }
        offset = start;
        while (offset < end) {
            if (document.getChar(offset) != '\t') {
                ++res;
                ++col;
            } else {
                res += tabSize - col % tabSize;
                col += tabSize - col % tabSize;
            }
            ++offset;
        }
        return res;
    }

    public static int calculateVisualLength(ITabPreferencesProvider prefs, IDocument document, int lineIndex, int start, int end) throws BadLocationException {
        return AutoEditUtils.calculateVisualLength(prefs, document, document.getLineOffset(lineIndex), document.getLineLength(lineIndex), start, end);
    }

    public static int calculateVisualLength(ITabPreferencesProvider prefs, IDocument document, int start, int end) throws BadLocationException {
        return AutoEditUtils.calculateVisualLength(prefs, document, document.getLineOfOffset(start), start, end);
    }

    public static int getIndentVisualLength(ITabPreferencesProvider prefs, String str) {
        int res = 0;
        int i = 0;
        while (i < str.length()) {
            res = str.charAt(i) == '\t' ? (res += prefs.getTabSize()) : ++res;
            ++i;
        }
        return res;
    }

    public static int getIndentVisualLength(ITabPreferencesProvider prefs, IDocument document, int lineIndex) throws BadLocationException {
        int lineOffset = document.getLineOffset(lineIndex);
        int lineLength = document.getLineLength(lineIndex);
        int lineHome = AutoEditUtils.findEndOfWhiteSpace(document, lineOffset, lineOffset + lineLength);
        return AutoEditUtils.calculateVisualLength(prefs, document, lineOffset, lineLength, lineOffset, lineHome);
    }

    public static int getMaximumLineDelimiterLength(IDocument document) {
        String[] lineDelimiters = document.getLegalLineDelimiters();
        int length = 0;
        int i = 0;
        while (i < lineDelimiters.length) {
            length = Math.max(length, lineDelimiters[i].length());
            ++i;
        }
        return length;
    }

    public static boolean atEndOfLine(IDocument document, int offset, int endOffset) throws BadLocationException {
        if (offset == endOffset) {
            return true;
        }
        int maxDelta = AutoEditUtils.getMaximumLineDelimiterLength(document);
        if (offset + maxDelta < endOffset) {
            return false;
        }
        String s = document.get(offset, Math.min(maxDelta, document.getLength() - offset));
        String[] searchStrings = document.getLegalLineDelimiters();
        int i = 0;
        while (i < searchStrings.length) {
            if (s.startsWith(searchStrings[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

