/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.editor;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public abstract class AnnotatedImageDescriptor
extends CompositeImageDescriptor {
    private Point fSize;
    private ImageDescriptor fBaseImage;

    protected static ImageData getImageData(ImageDescriptor descriptor) {
        ImageData data;
        if (descriptor != null && (data = descriptor.getImageData()) != null) {
            return data;
        }
        return DEFAULT_IMAGE_DATA;
    }

    public AnnotatedImageDescriptor(ImageDescriptor baseImageDescriptor, Point size) {
        this.fBaseImage = baseImageDescriptor;
        this.fSize = size;
    }

    public void setImageSize(Point size) {
        this.fSize = size;
    }

    protected Point getSize() {
        return this.fSize;
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData bg = AnnotatedImageDescriptor.getImageData(this.fBaseImage);
        if (bg != null) {
            this.drawImage(bg, 0, 0);
        }
        this.drawAnnotations();
    }

    protected void drawImageTopRight(ImageData data) {
        Point size = this.getSize();
        this.drawImage(data, size.x - data.width, 0);
    }

    protected void drawImageTopLeft(ImageData data) {
        this.drawImage(data, 0, 0);
    }

    protected void drawImageBottomRight(ImageData data) {
        Point size = this.getSize();
        this.drawImage(data, size.x - data.width, size.y - data.height);
    }

    protected void drawImageBottomLeft(ImageData data) {
        Point size = this.getSize();
        this.drawImage(data, 0, size.y - data.height);
    }

    protected abstract void drawAnnotations();
}

