/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.launching;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.internal.launching.DLTKLaunchingPlugin;
import org.eclipse.dltk.launching.ExecutionArguments;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallChangedListener;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.IInterpreterRunner;
import org.eclipse.dltk.launching.LibraryLocation;
import org.eclipse.dltk.launching.PropertyChangeEvent;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.launching.debug.DebuggingEngineManager;
import org.eclipse.dltk.launching.debug.IDebuggingEngine;

public abstract class AbstractInterpreterInstall
implements IInterpreterInstall {
    private IInterpreterInstallType fType;
    private String fId;
    private String fName;
    private File fInstallLocation;
    private LibraryLocation[] fSystemLibraryDescriptions;
    private String fInterpreterArgs;
    private boolean fNotify = true;

    private void firePropertyChangeEvent(PropertyChangeEvent event) {
        if (this.fNotify) {
            ScriptRuntime.fireInterpreterChanged(event);
        }
    }

    public AbstractInterpreterInstall(IInterpreterInstallType type, String id) {
        if (type == null || id == null) {
            throw new IllegalArgumentException();
        }
        this.fType = type;
        this.fId = id;
    }

    public String getId() {
        return this.fId;
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String name) {
        if (!name.equals(this.fName)) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, IInterpreterInstallChangedListener.PROPERTY_NAME, this.fName, name);
            this.fName = name;
            this.firePropertyChangeEvent(event);
        }
    }

    public File getInstallLocation() {
        return this.fInstallLocation;
    }

    public void setInstallLocation(File installLocation) {
        if (!installLocation.equals(this.fInstallLocation)) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, IInterpreterInstallChangedListener.PROPERTY_INSTALL_LOCATION, this.fInstallLocation, installLocation);
            this.fInstallLocation = installLocation;
            this.firePropertyChangeEvent(event);
        }
    }

    public IInterpreterInstallType getInterpreterInstallType() {
        return this.fType;
    }

    public LibraryLocation[] getLibraryLocations() {
        return this.fSystemLibraryDescriptions;
    }

    public void setLibraryLocations(LibraryLocation[] locations) {
        LibraryLocation[] prevLocations;
        if (locations == this.fSystemLibraryDescriptions) {
            return;
        }
        LibraryLocation[] newLocations = locations;
        if (newLocations == null) {
            newLocations = this.getInterpreterInstallType().getDefaultLibraryLocations(this.getInstallLocation());
        }
        if ((prevLocations = this.fSystemLibraryDescriptions) == null) {
            prevLocations = this.getInterpreterInstallType().getDefaultLibraryLocations(this.getInstallLocation());
        }
        if (newLocations.length == prevLocations.length) {
            int i = 0;
            boolean equal = true;
            while (i < newLocations.length && equal) {
                equal = newLocations[i].equals(prevLocations[i]);
                ++i;
            }
            if (equal) {
                return;
            }
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, IInterpreterInstallChangedListener.PROPERTY_LIBRARY_LOCATIONS, prevLocations, newLocations);
        this.fSystemLibraryDescriptions = locations;
        this.firePropertyChangeEvent(event);
    }

    protected void setNotify(boolean notify) {
        this.fNotify = notify;
    }

    public boolean equals(Object object) {
        if (object instanceof IInterpreterInstall) {
            IInterpreterInstall Interpreter = (IInterpreterInstall)object;
            return this.getInterpreterInstallType().equals(Interpreter.getInterpreterInstallType()) && this.getId().equals(Interpreter.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getInterpreterInstallType().hashCode() + this.getId().hashCode();
    }

    public String[] getInterpreterArguments() {
        String args = this.getInterpreterArgs();
        if (args == null) {
            return null;
        }
        ExecutionArguments ex = new ExecutionArguments(args, "");
        return ex.getInterpreterArgumentsArray();
    }

    public void setInterpreterArguments(String[] InterpreterArgs) {
        if (InterpreterArgs == null) {
            this.setInterpreterArgs(null);
        } else {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < InterpreterArgs.length) {
                String string = InterpreterArgs[i];
                buf.append(string);
                buf.append(' ');
                ++i;
            }
            this.setInterpreterArgs(buf.toString().trim());
        }
    }

    public String getInterpreterArgs() {
        return this.fInterpreterArgs;
    }

    public void setInterpreterArgs(String InterpreterArgs) {
        if (this.fInterpreterArgs == null ? InterpreterArgs == null : this.fInterpreterArgs.equals(InterpreterArgs)) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, IInterpreterInstallChangedListener.PROPERTY_Interpreter_ARGUMENTS, this.fInterpreterArgs, InterpreterArgs);
        this.fInterpreterArgs = InterpreterArgs;
        this.firePropertyChangeEvent(event);
    }

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, DLTKLaunchingPlugin.getUniqueIdentifier(), code, message, exception));
    }

    public String[] getBuiltinModules() {
        return null;
    }

    public String getBuiltinModuleContent(String name) {
        return null;
    }

    public IInterpreterRunner getInterpreterRunner(String mode) {
        if (mode.equals("debug")) {
            String natureId = this.getNatureId();
            DebuggingEngineManager manager = DebuggingEngineManager.getInstance();
            IDebuggingEngine engine = manager.getSelectedDebuggineEngine(natureId);
            if (engine != null) {
                return engine.getRunner(this);
            }
        }
        return null;
    }
}

