/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.dltk.dbgp.IDbgpSession;
import org.eclipse.dltk.dbgp.IDbgpThreadAcceptor;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.debug.core.model.IScriptThread;
import org.eclipse.dltk.internal.debug.core.model.DebugEventHelper;
import org.eclipse.dltk.internal.debug.core.model.IDbgpThreadManagerListener;
import org.eclipse.dltk.internal.debug.core.model.ScriptDebugTarget;
import org.eclipse.dltk.internal.debug.core.model.ScriptThread;

public class ScriptThreadManager
implements IDbgpThreadAcceptor,
ITerminate,
ISuspendResume {
    private final ListenerList listeners = new ListenerList(1);
    private final List threads = new ArrayList();
    private volatile boolean waitingForThreads = true;
    private final ScriptDebugTarget target;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean getThreadBoolean(IThreadBoolean b) {
        List list = this.threads;
        synchronized (list) {
            IScriptThread[] ths = this.getThreads();
            if (ths.length == 0) {
                return false;
            }
            int i = 0;
            while (true) {
                if (i >= ths.length) {
                    return true;
                }
                if (!b.get(ths[i])) {
                    return false;
                }
                ++i;
            }
        }
    }

    protected void fireThreadAccepted(IScriptThread thread, boolean first) {
        Object[] list = this.listeners.getListeners();
        int i = 0;
        while (i < list.length) {
            ((IDbgpThreadManagerListener)list[i]).threadAccepted(thread, first);
            ++i;
        }
    }

    protected void fireAllThreadsTerminated() {
        Object[] list = this.listeners.getListeners();
        int i = 0;
        while (i < list.length) {
            ((IDbgpThreadManagerListener)list[i]).allThreadsTerminated();
            ++i;
        }
    }

    public void addListener(IDbgpThreadManagerListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(IDbgpThreadManagerListener listener) {
        this.listeners.remove((Object)listener);
    }

    public boolean isWaitingForThreads() {
        return this.waitingForThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasThreads() {
        List list = this.threads;
        synchronized (list) {
            return !this.threads.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IScriptThread[] getThreads() {
        List list = this.threads;
        synchronized (list) {
            return this.threads.toArray(new IScriptThread[this.threads.size()]);
        }
    }

    public ScriptThreadManager(ScriptDebugTarget target) {
        if (target == null) {
            throw new IllegalArgumentException();
        }
        this.target = target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptDbgpThread(IDbgpSession session) {
        List list = this.threads;
        synchronized (list) {
            try {
                ScriptThread thread = new ScriptThread(this.target, session, this);
                this.threads.add(thread);
                boolean isFirstThread = this.waitingForThreads;
                this.waitingForThreads = false;
                this.fireThreadAccepted(thread, isFirstThread);
                DebugEventHelper.fireCreateEvent(thread);
                thread.resume();
            }
            catch (Exception e) {
                DLTKDebugPlugin.log(e);
            }
        }
    }

    public void acceptDbgpThreadNotUnavailable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateThread(IScriptThread thread) {
        List list = this.threads;
        synchronized (list) {
            this.threads.remove(thread);
            DebugEventHelper.fireTerminateEvent((IDebugElement)thread);
            if (!this.hasThreads()) {
                this.fireAllThreadsTerminated();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canTerminate() {
        List list = this.threads;
        synchronized (list) {
            IScriptThread[] ths = this.getThreads();
            if (ths.length == 0) {
                return this.waitingForThreads;
                {
                }
            }
            int i = 0;
            while (true) {
                if (i >= ths.length) {
                    return true;
                }
                if (!ths[i].canTerminate()) {
                    return false;
                }
                ++i;
            }
        }
    }

    public boolean isTerminated() {
        if (!this.hasThreads()) {
            return !this.isWaitingForThreads();
        }
        return this.getThreadBoolean(new IThreadBoolean(){

            public boolean get(IThread thread) {
                return thread.isTerminated();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() throws DebugException {
        List list = this.threads;
        synchronized (list) {
            IScriptThread[] threads = this.getThreads();
            int i = 0;
            while (i < threads.length) {
                threads[i].terminate();
                ++i;
            }
            this.waitingForThreads = false;
        }
    }

    public boolean canResume() {
        return this.getThreadBoolean(new IThreadBoolean(){

            public boolean get(IThread thread) {
                return thread.canResume();
            }
        });
    }

    public boolean canSuspend() {
        return this.getThreadBoolean(new IThreadBoolean(){

            public boolean get(IThread thread) {
                return thread.canSuspend();
            }
        });
    }

    public boolean isSuspended() {
        return this.getThreadBoolean(new IThreadBoolean(){

            public boolean get(IThread thread) {
                return thread.isSuspended();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() throws DebugException {
        List list = this.threads;
        synchronized (list) {
            IScriptThread[] threads = this.getThreads();
            int i = 0;
            while (i < threads.length) {
                threads[i].resume();
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() throws DebugException {
        List list = this.threads;
        synchronized (list) {
            IScriptThread[] threads = this.getThreads();
            int i = 0;
            while (i < threads.length) {
                threads[i].suspend();
                ++i;
            }
        }
    }

    private static interface IThreadBoolean {
        public boolean get(IThread var1);
    }
}

