/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IOpenable;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ArchiveProjectFragment;
import org.eclipse.dltk.internal.core.ExternalScriptFolder;
import org.eclipse.dltk.internal.core.ModelStatus;
import org.eclipse.dltk.internal.core.MultiOperation;
import org.eclipse.dltk.internal.core.util.Messages;

public class DeleteResourceElementsOperation
extends MultiOperation {
    protected DeleteResourceElementsOperation(IModelElement[] elementsToProcess, boolean force) {
        super(elementsToProcess, force);
    }

    private void deleteScriptFolder(IScriptFolder frag) throws ModelException {
        IResource res = frag.getResource();
        if (res != null) {
            IResource fragResource;
            IResource[] remainingFiles;
            IModelElement[] childrenOfInterest = frag.getChildren();
            if (childrenOfInterest.length > 0) {
                IResource[] resources = new IResource[childrenOfInterest.length];
                int i = 0;
                while (i < childrenOfInterest.length) {
                    resources[i] = childrenOfInterest[i].getCorrespondingResource();
                    ++i;
                }
                this.deleteResources(resources, this.force);
            }
            Object[] nonScriptResources = frag.getForeignResources();
            int actualResourceCount = 0;
            int i = 0;
            int max = nonScriptResources.length;
            while (i < max) {
                if (nonScriptResources[i] instanceof IResource) {
                    ++actualResourceCount;
                }
                ++i;
            }
            IResource[] actualNonScriptResources = new IResource[actualResourceCount];
            int i2 = 0;
            int max2 = nonScriptResources.length;
            int index = 0;
            while (i2 < max2) {
                if (nonScriptResources[i2] instanceof IResource) {
                    actualNonScriptResources[index++] = (IResource)nonScriptResources[i2];
                }
                ++i2;
            }
            this.deleteResources(actualNonScriptResources, this.force);
            try {
                remainingFiles = ((IContainer)res).members();
            }
            catch (CoreException ce) {
                throw new ModelException(ce);
            }
            boolean isEmpty = true;
            int i3 = 0;
            int length = remainingFiles.length;
            while (i3 < length) {
                isEmpty = false;
                ++i3;
            }
            if (isEmpty && !frag.isRootFolder() && (fragResource = frag.getResource()) != null) {
                this.deleteEmptyScriptFolder(frag, false, (IResource)fragResource.getParent());
            }
        }
    }

    protected String getMainTaskName() {
        return Messages.operation_deleteResourceProgress;
    }

    protected void processElement(IModelElement element) throws ModelException {
        switch (element.getElementType()) {
            case 5: {
                this.deleteResource(element.getResource(), this.force ? 3 : 2);
                break;
            }
            case 4: {
                this.deleteScriptFolder((IScriptFolder)element);
                break;
            }
            default: {
                throw new ModelException(new ModelStatus(967, element));
            }
        }
        if (element instanceof IOpenable) {
            ((IOpenable)element).close();
        }
    }

    protected void verify(IModelElement element) throws ModelException {
        int type;
        if (element == null || !element.exists()) {
            this.error(969, element);
        }
        if ((type = element.getElementType()) <= 3 || type > 5) {
            this.error(967, element);
        } else if (type == 4 && element instanceof ArchiveProjectFragment && element instanceof ExternalScriptFolder) {
            this.error(967, element);
        }
        IResource resource = element.getResource();
        if (resource instanceof IFolder && resource.isLinked()) {
            this.error(995, element);
        }
    }
}

